<?php

class FinanceController extends Controller
{
	public function accessRules()
        {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','Save','Delete','GetFinanceInterest'),
                     'expression' => '$user->isMember()',
                ),
                 array('deny', // deny all users
                    'users' => array('*'),
                  ),
            );
        }
        public function actionIndex()
	{
		$this->render('index');
	}
        public function actionCreate()
        {
            $id = (int) Yii::app()->request->getParam('id');
            $building_id = (int) Yii::app()->request->getParam('building_id');
            $flat_id = (int) Yii::app()->request->getParam('flat_id');
            $model = new Finance();
            if($id > 0)
            {
                $model  = $model->findByPk($id);
                
            }
            Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
            $this->render('create',array(
                        'model'=>$model,
                        'title' => 'Add Finance',
                        'building_id'=>$building_id,
                        'flat_id'=>$flat_id
            ));
        }
        public function actionSave()
        {
            $model=new Finance();
            if (isset($_POST['Finance'])) {
                if ((int) @$_POST['Finance']['id'] > 0) {
                    $model->id = (int) $_POST['Finance']['id'];
                    $model = $model->findByPK($model->id);
                    $model->updated_by  = Yii::app()->user->id;
                    $model->updated_date_time = date('Y-m-d h:i:s');
                }else {
                    $model->created_by  = Yii::app()->user->id;
                    $model->created_date_time = date('Y-m-d h:i:s');
                }
                    $model->attributes          = $_POST['Finance'];
                    if($_POST['Finance']['payment_date']!='')
                        $model->payment_date         = DateTime::createFromFormat('d/m/Y', $_POST['Finance']['payment_date'])->format('Y-m-d');
                    $model->flat_id             = isset($_POST['flat_id'])?$_POST['flat_id']:'';
                    $model->loan_percen         = isset($_POST['Finance']['loan_percen'])?$_POST['Finance']['loan_percen']:'';
                    $model->installment_no      = isset($_POST['Finance']['installment_no'])?$_POST['Finance']['installment_no']:'';
                    $model->pdc_amount          = isset($_POST['Finance']['pdc_amount'])?$_POST['Finance']['pdc_amount']:'';
                    $model->building_id         = isset($_POST['building_id'])?$_POST['building_id']:'';
                    $model->loan_amount         = isset($_POST['Finance']['loan_amount'])?$_POST['Finance']['loan_amount']:'';
                    $model->interest_percen     = isset($_POST['Finance']['interest_percen'])?$_POST['Finance']['interest_percen']:'';
                    $model->interest_type       = isset($_POST['Finance']['interest_type'])?$_POST['Finance']['interest_type']:'';
                    if ($model->save())
                    {
                            $jsonData['status'] = 'success';
                            $jsonData['id']     = $model->id;
                            echo CJSON::encode($jsonData);
                    }
                    else
                    {
                            $error = CActiveForm::validate($model, '', false);
                            if ($error != '[]')
                                echo $error;
                    }
            }
        }
        public function actionGetFinanceInterest() {
            $building               = $_POST['building_id'];
            $flat = $_POST['flat_id'] ?? 0;
            $model                  = new Finance();
            if($building>0){
                $finance_model          = $model->find(array('condition'=>'building_id='.$building));
                $arr_cheque_details     = Payment::model()->with('building_details','landlord_details')->findAll(array('condition'=>'t.building_id='.$building.' AND t.payment_type =2 AND t.status =1' ));
            }
            if($flat>0){
                $finance_model          = $model->find(array('condition'=>'flat_id='.$flat));
                $arr_cheque_details     = Payment::model()->with('building_details','landlord_details')->findAll(array('condition'=>'t.flat_id='.$flat.' AND t.payment_type =2 AND t.status =1' ));
            
            }
            $down_pay_date          = $finance_model->payment_date;
            $today                  = date("Y-m-d");
            $diff                   = abs(strtotime($today) - strtotime($down_pay_date));
            $years                  = floor($diff / (365*60*60*24));
            $months                 = floor($diff/ (30*60*60*24));
            $interest_amount        = 0;
            if($finance_model->down_payment >0 && $finance_model->interest_percen>0){
                $interest_amount    = (($finance_model->down_payment*$finance_model->interest_percen*$months)/(100*12));
            }
            $div_details            = '<table class="table table-striped table-primary" id="tab_cheque_details">';
            $div_details            .= '<tr>';
            $div_details            .= '<th colspan="2"> Down Payment</th><th>  Interest %</th><th>No.of.Months</th><th> InterestAmount</th>';
            $div_details            .= '</tr>';
            $div_details            .= '<tr>';
            $div_details            .= '<td  colspan="2">'.Yii::app()->numberFormatter->formatCurrency($finance_model->down_payment,"").'</td><td>'.$finance_model->interest_percen.'</td><td>'.$months.'</td><td class="text-right"> '.Yii::app()->numberFormatter->formatCurrency($interest_amount,"").'</td>';
            $div_details            .= '</tr>';
            $div_details            .= '<tr>';
            $div_details            .= '<th> Cheque No</th><th> Cheque Amount</th><th> RealisationDate</th><th> No.of.Months</th><th> InterestAmount</th>';
            $div_details            .= '</tr>';
            $total_linterest        = 0;
            $lmonths                 = 0;
            if(!empty($arr_cheque_details)){
                foreach ($arr_cheque_details as $each_detail){
                    $realisation_date       = $each_detail->realisation_date;
                    if($realisation_date !="0000-00-00"){
                        $diff                   = abs(strtotime($today) - strtotime($realisation_date));
                        $lmonths                 = floor($diff/ (30*60*60*24));
                        $linterest_amount        = 0;
                        if($each_detail->amount >0 && $finance_model->loan_percen>0){
                            $linterest_amount    = (($each_detail->amount*$finance_model->loan_percen*$lmonths)/(100*12));
                            $total_linterest    += $linterest_amount;
                        }
                        $div_details            .= '<tr>';
                        $div_details            .= '<td>'.$each_detail->cheque_no.'</td><td>'.Yii::app()->numberFormatter->formatCurrency($each_detail->amount,"").'</td><td>'. date("d/m/Y",strtotime($realisation_date)).'</td><td>'.$lmonths.'</td><td class="text-right"> '.Yii::app()->numberFormatter->formatCurrency($linterest_amount,"").'</td>';
                        $div_details            .= '</tr>';
                    }
                }
                
            }else{
                $div_details            .= '<tr>';
                $div_details            .= '<td colspan="4"> No Details Found</td>';
                $div_details            .= '</tr>';
            }
            $total_interest=$interest_amount+$total_linterest;
            $div_details            .= '<tr>';
            $div_details            .= '<th colspan="4"> Total</th>';
            $div_details            .= '<td class="text-right"> '.Yii::app()->numberFormatter->formatCurrency($total_interest,"").'</td>';
            $div_details            .= '</tr>';
            $div_details            .= '</table>';
            echo $div_details;       
            
        }
        public function actionDelete()
        {
                    $id = $_POST['id'];
                    $model=new Finance();
                    $model->deleteByPk($id);
                    echo "success";
        }
	
}