<?php

class ExpensetypeController extends Controller
{
        public function filters()

	{

		return array(

			'accessControl', // perform access control for CRUD operations

		);

	}


	public function accessRules()
        {

            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','SaveExpenseType','DeleteExpense'),
                     'expression' => '$user->isMember()',
                ),
                 array('deny', // deny all users
                    'users' => array('*'),
                  ),

            );

        }

	public function actionIndex()
	{
                $model = ExpenseType::model()->findAll(array('condition'=>'isActive="Y"'));
                $this->render('index',array(
                     'model'=>$model,
                ));

	}

        public function actionCreate()
	{

            $id = (int) Yii::app()->request->getParam('id');
            
	    $model = new ExpenseType();
            
            if($id > 0)
            {
    		$model=$model->findByPk($id);
            }

                Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

		$this->render('create',array(

			'model'=>$model,

                        'title' => 'Add New Expense Type'

		));
       }

    public function actionSaveExpenseType()
    {
    	$model=new ExpenseType();
    	/************ START Code for Save ***************/
    	if (isset($_POST['ExpenseType'])) {
    		
    		if ((int) @$_POST['ExpenseType']['id'] > 0) {
    			$model->id = (int) $_POST['ExpenseType']['id'];
                        $model = $model->findByPK($model->id);
                }                        
    			$model->attributes = $_POST['ExpenseType'];
	    		if ($model->save())
	    		{
	    			$jsonData['status'] = 'success';
	                        echo CJSON::encode($jsonData);
	    		}
	    		else
	    		{
		    		$error = CActiveForm::validate($model, '', false);
		                if ($error != '[]')
		                    echo $error;
		        }
    	}
     }

    public function actionDeleteExpense()
    {
                $id = $_POST['id'];
                $model=new ExpenseType();
                $model->deleteByPk($id);
                echo "success";
    }
}