<?php
class ExpenseController extends Controller
{
    public function filters()
    {
            return array(
                    'accessControl', // perform access control for CRUD operations
            );
    }
    public function accessRules()
    {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
              ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','Create','Save','Delete','getSubledgerByExpensetype','getFlat','expensePrint'),
                 'expression' => '$user->isMember()',
            ),
             array('deny', // deny all users
                'users' => array('*'),
              ),
        );
    }
    public function actionIndex()
    {
            $model = Expense::model()->findAll(array('condition'=>'status="1"'));
            $this->render('index',array(
                 'model'=>$model,
            ));
    }
    public function actionCreate()
    {
            $id = (int) Yii::app()->request->getParam('id');
        $model = new Expense();
            if($id > 0)
            {
            $model=$model->findByPk($id);
            }
                Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('create',array(
            'model'=>$model,
                        'title' => 'Add New Expense'
        ));
       }
    public function actionSave()
    {
        $model=new Expense();
        /************ START Code for Save ***************/
        if (isset($_POST['Expense'])) {
            if ((int) @$_POST['Expense']['id'] > 0) {
                $model->id = (int) $_POST['Expense']['id'];
                        $model = $model->findByPK($model->id);
                        $model->updated_by  = Yii::app()->user->id;
                $model->updated_date = date('Y-m-d');
                }else {
                $model->created_by  = Yii::app()->user->id;
                $model->created_date = date('Y-m-d');
            }
                $model->attributes          = $_POST['Expense'];
                $model->expense_date        = DateTime::createFromFormat('d/m/Y', $_POST['Expense']['expense_date'])->format('Y-m-d');
                if($_POST['Expense']['payment_type']=='2'){
                    if($_POST['Expense']['cheque_date']!='')
                    $model->cheque_date         = DateTime::createFromFormat('d/m/Y', $_POST['Expense']['cheque_date'])->format('Y-m-d');
                    $model->cheque_no           = $_POST['Expense']['cheque_no'];
                    $model->bank_id             = $_POST['Expense']['bank_id'];
                    $model->payment_type        = $_POST['Expense']['payment_type'];
                }
                $model->flat_id             = $_POST['Expense']['flat_id'];
                $model->remarks             = $_POST['Expense']['remarks'];
                $model->subledger_id        = $_POST['Expense']['subledger_id'];
                $subledger_count            = 0;
                if(isset($_POST['Expense']['expense_type']) && $_POST['Expense']['expense_type']!='')
                    $subledger_count = Yii::app()->db->createCommand('SELECT COUNT(*) FROM re_subledger WHERE expense_type_id ='. $_POST['Expense']['expense_type'])->queryScalar();
                $model->subledger_count = 0;
                if($subledger_count > 0){
                 $model->subledger_count = $subledger_count;
                }
                if ($model->save())
                {
                        $jsonData['status'] = 'success';
                        echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
                            echo $error;
                }
        }
    }
    public function actionDelete()
    {
                $id = $_POST['id'];
                $model=new Expense();
                $model->deleteByPk($id);
                echo "success";
    }
    public function actiongetSubledgerByExpensetype()
    {
        $id=Yii::app()->request->getparam("expense_type");
        $condition = 'isActive =  "Y" AND expense_type_id="'.$id.'" ';
        $status=0;
    $model = SubLedger::model()->findAll(array('condition' => $condition));
        $drop= '<li class="form-add col-sm-6"><div class="icon-box fa-book material m1">' ;
        $details=CHtml::listData($model, 'id', 'sub_ledger');
        if(!empty($details))
            $status=1;
        $drop.=CHtml::dropDownList('Expense[subledger_id]','' , $details,  array('class'=>'','placeholder'=>'Subledger <span class="red">*</span>'), array('options' => array('title'=>array('selected'=>true))));
        $drop.='</div></li>';
        $status=array("dt" => $drop,"status" => $status);
        echo CJSON::encode($status);
    }
    public function actiongetFlat()
    {
       $id=Yii::app()->request->getparam("building_id");
        $condition = 'building_id="'.$id.'" ';
        $status=0;
    $model = Flat::model()->findAll(array('condition' => $condition));
        $flat= '<li class="form-add col-sm-6"><div class="icon-box fa-th-list material m1">' ;
        $details=CHtml::listData($model, 'id', 'flat_no');
        if(!empty($details))
            $status=1;
        $flat.=CHtml::dropDownList('Expense[flat_id]','' , $details,  array('class'=>'','placeholder'=>'Flat'), array('options' => array('title'=>array('selected'=>true))));
        $flat.='</div></li>';
        $status=array("ft" => $flat,"status" => $status);
        echo CJSON::encode($status);
    }
    public function actionExpensePrint(){
        $receipt_id=Yii::app()->request->getParam('receipt_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        ob_start();
        $stylesheet = file_get_contents('css/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.admin.expense.print_expense', array('receipt_id' => $receipt_id), true));
         ob_end_clean();
        $mPDF1->Output();
    }
}