<?php



class DashboardController extends Controller

{

    public function filters()

    {



            return array(



                    'accessControl', // perform access control for CRUD operations



            );



    }

    public function accessRules()

    {



        return array(

            array('allow', // allow all users to perform 'index' and 'view' actions

                'actions' => array('login', 'error', 'logout'),

                'users' => array('*'),

              ),

            array('allow', // allow authenticated user to perform 'create' and 'update' actions

                'actions' => array('index','payments','receipts','constructionflats','vaccantflats','tenancyexpiry',

                    'getTenancytable','getReceiptTable','GetPaymentTable','getConstructionFlatTable','getVacantFlatTable','GetDocDetails',

                    'Uploads','getUploadTable','CreateDocument','SaveDocument','Upload'),

                 'expression' => '$user->isMember()',

            ),

             array('deny', // deny all users

                'users' => array('*'),

              ),

            

        );



    }

    public function actionIndex() 

    {

        $this->render('index');

    }

    public function actionPayments() 

    {

        $frm = Yii::app()->request->getParam('frm');

        $this->render('payments',array('frm'=>$frm));

    }

    public function actionReceipts() 

    {

        $frm = Yii::app()->request->getParam('frm');

        $this->render('receipt',array('frm'=>$frm));

    }

    public function actionVaccantFlats() 

    {

        $this->render('vacantflat');

    }

    public function actionTenancyExpiry() 

    {

        $frm = Yii::app()->request->getParam('frm');

        $this->render('tenancy_expiry',array('frm'=>$frm));

    }

    public function actionConstructionFlats() 

    {

        $this->render('constructionflat');

    }

    public function actionUploads() 

    {

        $this->render('uploads');

    }

    public function actionCreateDocument(){

        $type         = (int) Yii::app()->request->getParam('type');

        $model      = new PurchasedDocuments();

        Yii::app()->clientScript->scriptMap = array( 'jquery.min.js' => false);

            $this->render('createdocument',array(

                    'model'=>$model,

                    'title' => 'Add New Document'

            ));

    }

    public function actionGetDocDetails(){

        $type = Yii::app()->request->getParam('type');

        if($type==1){

            $div_details            .= '<li class="form-add col-sm-6">';

            $div_details         .= '<div class="icon-box fa-list material m1">';

            $div_details         .= CHtml::dropDownList('upload_building','', Building::getAllBuilding(),array('placeholder'=>'Select Building','class' =>'form-control','prompt'=>'Select Building'));

            $div_details         .= '</div>';

            $div_details         .= '</li>';            

        }

        if($type==2){

            $div_details            .= '<li class="form-add col-sm-6">';

            $div_details         .= '<div class="icon-box fa-list material m1">';

            $div_details         .= CHtml::dropDownList('upload_flat','', Flat::getAllFlat(),array('placeholder'=>'Select Flat','class' =>'form-control','prompt'=>'Select Flat'));

            $div_details         .= '</div>';

            $div_details         .= '</li>';            

        }

        if($type==3){

            $div_details            .= '<li class="form-add col-sm-6">';

            $div_details         .= '<div class="icon-box fa-list material m1">';

            $div_details         .= CHtml::dropDownList('upload_land','', Building::getLand(),array('placeholder'=>'Select Land','class' =>'form-control','prompt'=>'Select Land'));

            $div_details         .= '</div>';

            $div_details         .= '</li>';            

        }

        if($type==4){

            $div_details            .= '<li class="form-add col-sm-6">';

            $div_details         .= '<div class="icon-box fa-user material m1">';

            $div_details         .= CHtml::dropDownList('upload_owner','', Landlord::getAllLandlord(),array('placeholder'=>'Select Owner','class' =>'form-control','prompt'=>'Select Owner'));

            $div_details         .= '</div>';

            $div_details         .= '</li>';            

        }

        echo $div_details;  

    }

    public function actionSaveDocument(){

        $other_error =$error1= array();

        $type = $_POST['doc_type'];

        $doc_name =$_POST['document_file'];

        $file_name =$_POST['file_name'];

        if($type!='' && $doc_name!='' && $file_name !=''){

            if($type==1){

                $model=new PurchasedDocuments();

                $building_id =  $_POST['upload_building'];

                if($building_id>0){

                    $model=new PurchasedDocuments();

                    $model->created_by = Yii::app()->user->id;

                    $model->created_date_time = date('Y-m-d h:i:s');

                    $model->document_file   = $doc_name;

                    $model->building_id     = $building_id;

                  //  $model->flat_id         = $flat_id;

                    $model->purchased_type  = '1';

                    $model->file_name       = $file_name;

                    $error1 =  json_decode(CActiveForm::validate($model, '', false), true);

                }else{

                    $other_error[]="Please Select Building";

                }

            }

            else if($type==2){

                $model=new PurchasedDocuments();

                $flat_id =  $_POST['upload_flat'];

                if($flat_id>0){

                    $model=new PurchasedDocuments();

                    $model->created_by = Yii::app()->user->id;

                    $model->created_date_time = date('Y-m-d h:i:s');

                    $model->document_file   = $doc_name;

                    $model->building_id     = Flat::model()->findByPk($flat_id)->building_id;

                    $model->flat_id         = $flat_id;

                    $model->purchased_type  = '2';

                    $model->file_name       = $file_name;

                    $error1 =  json_decode(CActiveForm::validate($model, '', false), true);

                }else{

                    $other_error[]="Please Select Flat";

                }

            }

            else if($type==3){

                $model=new PurchasedDocuments();

                $land_id =  $_POST['upload_land'];

                if($land_id>0){

                    $model->created_by = Yii::app()->user->id;

                    $model->created_date_time = date('Y-m-d h:i:s');

                    $model->document_file   = $doc_name;

                    $model->building_id     = $land_id;

                    $model->purchased_type  = '3';

                    $model->file_name       = $file_name;

                    $error1 =  json_decode(CActiveForm::validate($model, '', false), true);

                }else{

                    $other_error[]="Please Select Land";

                }

            }

            else if($type==4){

                $model=new LandlordDocument();

                $owner_id =  $_POST['upload_owner'];

                if($owner_id>0){

                    $model->created_by = Yii::app()->user->id;

                    $model->created_date_time = date('Y-m-d h:i:s');

                    $model->document_file = $doc_name;

                    $model->landlord_id = $owner_id;

                    $model->file_name       = $file_name;

                    $error1 =  json_decode(CActiveForm::validate($model, '', false), true);                    

                }else{

                    $other_error[]="Please Select Owner";

                }

            }

            

        }

        else{

            if($type==''){

                $other_error[]="Please Select Type";

            }

            if($doc_name==''){

                $other_error[]="Please Upload Document";

            }

            if($file_name==''){

                $other_error[]="Please Enter File Name";

            }

        }

        $error = CJSON::encode(array_merge_recursive($other_error,$error1));

       

        

        if ($error != '[]')

            echo $error;

        else{

            if($model->save()){

                $jsonData['status'] = 'success';

                echo CJSON::encode($jsonData);

            }

        }

            

        

    }

    public function actionGetUploadtable()

    {

        $building_id    = $_POST['building_id'];

        $landlord_id    = $_POST['landlord_id'];

        $this->renderPartial('upload_table', array('building_id'=>$building_id,'landlord_id'=>$landlord_id));        

    }

    public function actionGetTenancytable()

    {

        $building_id    = $_POST['building_id'];

        $year_id        = $_POST['year_id'];

        $month_id       = $_POST['month_id'];

        $landlord_id    = $_POST['landlord_id'];

        $this->renderPartial('tenancyexpiry_table', array('month_id'=>$month_id,'building_id'=>$building_id,'year_id'=>$year_id,'landlord_id'=>$landlord_id));        

    }

    public function actionGetReceiptTable()

    {

        $building_id = $_POST['building_id'];

        $year_id = $_POST['year_id'];

        $month_id = $_POST['month_id'];

        $status = $_POST['status'];

        $type_id =$_POST['type_id'];

        $landlord_id    = $_POST['landlord_id'];

        $this->renderPartial('receipt_table', array('month_id'=>$month_id,'building_id'=>$building_id,'landlord_id'=>$landlord_id,'year_id'=>$year_id,'status'=>$status,'type_id'=>$type_id));        

    }

    public function actionGetPaymentTable()

    {

        $landlord_id = $_POST['landlord_id'];

        $building_id = $_POST['building_id'];

        $flat_id = $_POST['flat_id'];

        $year_id = $_POST['year_id'];

        $month_id = $_POST['month_id'];

        $status = $_POST['status'];

        $this->renderPartial('payment_table', array('month_id'=>$month_id,'building_id'=>$building_id,'flat_id'=>$flat_id,'landlord_id'=>$landlord_id,'year_id'=>$year_id,'status'=>$status,'frm'=>'0'));        

    }

    public function actionGetConstructionFlatTable()

    {

        $landlord_id = $_POST['landlord_id'];

        $building_id = $_POST['building_id'];

        $this->renderPartial('constructionflat_table', array('landlord_id'=>$landlord_id,'building_id'=>$building_id));        

    }

    public function actionGetVacantFlatTable()

    {

        $landlord_id = $_POST['landlord_id'];

        $building_id = $_POST['building_id'];

        $this->renderPartial('vacantflat_table', array('landlord_id'=>$landlord_id,'building_id'=>$building_id));        

    }

    

}