<?php

class BuildingController extends Controller
{
        public function filters()

	{

		return array(

			'accessControl', // perform access control for CRUD operations

		);

	}
        public function accessRules()
        {

            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','Save','Delete'),
                     'expression' => '$user->isMember()',
                ),
                 array('deny', // deny all users
                    'users' => array('*'),
                  ),

            );

        }
        public function actionIndex()
	{
                $model = Building::model()->findAll(array('condition'=>'status="Y" AND purchase_status=0'));
                $this->render('index',array(
                     'model'=>$model,
                ));

	}

        public function actionCreate()
	{

            $id = (int) Yii::app()->request->getParam('id');
            
	    $model = new Building();
            
            $model_owner = new BuildingOwnerDetails();
            
            $model_details =array(new BuildingOwnerDetails());
            
            if($id > 0)
            {
    		$model=$model->findByPk($id);
                $condition      = 'building = '.$id;
                $model_details  = $model_owner->findAll(array('condition' => $condition));
                if(empty($model_details))
                $model_details =array(new BuildingOwnerDetails());
            }

                Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

		$this->render('create',array(

			'model'=>$model,'model_details'=>$model_details,

                        'title' => 'Add New Building'

		));
       }

    public function actionSave()
    {
    	$model=new Building();      
    	/************ START Code for Save ***************/
    	if (isset($_POST['Building'])) {
    		
    		if ((int) @$_POST['Building']['id'] > 0) {
    			$model->id = (int) $_POST['Building']['id'];
                        $model = $model->findByPK($model->id);
    			$model->updated_by = Yii::app()->user->id;
    			$model->updated_date = date('Y-m-d h:i:s');
    		}
                else {
    			$model->created_by = Yii::app()->user->id;
    			$model->created_date = date('Y-m-d h:i:s');
    		}
    	
    			$model->attributes = $_POST['Building']; 
                        $model->location = $_POST['Building']['location']; 
                        $model->state = $_POST['Building']['state']; 
                        $model->country = $_POST['Building']['country']; 
                        $model->address = $_POST['Building']['address']; 
                        $model->construction_status=1;
                        $model->buying_date = date("Y-m-d");
                        if ($model->validate())
	    		{
                            $model->save();                          
                            $jsonData['status'] = 'success';
	                    echo CJSON::encode($jsonData);
	    		}
	    		else
	    		{ 
		    		$error = CActiveForm::validate($model, '', false);
		                if ($error != '[]')
		                    echo $error;
		        }
    	}
     }

     public function actionDelete()
     {
                $id = $_POST['id'];
                $model=new Building();
                $model->deleteByPk($id);
                echo "success";
    }

	
	
}