<?php

class BankController extends Controller
{
        public function filters()

	{

		return array(

			'accessControl', // perform access control for CRUD operations

		);

	}


	public function accessRules()
    {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
              ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','Create','Save','Delete'),
                 'expression' => '$user->isMember()',
            ),
             array('deny', // deny all users
                'users' => array('*'),
              ),
            
        );

    }

	public function actionIndex()
	{
                $model = MasterBank::model()->findAll(array('condition'=>'status="1"'));
                $this->render('index',array(
                     'model'=>$model,
                ));

	}

        public function actionCreate()
	{

            $id = (int) Yii::app()->request->getParam('id');
            
	    $model = new MasterBank();
            
            if($id > 0)
            {
    		$model=$model->findByPk($id);
            }

                Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

		$this->render('create',array(

			'model'=>$model,

                        'title' => 'Add New ank'

		));
       }

    public function actionSave()
    {
    	$model=new MasterBank();
    	/************ START Code for Save ***************/
    	if (isset($_POST['MasterBank'])) {
    		
    		if ((int) @$_POST['MasterBank']['id'] > 0) {
    			$model->id = (int) $_POST['MasterBank']['id'];
                        $model = $model->findByPK($model->id); 
                }
    			$model->attributes = $_POST['MasterBank'];
                        $model->other_details = $_POST['MasterBank']['other_details'];
                        $model->status = 1;
	    		if ($model->save())
	    		{
	    			$jsonData['status'] = 'success';
	                        echo CJSON::encode($jsonData);
	    		}
	    		else
	    		{
		    		$error = CActiveForm::validate($model, '', false);
		                if ($error != '[]')
		                    echo $error;
		        }
    	}
     }

     public function actionDelete()
     {
                $id = $_POST['id'];
                $model=new MasterBank();
                $model = $model->findByPK($id);
                $model->status = 0;
                if ($model->save())
	    	{ //$model->deleteByPk($id);
                    echo "success";
                }else{
                    echo "fail";
                }
    }

	
	
}