<?php

/**
 * UserIdentity represents the data needed to identity a user.
 * It contains the authentication method that checks if the provided
 * data can identity the user.
 */
class UserIdentity extends CUserIdentity {

    private $_id;

    /**
     * Authenticates a user.
     * @return boolean whether authentication succeeds.
     */
    public function authenticate() {
        $username = strtolower($this->username);
        $salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
        $password = crypt($this->password, $salt);
        //$password = crypt($this->password, $this->password);
        $user = User::model()->find('LOWER(username)=? AND is_active=? ', array($username, 'Y'));
       
        if ($user === null)
            $this->errorCode = self::ERROR_USERNAME_INVALID;
        else if ($user->password !== $password)
            $this->errorCode = self::ERROR_PASSWORD_INVALID;
        else {
            $this->_id = $user->id;
            $this->setState('fullname', $user->fullname);
            
            
            $this->setState('user_email_id', $user->email);
            
            $authorised_user		=	0;
            if($user->user_level==0)
            $authorised_user		=	1;
            
            $this->setState('authorised_user', $authorised_user);
                      
            $userGroups = UserGroup::model()->findAll('id in (' . $user->user_group_id . ')');
                $permissionArray = array();
                    foreach ($userGroups as $eachUserGroup) {
                        if (!empty($eachUserGroup->permissions)) {
                            $permissionArray = CJSON::decode($eachUserGroup->permissions);
                            $formatted_array = array_map(function($num) {
                                        return (is_numeric(trim($num)) ? number_format(floatval($num), 0, '', '') : $num);
                                    }, $permissionArray);
                        }
                    }
            $this->setState('havePermissionOn', array_merge($formatted_array));
            $this->username = $user->username;
            $this->errorCode = self::ERROR_NONE;
            return $this->errorCode==self::ERROR_NONE;
            
	       
            
        }
        return $this->errorCode == self::ERROR_NONE;
    }

    public function getId() {
        return $this->_id;
    }

}