<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head">
        List of Sample Tracking
        <div class="pull-right">
            <div class="filter_details">
                <?php
                if($customer_id !=''){
                    ?>
                        <div class="filter-item">
                            <label>Customer :</label>
                            <?php $c = Customer::model()->findByPK($customer_id);
                                  echo $c->customer_name; ?>
                        </div>
                    <?php
                }
                if($part_number != ''){
                    ?>
                        <div class="filter-item">
                            <label>Part No :</label>
                            <?php $model_store = Store::model()->findByPK($part_number);
                                  echo $model_store->part_number; ?>
                        </div>
                    <?php                
                }
                if($reference != ''){
                    ?>
                        <div class="filter-item">
                            <label>Reference :</label>
                            <?php echo $reference; ?>
                        </div>
                    <?php                
                }
             ?>
            </div>
        </div>
    </div>


    <div class="panel-body">
        <div class="table-responsive">
            <table id="tbl_order_table" class="table table-fixed table-bordered table-primary dataTable">
                <thead>
                    <tr>
                        <th>Sl No</th>
                        <th>Customer</th>
                        <th>Item No</th>
                        <th>Description</th>
                        <th>Qty</th>
                    </tr>
                </thead>
                <tbody>

                    <?php
                    $j = 0;
                    $condition = '1=1';

                    if (!empty($part_number)) {
                        $condition .= ' AND t.product_id =' . $part_number;
                    }
                    if (!empty($customer_id)) {
                        $condition .= ' AND customer_detail.id =' .$customer_id;
                    }
                    if (!empty($reference)) {
                        $condition .= ' AND demo.reference LIKE "%'.$reference.'%"';
                    }

                    $modelDemoItems = DemoItemDetails::model()->with('demo.customer_detail','demo')->findall(array('condition' => $condition));

                    foreach ($modelDemoItems as $i => $model) {
                        ?>
                        <tr>
                            <td><label><?php echo ($i) + 1 ?></label></td>
                            <td>  <label><?php echo $model->demo->customer_detail->customer_name; ?>  </label></td>
                            <td>

                                <label><?php echo $model->product->part_number; ?></label>
                            </td>
                            <td>
                                <label><?php echo $model->description; ?></label>
                            </td>
                            <td>
                                <label><?php echo $model->picked_qty; ?></label>
                            </td>

                        </tr>
                    <?php } ?>



                </tbody>
            </table>


            <br>
            <div class="btn-wrap text-center">
                <?php echo CHtml::link('Export PDF', array('reports/PrintInvsampletrackingPDF', 'part_number' => $part_number,'reference'=>$reference,'customer_id'=>$customer_id), array('title' => 'Print Sample Tracking', 'target' => '_blank', 'class' => 'btn btn-theme')); ?>
            </div>


        </div>
    </div>
</div>
<?php
$cs = Yii::app()->getClientScript();

$cs->registerScript("excelOrderList", "function excelOrderList(){
  var url= '" . Yii::app()->createUrl('reports/PrintOrderExcel') . "';

  var order_from_date = $('#order_from_date').val();
            var order_to_date = $('#order_to_date').val();
            var delivery_from_date = $('#delivery_from_date').val();
            var delivery_to_date = $('#delivery_to_date').val();
            var customer_id = $('#customer_id').val();
            var sales_group = $('#sales_group').val();
            var payment_terms = $('#payment_terms').val();
            var type_of_contract = $('#type_of_contract').val();

    window.open($('#liveSite').val()+'index.php?r=reports/PrintOrderExcel&order_from_date='+order_from_date+'&order_to_date='+order_to_date+'&delivery_from_date='+delivery_from_date+'&delivery_to_date='+delivery_to_date+'&customer_id='+customer_id+'&sales_group='+sales_group+'&payment_terms='+payment_terms+'&type_of_contract='+type_of_contract, '_blank');

}", CClientScript::POS_HEAD);
$cs->registerScript("excelEnquiryListId", "function excelEnquiryListId(id){

    var url= '" . Yii::app()->createUrl('reports/PrintEnquiryExcelId') . "';

    var enquiry_id = id;

    var start_date = $('#start_date').val();

    var end_date = $('#end_date').val();

    var status = $('#status').val();

    window.open($('#liveSite').val()+'index.php?r=reports/PrintEnquiryExcelId&start_date='+start_date+'&end_date='+end_date+'&status='+status+'&enquiry_id='+enquiry_id, '_blank');

}", CClientScript::POS_HEAD);
