<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head">
        Service Store List
        <div class="pull-right">
            <div class="filter_details">

                <?php
                if ($transfer_from_date != '') {
                    ?>
                    <div class="filter-item">
                        <label>Transfer From Date:</label>
                        <?php echo $transfer_from_date ?>
                    </div>
                    <?php
                }
                ?>
                <?php
                if ($transfer_to_date != '') {
                    ?>
                    <div class="filter-item">
                        <label>Transfer To Date:</label>
                        <?php echo $transfer_to_date ?>
                    </div>

                    <?php
                }
                ?>



                <?php
                if ($transfer_no != '') {
                    ?>
                    <div class="filter-item">
                        <label>Transfer No :</label>
                        <?php echo $transfer_no; ?>
                    </div>
                    <?php
                }
                ?>

            </div>
        </div>
    </div>
    <div class="panel-body">
        <div class="table-responsive">
            <table id="tbl_order_table" class="table table-fixed table-bordered table-primary dataTable">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Transfer No</th>


                        <th>Transfer Date</th>
                        <th>Reference</th>
                        <th>Item</th>
                        <th>Description</th>
                        <th>Qty</th>
                        <th>Unit</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $condition = ' 1=1 ';
                    if ($reference != '') {
                        $condition .= " AND servicestore_details.reference LIKE '%" . $reference . "%' ";
                    }
                    if ($from_date != '' && $to_date != '') {
                        $from_date = str_replace('/', '-', $from_date);
                        $from_date = date('Y-m-d', strtotime($from_date));

                        $to_date = str_replace('/', '-', $to_date);
                        $to_date = date('Y-m-d', strtotime($to_date));

                        $condition .= " AND servicestore_details.transfer_date >= '" . $from_date . "' ";
                        $condition .= " AND servicestore_details.transfer_date <= '" . $to_date . "' ";
                    }
                    $model_order = ServiceStoreDetails::model()->with('servicestore_details')->findAll(array(
                        'condition' => $condition
                    ));
                    foreach ($model_order as $i => $model) {
                        ?>
                        <tr>
                            <td><?= ($i + 1) ?></td>
                            <td><?= $model->servicestore_details->id ?></td>


                            <td><?= date('d-m-Y', strtotime($model->servicestore_details->transfer_date)) ?></td>
                            <td><?= $model->servicestore_details->reference ?></td>
                            <td><?= $model->product->part_number ?></td>
                            <td><?= $model->product->description ?></td>
                            <?php echo number_format((float)$model->quantity, 2, '.', ''); ?> 
                            <td><?= $model->unitdetails->name ?></td>
                            
                        </tr>
                        <?php
                    }
                    ?>
            </table>
            <br>
            <div class="btn-wrap text-center">
                <input type="hidden" id="print_references" value="<?php echo $reference; ?>" />
                <input type="hidden" id="print_fromdate" value="<?php echo $from_date; ?>" />
                <input type="hidden" id="print_todate" value="<?php echo $to_date; ?>" />
                <a title="Export Pdf" class="btn btn-theme" onclick="loadPDF();"><i class="fa fa-file-pdf-o"></i> &nbsp;PDF</a>
                <a title="Export Pdf" class="btn btn-theme" onclick="loadExcel();"><i class="fa fa-file-excel-o"></i> &nbsp;Excel</a>
                <?php
              //echo CHtml::link('Export PDF',array('reports/printservicestorePDF','reference' => $reference,'from_date' => $from_date,'to_date' => $to_date,), array('title'=>'Service Store List','target'=>'_blank','class' =>  'btn btn-theme'));
              //echo CHtml::link('Export PDF',array('reports/PrintInventoryReportPDF','part_number'=>$part_number,'generic_name'=>$generic_name), array('title'=>'Print Lead List','target'=>'_blank','class' =>  'btn btn-theme'));
              ?>
              <!--<button type="button" class="btn btn-theme" onclick="excelInventoryList();">Export Excel</button>-->
            </div>
        </div>
    </div>

</div>
<?php
$cs = Yii::app()->getClientScript();

 $cs->registerScript("loadPDF", "function loadPDF(){
                           
            var reference = $('#print_references').val(); 
            var from_date = $('#print_fromdate').val(); 
            var to_date   = $('#print_todate').val();
            window.open($('#liveSite').val()+'index.php?r=reports/printservicestorePDF&reference='+reference+'&from_date='+from_date+'&to_date='+to_date, '_blank'); 
            return false;
                
    }", CClientScript::POS_HEAD);
 
 
  $cs->registerScript("loadExcel", "function loadExcel(){
                           
            var reference = $('#print_references').val(); 
            var from_date = $('#print_fromdate').val(); 
            var to_date   = $('#print_todate').val();
            window.open($('#liveSite').val()+'index.php?r=reports/printservicestoreExcel&reference='+reference+'&from_date='+from_date+'&to_date='+to_date, '_blank'); 
            return false;
                
    }", CClientScript::POS_HEAD);
 

$cs->registerScript("excelOrderList", "function excelOrderList(){
  var url= '" . Yii::app()->createUrl('reports/PrintOrderExcel') . "';

  var order_from_date = $('#order_from_date').val();
            var order_to_date = $('#order_to_date').val();
            var delivery_from_date = $('#delivery_from_date').val();
            var delivery_to_date = $('#delivery_to_date').val();
            var customer_id = $('#customer_id').val();
            var sales_group = $('#sales_group').val();
            var payment_terms = $('#payment_terms').val();
            var type_of_contract = $('#type_of_contract').val();

    window.open($('#liveSite').val()+'index.php?r=reports/PrintOrderExcel&order_from_date='+order_from_date+'&order_to_date='+order_to_date+'&delivery_from_date='+delivery_from_date+'&delivery_to_date='+delivery_to_date+'&customer_id='+customer_id+'&sales_group='+sales_group+'&payment_terms='+payment_terms+'&type_of_contract='+type_of_contract, '_blank');

}", CClientScript::POS_HEAD);
$cs->registerScript("excelEnquiryListId", "function excelEnquiryListId(id){

    var url= '" . Yii::app()->createUrl('reports/PrintEnquiryExcelId') . "';

    var enquiry_id = id;

    var start_date = $('#start_date').val();

    var end_date = $('#end_date').val();

    var status = $('#status').val();

    window.open($('#liveSite').val()+'index.php?r=reports/PrintEnquiryExcelId&start_date='+start_date+'&end_date='+end_date+'&status='+status+'&enquiry_id='+enquiry_id, '_blank');

}", CClientScript::POS_HEAD);
