<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head">
        List of Quotations
        <div class="pull-right">
            <div class="filter_details">
                <?php
                if ($qtn_start_from_date != '') {
                    ?>
                    <div class="filter-item">
                        <label>Quotation From :</label>
                        <?php echo $qtn_start_from_date; ?>
                    </div>
                    <?php
                }
                ?>
                <?php
                if ($qtn_start_to_date != '') {
                    ?>
                    <div class="filter-item">
                        <label>Quotation To :</label>
                        <?php echo $qtn_start_to_date; ?>
                    </div>
                    <?php
                }
                if ($probability != '') { ?>
                    <div class="filter-item">
                        <label>Probability :</label>
                        <?php echo $probability; ?>
                    </div>
                    <?php
                }
                ?>
                <?php
                if($leadowner_id !=''){
                    ?>
                    <div class="filter-item">
                        <label>Lead Owner  :</label>
                        <?php $l = User::model()->findByPK($leadowner_id);
                                echo $l->first_name." ".$l->last_name; ?>
                    </div>
                    <?php
                }
             ?>
            </div>
        </div>
    </div>
    <div class="panel-body">
        <div class="table-responsive">
            <table id="tbl_quote_table" class="table table-fixed table-bordered table-primary dataTable">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Qtn No</th>
                        <th>File No</th>
                        <th>Company Name</th>
                        <th>Lead Owner</th>
                        <th>Quotation Date</th>
                        <th>Validity Date</th>
                        <th>Sales Group</th>
                        <th>Probability</th>
                        <th>Status</th>
                        <th>Currency</th>
                        <th>Grand Total(BC)</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $condition = '1=1';
                    ;
                    if ($qtn_start_from_date != '') {
                        $qtn_start_from_date = str_replace('/', '-', $qtn_start_from_date);
                        $qtn_start_from_date = date('Y-m-d 0:i:s', strtotime($qtn_start_from_date));
                        $condition .= ' AND t.qtn_date >="' . $qtn_start_from_date . '"';
                    }
                    if ($qtn_start_to_date != '') {
                        $qtn_start_to_date = str_replace('/', '-', $qtn_start_to_date);
                        $qtn_start_to_date = date('Y-m-d 24:i:s', strtotime($qtn_start_to_date));
                        $condition .= ' AND t.qtn_date <="' . $qtn_start_to_date . '"';
                    }
                    if ($customer_id != '') {
                        $condition .= ' AND t.customer_id ="' . $customer_id . '"';
                    }

                    if ($probability != '') {
                        $condition .= ' AND t.probability ="' . $probability . '"';
                    }
                    if($leadowner_id != ''){
                        $condition .= ' AND t.lead_owner_id ="' . $leadowner_id.'"';
                    }
                    //echo $condition;
                    $total = 0;
                    $model_quote = Quotes::model()->with('file', 'customer', 'probability_details')->findAll(array('condition' => $condition));
                    foreach ($model_quote as $i => $model) {
                        ?>
                    <input type="hidden" id="qtn_start_from_date" name="qtn_start_from_date" value="<?php echo $qtn_start_from_date; ?>">
                    <input type="hidden" id="qtn_start_to_date" name="qtn_start_to_date" value="<?php echo $qtn_start_to_date; ?>">
                    <input type="hidden" id="customer_id" name="customer_id" value="<?php echo $customer_id; ?>">
                    <input type="hidden" id="probability" name="leadowner_id" value="<?php echo $probability; ?>">
                    <input type="hidden" id="leadowner_id" name="leadowner_id" value="<?php echo $leadowner_id;?>">
                    <tr>
                        <td><?php echo $i + 1; ?></td>
                        <td><?php echo $model->id; ?></td>
                        <td><?php echo $model->file_id; ?></td>

                        <td class="nw"><?php echo $model->customer->customer_name; ?></td>
                        <td class="nw"><?php echo $model->file->leadowner->first_name . " " . $model->file->leadowner->last_name; ?></td>
                        <?php if ($model->qtn_date != '0000-00-00') { ?>
                            <td><?php echo date("d/m/Y", strtotime($model->qtn_date)); ?></td>
                        <?php } else { ?>
                            <td>&nbsp;</td>
                        <?php } ?>
                        <?php if ($model->qtn_validity != '0000-00-00') { ?>
                            <td><?php echo date("d/m/Y", strtotime($model->qtn_validity)); ?></td>
                        <?php } else { ?>
                            <td>&nbsp;</td>
                        <?php } ?>

                        <td class="nw"><?php echo $model->salesgroup->group_name; ?></td>
                        <td><?php echo $model->probability; ?></td>
                        <?php
                        $state = "";
                        if ($model->status == 'Y') {
                            $state = "Open";
                        } else if ($model->status == 'C') {
                            $state = "Closed";
                        } else if ($model->status == 'O') {
                            $state = "Others";
                        } elseif ($model->status == 'L') {
                            $state = "Lost";
                        }
                        ?>
                        <td><?php echo $state; ?></td>
                        <td><?php echo $model->currencyname->currency_code; ?></td>
                        <?php
                        $model_currency = MasCurrency::model()->findByPk($model->currency);
                        $total_bc = $model->grand_total * $model_currency->exchange_rate;
                        $total += $total_bc
                        ?>
                        <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($total_bc, " "); ?></td>
                       <td>
                       <button class="btn btn-primary btn-xs" onclick="loadPopupModal('quotation/create&id=<?php echo $model->id ?>&file_id=<?php echo $model->file_id ?>','Quotation','xl'); return false;"> <i class="fa fa-edit"></i></button>
                        </td>

                    </tr>
                <?php } ?>
                <tr>
                    <td colspan="11"> </td>
                    <td class="text-right"><b> <?php echo Yii::app()->numberFormatter->formatCurrency($total, " "); ?></b> </td>

                </tr>
                </tbody>
            </table>
            <br>
            <div class="btn-wrap text-center">
<?php echo CHtml::link('<i class="fa fa-file-pdf-o"></i> PDF', array('reports/PrintQuoteProbabilityReportPDF', 'probability' => $probability, 'qtn_start_from_date' => $qtn_start_from_date, 'qtn_start_to_date' => $qtn_start_to_date, 'customer_id' => $customer_id,'leadowner_id'=>$leadowner_id, 'title' => $title), array('title' => 'Print Quote List', 'target' => '_blank', 'class' => 'btn btn-theme')); ?>
                <button type="button" class="btn btn-theme" onclick="excelQuoteList();"><i class="fa fa-file-excel-o"></i> &nbsp;Excel</button>
            </div>
        </div>
    </div>
</div>
<?php
$cs = Yii::app()->getClientScript();

$cs->registerScript("excelQuoteList", "function excelQuoteList(){

    var url= '" . Yii::app()->createUrl('reports/PrintQuoteProbabilityReportExcel') . "';
    var qtn_start_from_date = $('#qtn_start_from_date').val();
            var qtn_start_to_date = $('#qtn_start_to_date').val();
           
            var customer_id = $('#customer_id').val();
            var leadowner_id = $('#leadowner_id').val();            
            var probability = $('#probability').val();
    window.open($('#liveSite').val()+'index.php?r=reports/PrintQuoteProbabilityReportExcel&qtn_start_from_date='+qtn_start_from_date+'&qtn_start_to_date='+qtn_start_to_date+'&customer_id='+customer_id+'&probability='+probability+'&leadowner_id='+leadowner_id, '_blank');

}", CClientScript::POS_HEAD);