<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head">
        Quotation Summary
        <div class="pull-right">
            <div class="filter_details">
                <?php
                if ($qtn_start_from_date != '') {
                ?>
                <div class="filter-item">
                    <label>Quotation From :</label>
                    <?php echo $qtn_start_from_date; ?>
                </div>
                <?php
                }
                ?>
                <?php
                if ($qtn_start_to_date != '') {
                ?>
                <div class="filter-item">
                    <label>Quotation To :</label>
                    <?php echo $qtn_start_to_date; ?>
                </div>
                <?php
                }
                ?>
                <?php
                if ($qtn_validity_from_date != '') {
                ?>
                <div class="filter-item">
                    <label>Valid From :</label>
                    <?php echo $qtn_validity_from_date; ?>
                </div>
                <?php
                }
                ?>
                <?php
                if ($qtn_validity_to_date != '') {
                ?>
                <div class="filter-item">
                    <label>Valid To :</label>
                    <?php echo $qtn_validity_to_date; ?>
                </div>
                <?php
                }
                ?>
                <?php
                if ($sales_group != '') {
                ?>
                <div class="filter-item">
                    <label>Sales Group :</label>
                    <?php $s = MasSalesGroup::model()->findByPK($sales_group);
                    echo $s->group_name;
                    ?>
                </div>
                <?php
                }
                ?>
                <?php
                if ($customer_id != '') {
                ?>
                <div class="filter-item">
                    <label>Customer :</label>
                    <?php $c = Customer::model()->findByPK($customer_id);
                    echo $c->customer_name;
                    ?>
                </div>
                <?php
                }
                ?>

            </div>
        </div>
    </div>
    <div class="panel-body">
        <div class="table-responsive">
            <table id="tbl_quote_table" class="table table-fixed table-bordered table-primary dataTable" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>SI#</th>
                        <th>Qtn #</th> 
                        <th>Qtn Date</th>  
                        <th>Customer</th> 
                        <th>Contact Person</th> 
                        <th>Lead Owner</th>
                        <th>Created By</th>
                        <th>Origin</th>
                        <th>Destination</th> 
                        <!--<th>Agent</th>-->
                        <th>Consignee</th>
                        <th>Status</th>
                        <th>Ch.Wt</th>
                        <th>Selling Price</th>
                        <th>Cost</th>
                        <th>Profit</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $condition = '1=1';

                    if ($qtn_start_from_date != '' && $qtn_start_to_date != '') {
                    $qtn_start_from_date = str_replace('/', '-', $qtn_start_from_date);
                    $qtn_start_from_date = date('Y-m-d', strtotime($qtn_start_from_date));
                    $condition .= ' AND t.quotation_date >="' . $qtn_start_from_date . '"';

                    $qtn_start_to_date = str_replace('/', '-', $qtn_start_to_date);
                    $qtn_start_to_date = date('Y-m-d', strtotime($qtn_start_to_date));
                    $condition .= ' AND t.quotation_date <="' . $qtn_start_to_date . '"';
                    }
                    if ($customer_id != '') {
                    $condition .= ' AND t.customer_id ="' . $customer_id . '"';
                    }
                    if ($qtn_shipper_id != '') {
                    $condition .= ' AND t.shipper_id ="' . $qtn_shipper_id . '"';
                    }

                    if ($quotation_id != '') {
                    $condition .= ' AND t.id ="' . $quotation_id . '"';
                    }
                    if ($qtn_consignee_id != '') {
                    $condition .= ' AND t.consignee_id LIKE "%' . $qtn_consignee_id . '%"';
                    }
                    if ($qtn_origin_id != '') {
                    $condition .= ' AND t.origin_id ="' . $qtn_origin_id . '"';
                    }
                    if ($qtn_destination_id != '') {
                    $condition .= ' AND t.destination_id ="' . $qtn_destination_id . '"';
                    }
                    if ($filter_quotation_transport_type != '') {

                    $condition .= ' AND t.transport_type ="' . $filter_quotation_transport_type . '"';
                    }
                    if ($qtn_status != '') {

                    $condition .= ' AND t.quotation_status ="' . $qtn_status . '"';
                    }

                    if($qtn_created_by != ""){
                    $condition .= ' AND t.created_by ="' . $qtn_created_by.'"';
                    }
                    if($qtn_leadowner_id != ""){
                    $condition .= ' AND t.lead_owner_id ="' . $qtn_leadowner_id.'"';
                    }

                    //echo ($condition);
                    /**view added by jisha on 15/1/24*/
                    $total = 0;
                    $sql = "SELECT * FROM view_quotation_details t where ".$condition;
                    $modelQuote = Yii::app()->db->createCommand($sql)->queryAll();
                    //print_r($condition);
                    foreach ($modelQuote as $i => $model) {

                    switch($model['quotation_status']){
                        case 'CL':
                        $row_quotation_status="Closed";
                        break;
                        case 'A':
                        $row_quotation_status="Awaiting";
                        break;
                        case 'CO':
                        $row_quotation_status="Confirmed";
                        break;
                        case 'CA':
                        $row_quotation_status="Cancel";
                        break;
                        default:
                        $row_quotation_status="Open";
                        break;
                    } 

                    ?>
                <tr>
                    <td><?php echo $i + 1; ?></td>
                    <td><?php echo $model['id']; ?></td>
                    <?php if ($model['quotation_date'] != '0000-00-00') { ?>
                    <td><?php echo date("d/m/Y", strtotime($model['quotation_date'])); ?></td>
                    <?php } else { ?>
                    <td>&nbsp;</td>
                    <?php } ?>
                    <td><?php echo $model['customer_name']; ?></td>
                    <td width="20px;"><?php echo $model['contact_names'];?></td>
                    <td class="nw"><?php echo $model['leadowner']; ?></td>
                    <td class="nw"> <?php echo $model['created_user']; ?></td>
                    <td><?php echo $model['origin']; ?></td>
                    <td><?php echo $model['destination']; ?></td>
                    <td><?php echo $model['consignee_id']; ?></td>
                    <td class="text-right"><?php echo $row_quotation_status;?></td>
                    <td width="8%" class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($model['chargeable_weight'],""); ?></td>
                    <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($model['selling_price'],""); ?></td>
                    <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($model['cost_price'] ,""); ?></td>
                    <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($model['profit'],"");
                        $total_planned_cost += $model['cost_price'];
                        $total_selling_price += $model['selling_price'];
                        $total_planned_profit+=$model['profit'];
                    ?></td>
                </tr>
                <?php } ?>
                <tr>
                    <td colspan="12"> </td>
                    <td class="text-right"><b> <?php  echo Yii::app()->numberFormatter->formatCurrency($total_selling_price, " "); ?></b> </td>
                    <td class="text-right"><b> <?php  echo Yii::app()->numberFormatter->formatCurrency($total_planned_cost, " "); ?></b> </td>
                    <td class="text-right"><b> <?php  echo Yii::app()->numberFormatter->formatCurrency($total_planned_profit, " "); ?></b> </td>
                </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>