

<?php
$cs = Yii::app()->getClientScript();

$cs->registerScript("load", '$(document).ready(function() {
        var table_id = "#tbl_job_order_details";
        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            data.filter_start_date         = $("#filter_start_date").val();
            data.filter_end_date            = $("#filter_end_date").val();
            data.filter_job_no              = $("#filter_job_no").val();
            data.filter_customer            = $("#filter_customer").val();
            data.filter_agent               = $("#filter_agent").val();
            data.filter_job_order_priority  = $("#filter_job_order_priority").val();
            data.filter_job_order_status    = $("#filter_job_order_status").val();
            data.filter_job_order_transport_type    =$("#filter_job_order_transport_type").val();
            return data;
        }).DataTable({
            scrollY: "645px",
            scrollx: "645px",
            pageLength: 50,
            //processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('reports/GetJobOrderList') . '",
                type: "POST",
                cache: false,
            },
           
            serverSide: true,
            fixedColumns: true,
            processing: true,
            searching: false,
            "bSort" : false,
            columns:[
					{className: "nw sl col-max-1"},
					{className: "nw sl col-max-0"},
					{className: "nw sl col-max-2"},
					{className: "nw sl col-max-3"},               
					{className: "nw sl col-max-3"},               
					{className: "nw sl col-max-3" },
					{className: "nw sl col-max-3" },
					{className: "nw sl col-max-3" },
					{className: "nw sl col-max-5"},
					{className: "nw sl col-max-3" },
					{className: "nw sl col-max-3" },
					/*{className: "nw sl col-max-3" },				
					{className: "nw sl col-max-3"},
                    {className: "nw sl col-max-3"},
					{className: "nw sl col-max-3" },*/				
						
					
				   
             ],
           
           
        });
 });', CClientScript::POS_HEAD);
?>

<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <div class="col-md-2">
            <i class="fa fa-area-chart"></i> Job Order List
        </div>    
             
        <div class="pull-right" style="display: flex;">
            <?php echo CHtml::textfield('filter_start_date', date('01/01/Y'), array('class' => 'datepicker form-control', 'style' => 'margin-right:10px; width:120px;')); ?>
            <?php echo CHtml::textfield('filter_end_date', date('t/m/Y'), array('class' => 'datepicker form-control', 'style' => 'margin-right:10px; width:120px;')); ?>
            <?php echo CHtml::textfield('filter_job_no', '', array('class' => 'form-control', 'style' => 'margin-right:10px; width:120px;', 'placeholder' => 'Job#')); ?>
            <?php echo CHtml::textfield('filter_customer', '', array('class' => 'form-control', 'style' => 'margin-right:10px; width:120px;', 'placeholder' => 'Customer')); ?>
            <?php echo CHtml::textfield('filter_agent', '', array('class' => 'form-control', 'style' => 'margin-right:10px; width:120px;', 'placeholder' => 'Agent')); ?>
             <?php echo CHtml::dropdownList('filter_job_order_transport_type', '', MasTransportType::getTransportType(), array('class' => 'form-control','style' => 'margin-right:10px; width:120px;', 'prompt' => '-- Service Type--')); ?>  
            <?php echo CHtml::dropdownList('filter_job_order_priority', '', JobOrder::getJobOrderPriorityList(), array('class' => 'form-control','style' => 'margin-right:10px; width:120px;', 'prompt' => '-- Priority--')); ?>      
            <?php echo CHtml::dropdownList('filter_job_order_status', '', array('O'=>'Open','PD'=>'Partially Delivered','D'=>'Delivered','C'=>'Completed','CN'=>'Cancel'), array('class' => 'form-control','style' => 'margin-right:10px; width:120px;', 'prompt' => '-- Status--')); ?> 
            
           <button class="btn btn-sm btn-theme" style="margin-right: 10px;" title="Reload" onclick="reloadTable('#tbl_job_order_details');return false;"><i class="fa fa-retweet"></i> Load</button>

        </div>


    </header>


    <div class="panel-body">

        <div class="custom-data-table">

            <table class="table table-hover table-bordered" id="tbl_job_order_details" style="font-size:11px;">

                <thead>
                   
                    <tr>
                        <th>SI#</th>
                        <th>Job #</th> 
                        <th>Booking Date</th>  
                        <th>Shipper</th> 
                        <th>Origin</th>
                        <th>Cnee</th>
                        <th>Destination</th>     
                        <th>Agent</th>
                         <th>Service Type</th>     
                        <th>AWB</th>                           
                        <th>Job Status</th>                          
                        <!--th>Service Type</th>                           
                        <th>Job Status</th>
                        <th>Auto Status</th>
                        <th>Status Date</th-->
                    </tr>
                </thead>



            </table>
        </div>
    </div>
    <div class="btn-wrap text-center">    
        <button type="button" title="export pdf" class="btn btn-theme" onclick="window.open($('#liveSite').val() + 'index.php?r=reports/JoborderReportPDF&filter_start_date=' + $('#filter_start_date').val() + '&filter_end_date=' + $('#filter_end_date').val() + '&filter_job_no=' + $('#filter_job_no').val() + '&filter_customer=' + $('#filter_customer').val() + '&filter_agent=' + $('#filter_agent').val() + '&filter_job_order_priority=' + $('#filter_job_order_priority').val()+'&filter_job_order_status='+$('#filter_job_order_status').val()+'&filter_job_order_transport_type='+$('#filter_job_order_transport_type').val(), '_blank');"><i class="fa fa-file-pdf-o"></i> &nbsp;PDF</button>
        <!--<button type="button" title="export excel" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=reports/PrintJoborderListExcel&filter_job_order_priority='+$('#filter_job_order_priority').val()+'&filter_job_order_no='+$('#filter_job_order_no').val()+'&filter_job_order_shipper='+$('#filter_job_order_shipper').val()+'&filter_job_order_agent='+$('#filter_job_order_agent').val()+'&filter_job_order_awb_no='+$('filter_job_order_awb_no').val()+'&filter_job_order_transport_type='+$('#filter_job_order_transport_type').val() + '&filter_job_order_status=' +$('#filter_job_order_status').val(), '_blank');"><i class="fa fa-file-excel-o"></i> &nbsp;Excel</button> --> 
        <button type="button" class="btn btn-theme" onclick="excelJoborderList();"><i class="fa fa-file-excel-o"></i> &nbsp;Excel</button> 
    </div>  

</section> 
<?php
$cs = Yii::app()->getClientScript();

$cs->registerScript("excelJoborderList", "function excelJoborderList(){

    var filter_start_date = $('#filter_start_date').val();
    var filter_end_date = $('#filter_end_date').val();
    var filter_job_no = $('#filter_job_no').val();
    var filter_customer = $('#filter_customer').val();
    var filter_agent = $('#filter_agent').val();
    var filter_job_order_priority = $('#filter_job_order_priority').val();
    var filter_job_order_status = $('#filter_job_order_status').val();
     var filter_job_order_transport_type = $('#filter_job_order_transport_type').val();     
    window.open($('#liveSite').val()+'index.php?r=reports/PrintJoborderListExcel&filter_start_date='+filter_start_date+'&filter_end_date='+filter_end_date+'&filter_job_no='+filter_job_no+'&filter_customer='+filter_customer+'&filter_agent='+filter_agent+'&report_from='+report_from+'&filter_job_order_priority='+filter_job_order_priority+'&filter_job_order_status='+filter_job_order_status+'&filter_job_order_transport_type='+filter_job_order_transport_type, '_blank');

}", CClientScript::POS_HEAD);
