<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("load", '$(document).ready(function() {
        var table_id ="#tbl_stock_state_as_of_detailed";
        var table =  $(table_id).on("preXhr.dt", function (e, settings, data) {
                        data.to_date = $("#to_date").val();
                        data.generic_id = $("#generic_id").val();
                        data.brand_id = $("#brand_id").val();
                        data.machine_type = $("#machine_type").val();
                        data.have_stock = $("#have_stock").val();
                        return data;
                        }).DataTable({
                            //scrollY         : "1000px",
                            pageLength      : 100,
                            ajax: {
                                url: "' . Yii::app()->createUrl('reports/getstockstateasofdetailed') . '",
                                type: "POST",
                                cache : false,
                            },
                            "fnDrawCallback": function() {
                                var api = this.api()
                                var json = api.ajax.json();
                                $(api.column(10).footer()).html(Number(json.total).toFixed(2));
                            },
                             "rowCallback": function ( row, data ){ 
                                 if ( data[11] == "yes" ){
                                     $("td", row).css("background-color", "#ADD8E6");
                
                                 }
                 			/*	else if ( data[10] == "2" ){
                                     $("td", row).css("background-color", "#ff8080");
                
                                 }*/
                             },	
                            serverSide:     true,
                            fixedColumns:   true,
                            processing: true,
                            "bSort" : false,
                            columns: [
                                {className: ""},
                                {className: ""},
                                {className: ""},               
                                {className: ""},
                                {className: ""},
                                {className: ""},
                                {className: ""},
                                {className: ""},
                                {className: "text-right" },
                                {className: "text-right" },
                                {className: "text-right"},
                            ],
        } );


    });', CClientScript::POS_HEAD);
?>
<section class="panel">
    <div class="panel-heading clearfix panel-theame">
        <div class="top_controls_select col-sm-6"> 
            <div class="col-sm-2">
                <?php echo CHtml::textfield('to_date', date('d/m/Y'), array( 'class' => 'form-control reloaderclass datepicker' )); ?>
            </div>
            <div class="col-sm-3">
                <?php echo CHtml::dropdownlist('generic_id', '', MasGeneric::getGenericNames(), array('class' => 'form-control','prompt' => 'All Generic', 'onchange' => 'reloadTable("#tbl_stock_state_as_of_detailed")')); ?>
            </div>
            <div class="col-sm-3">
                <?php echo CHtml::dropdownlist('brand_id', '', ProductClass::getAllProductClass(), array('class' => 'form-control','prompt' => 'All Brand', 'onchange' => 'reloadTable("#tbl_stock_state_as_of_detailed")')); ?>
            </div>
            <div class="col-sm-2">
                <?php echo CHtml::dropdownlist('machine_type', '', array('M'=>'Machine','S'=>'Spare'), array('class' => 'form-control','prompt' => 'All Types', 'onchange' => 'reloadTable("#tbl_stock_state_as_of_detailed")')); ?>
            </div>
            <div class="col-sm-2">
                <?php echo CHtml::dropdownlist('have_stock', '',array('Y'=>'Having Stock'), array('class' => 'form-control','prompt' => 'All', 'onchange' => 'reloadTable("#tbl_stock_state_as_of_detailed")')); ?>
            </div>
        </div>
    </div>
    <div class="panel-body"> 
            <table class="table table-bordered" id="tbl_stock_state_as_of_detailed">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Part Number</th>
                        <th>Description</th>
                        <th>Generic</th> 
                        <th>Brand /Class</th>
                        <th>Serial No</th>
                        <th>Batch No</th>
                        <th>Expiry Date</th>
                        <th>Quantity</th>
                        <th>Rate</th>                        
                        <th>Value</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th colspan="10" style="text-align:right">Total:</th>
                        <th></th>
                    </tr>
                </tfoot>
            </table>
        </div>
        <div class="btn-wrap text-center">    
            <button type="button" title="export pdf" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=reports/PrintStockStateAsofDetailed&type=pdf&to_date='+$('#to_date').val()+'&generic_id='+$('#generic_id').val()+'&machine_type='+$('#machine_type').val()+'&have_stock='+$('#have_stock').val()+'&brand_id='+$('#brand_id').val()+'&part_no='+$('div.dataTables_filter input').val(), '_blank');"><i class="fa fa-file-pdf-o"></i> PDF</button>
            <button type="button" title="export excel" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=reports/PrintStockStateAsofDetailed&type=excel&to_date='+$('#to_date').val()+'&generic_id='+$('#generic_id').val()+'&machine_type='+$('#machine_type').val()+'&have_stock='+$('#have_stock').val()+'&brand_id='+$('#brand_id').val()+'&part_no='+$('div.dataTables_filter input').val(), '_blank');"><i class="fa fa-file-excel-o"></i> Excel</button>  
        </div>
</section>    

<script>
    $('.reloaderclass').on('dp.change', function(e){ 
        reloadTable("#tbl_stock_state_as_of_detailed");
    });
</script>