<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("load", '$(document).ready(function() {
        var table_id ="#table_inventory_list";
        var table =  $(table_id).on("preXhr.dt", function (e, settings, data) {
                        data.type = $("#type").val();
                        data.generic_id = $("#generic_id").val();
                        data.tax_code = $("#tax_code").val();
                        data.brand_id = $("#brand_id").val();
                        data.having_stock = $("#having_stock").val();
                        data.active = $("#active").val();
                        return data;
                        }).DataTable({
                            //scrollY         : "50vh",
                            pageLength      : 50,
                            ajax: {
                                url: "' . Yii::app()->createUrl('reports/getinventorylist') . '",
                                type: "POST",
                                cache : false,
                            },
                            "fnDrawCallback": function() {
                                var api = this.api()
                                var json = api.ajax.json();
                                $(api.column(10).footer()).html(Number(json.total).toFixed(4));
                            },
                            serverSide:     true,
                            fixedColumns:   true,
                            processing: true,
                            "bSort" : false,
                            columns: [
                                
                                {className: ""},                             
                                {className: ""},
                                {className: ""},               
                                {className: "" },
                                {className: ""},
                                 {className: "" },
                                {className: ""},
                                {className: "text-right" },
                                {className: ""},
                                {className: "text-right"},
                                {className: "text-right"},
                                
                            ],
        } );


    });', CClientScript::POS_HEAD);
?>
<section class="panel">
    <div class="panel-heading clearfix panel-theame">
        <div class="top_controls_select"> 
            <div class="col-sm-2">
                <?php echo CHtml::dropdownlist('type', '', array('1' => 'Stock', '2' => 'Service'), array('class' => 'form-control','prompt' => 'All Type', 'onchange' => 'reloadTable("#table_inventory_list")')); ?>
            </div>
            <div class="col-sm-2">
                <?php echo CHtml::dropdownlist('generic_id', '', MasGeneric::getAllGeneric(), array('class' => 'form-control','prompt' => 'All Generic', 'onchange' => 'reloadTable("#table_inventory_list")')); ?>
            </div>
            <div class="col-sm-2">
                <?php echo CHtml::dropdownlist('tax_code', '', MasInvTax::getTaxpercentages(), array('class' => 'form-control','prompt' => 'All Tax', 'onchange' => 'reloadTable("#table_inventory_list")')); ?>
            </div>
            <div class="col-sm-2">
                <?php echo CHtml::dropdownlist('brand_id', '', MasBrand::getAllBrands(), array('class' => 'form-control','prompt' => 'All Brand', 'onchange' => 'reloadTable("#table_inventory_list")')); ?>
            </div>
            <div class="col-sm-2">
                <?php echo CHtml::dropdownlist('having_stock', '', array( 1 => 'Having Stock' ), array('class' => 'form-control','prompt' => 'All', 'onchange' => 'reloadTable("#table_inventory_list")')); ?>
            </div>  
            <div class="col-sm-1">
                 <?php echo CHtml::dropdownlist('active', 'Y', array( "Y" => "Active", "N" =>"Inactive"), array('class' => 'form-control','prompt' => 'All', 'onchange' => 'reloadTable("#table_inventory_list")')); ?>
            </div>
        </div>
    </div>
    <div class="panel-body"> 
            <table class="table table-bordered" id="table_inventory_list">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Part Number</th>
                        <th>Description</th>
                        <th>Generic</th> 
                        <th>Brand</th>
                        <th>Type</th>                          
                        <th>Tax Code</th> 
                        <th>Quantity</th>
                        <th>Unit</th>
                        <th>Rate</th>
                        <th>Value</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th colspan="10" style="text-align:right">Total:</th>
                        <th></th>
                    </tr>
                </tfoot>
            </table>
        </div>
        <div class="btn-wrap text-center">    
            <button type="button" title="export pdf" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=reports/PrintInventoryReportPDF&type='+$('#type').val()+'&generic_id='+$('#generic_id').val()+'&tax_code='+$('#tax_code').val()+'&brand_id='+$('#brand_id').val()+'&part_no='+$('div.dataTables_filter input').val()+'&having_stock='+$('#having_stock').val() + '&active=' +$('#active').val() +'&machine_type=' +$('#machine_type').val(), '_blank');"><i class="fa fa-file-pdf-o"></i> &nbsp;PDF</button>
            <button type="button" title="export excel" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=reports/PrintInventoryListExcel&type='+$('#type').val()+'&generic_id='+$('#generic_id').val()+'&tax_code='+$('#tax_code').val()+'&brand_id='+$('#brand_id').val()+'&part_no='+$('div.dataTables_filter input').val()+'&having_stock='+$('#having_stock').val() + '&active=' +$('#active').val() +'&machine_type=' +$('#machine_type').val(), '_blank');"><i class="fa fa-file-excel-o"></i> &nbsp;Excel</button>  
        </div>    

</section> 