<!DOCTYPE html>
<html>
    <head>
        <title>Stock State AS OF</title>
    </head>
    <body>
    
        <div class="heading">
            <div class="header" style="width:100%;float: left;padding-bottom:10px;">
                <img src="<?php echo  'images/logo/'.Yii::app()->user->pdf_company_logo; ?>"  class="logo"/>
            </div> 
            <div class="col-12 text-center" style="margin: 0 auto;">
                <h1><u>STOCK STATE AS OF - DETAILED</u></h1>
            </div>
            <div class="col-12">
                    <div class="details-box">

                        <table class="table" style="width:100%">
                            <?php
                            $to_date = ( count(explode('/', $_GET['to_date'])) == 3 ) ? date('Y-m-d', strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');
                            $generic_id = (int) $_GET['generic_id'];
                            $brand_id = (int) $_GET['brand_id'];
                            $machine_type = $_GET['machine_type'];
                            $have_stock = $_GET['have_stock'];
                            if ( $to_date != '') {
                            ?>
                                <tr>
                                    <td><b>As on date</b></td>
                                    <td>
                                        <?php echo date('d/m/Y', strtotime($to_date)); ?>
                                    </td>
                                </tr>
                            <?php
                            }
                            ?>
                            <?php
                            if ( $generic_id != '') {
                                $modelGeneric  = MasGeneric::model()->findByPk($generic_id);
                            ?>
                                <tr>
                                    <td><b>Generic</b></td>
                                    <td>
                                        <?php echo $modelGeneric->generic_name; ?>
                                    </td>
                                </tr>
                            <?php
                            }
                            ?>
                            <?php
                            if($brand_id != '') {
                                $modelBrand  = ProductClass::model()->findByPk($brand_id);
                            ?>
                                <tr>
                                    <td><b>Brand /Class</b></td>
                                    <td>
                                        <?php echo $modelBrand->product_class; ?>
                                    </td>
                                </tr>
                            <?php
                            }
                            if ($machine_type != "") {
                                ?>
                                <tr><th>Machine Type</th>
                                    <td>
                                    <?php echo ($machine_type=='S')?'Spare':'Machine' ?>
                                    </td>
                                </tr>
                            <?php } 
                            if ($have_stock != "") {
                                ?>
                                <tr><th>Having Stock</th>
                                    <td><?php echo $have_stock; ?></td>
                                </tr>
                            <?php } ?>
                        </table>


                </div>
            </div>
        </div>        
        
        <div class="clearfix"></div>
        <div class="table-body">
            <table class="table table-fixed table-bordered table-primary dataTable">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Part Number</th>
                        <th>Description</th>
                        <th>Generic</th> 
                        <th>Brand /Class</th>
                        <th>Serial No</th>
                        <th>Batch No</th>
                        <th>Expiry Date</th>
                        <th>Quantity</th>
                        <th>Rate</th>                        
                        <th>Value</th>
                    </tr>
                </thead>
                <tbody>
                     <?php
                        $condition = 'quantity != 0';
                
                        if ($generic_id > 0)
                            $condition .= ' AND generic_id=' . $generic_id;
                
                        if ($brand_id > 0)
                            $condition .= ' AND brand_id=' . $brand_id;
                
                        if ($searchString != '')
                            $condition .= ' AND part_number LIKE "%' . $searchString . '%"';
                
                        if ($machine_type!=''){
                            $condition .= ' AND machine_type="'.$machine_type.'"';
                        }
                        if ($have_stock=='Y'){
                            $condition .= ' AND quantity>0';
                        }
                
                        $stock_state_as_of_query = 'CREATE OR REPLACE VIEW view_stock_state_as_of_detailed AS

                                        SELECT S.id AS product_id, S.part_number AS part_number, S.description AS description,S.machine_type as machine_type,

                                        S.alias_name AS alias_name, B.product_class AS brand, G.generic_name AS generic_name,

                                        S.brand_class_id AS brand_id, S.generic_id AS generic_id ,PL.quantity,

                                        SUBSTRING_INDEX( GROUP_CONCAT(CAST(L.cost_price AS CHAR) ORDER BY L.transaction_date DESC), ",", 1 ) AS rate,PL.batch_no AS batch_no,PL.expiry_date AS expiry_date,PL.serial_no AS serial_no, product_location_id 

                                        FROM erp_product_location_details PL

                                        LEFT JOIN erp_store S ON S.id = PL.product_id LEFT JOIN erp_product_class B ON S.brand_class_id = B.id

                                        LEFT JOIN erp_inventory_generic_name G ON S.generic_id = G.id 
                                        
                                        LEFT JOIN erp_stock_ledger L ON  L.product_location_id=PL.id
                                        
                                        WHERE S.inventory_item_type IN (1,3) AND PL.quantity >0 AND L.transaction_date <= "' . $to_date . '"											
                                        
										
                                        GROUP BY L.product_location_id ORDER BY S.part_number';


                             

                        Yii::app()->db->createCommand($stock_state_as_of_query)->execute();
                        $model = Yii::app()->db->createCommand('SELECT * FROM view_stock_state_as_of_detailed WHERE ' . $condition . ' ORDER BY part_number')->queryAll();
                
                        $totalValue = Yii::app()->db->createCommand('SELECT SUM(quantity*rate)  AS total FROM view_stock_state_as_of_detailed WHERE ' . $condition)->queryScalar();
                
                        $totalValue = number_format(round(($totalValue), 4), 2, '.', '');
                        $m=1;
                            $total = 0;
                            foreach ($model as $row) { 
                                $eachTotal = round(($row['quantity'] * $row['rate']), 4) ;
                                $total +=  $eachTotal;
                                
                                 $part_number="";
                                $description="";
                                $generic_name="";
                                $brand_name = "";
                                $row_show_no="";
                                $product_no="";
                                if($product_id==$row['product_id']){
                                    $class_repeat='yes';
                                    $product_id=$row['product_id'];
                                    $part_number="";
                                    $description="";
                                    $generic_name="";
                                    $brand_name="";
                                    $row_show_no="";
                                    $product_no = "";
                                }
                                else{
                                    $product_id=$row['product_id'];
                                    $product_no=$product_id;
                                    $part_number=$row['part_number'];
                                    $description = $row['description'];
                                    $generic_name=$row['generic_name'];
                                    $brand_name = $row['brand'];
                                    $row_no=$row_no+1;
                                    $row_show_no=$row_no;
                                }
                                                
                                
                                
                        ?>
                                                <tr>
                                                    <td><?php echo $row_show_no; ?></td>
                                                    <td><?php echo $part_number; ?></td>
                                                    <td><?php echo $description; ?></td>
                                                    <td><?php echo $generic_name; ?></td>
                                                    <td><?php echo $brand_name; ?></td>
                                                    <td><?php echo $row['serial_no'] ?></td>
                                                    <td><?php echo $row['batch_no'] ?></td>
                                                    <td><?php echo ($row['expiry_date']!="0000-00-00")?date("d/m/Y",strtotime($row['expiry_date'])):""; ?></td>
                                                    <td><?php echo Yii::app()->numberFormatter->formatCurrency($row['quantity'],""); ?></td>
                                                    <td><?php echo Yii::app()->numberFormatter->formatCurrency((round($row['rate'],2)),""); ?></td>                                                    
                                                    <td class="text-right"><?php echo number_format((float)$eachTotal, 2, '.', '');; ?></td>
                                                </tr>
                        <?php
                     }
                    ?>

                    <tr>
                        <td colspan="10" class="text-right"><b>Total</b></td>
                        <td  class="text-right"><b><?php echo number_format((float)$total, 2, '.', ''); ?></b></td>
                    </tr>
                </tbody>
            </table>
        </div>
       
        <htmlpagefooter name="myfooter">


<div style="text-align:center;width:100%;font-size:10px"><?= Yii::app()->user->footer_autogenerated; ?>
    <?php
              date_default_timezone_set("Asia/Dubai");
             echo date('d/m/Y')." ".date("h:i:sa"); ?>
</div>


    <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; background-color: #d7faeb;">
         <div style="text-align:center;width:100%">
            <b><?= Yii::app()->user->footer_line_1 ?></b><br>
            <?= Yii::app()->user->footer_line_2 ?>
        </div>
        <div style="text-align:center;width:100%">Page {PAGENO} of {nb} </div>
    </div>
</htmlpagefooter>
</body>

</html>