<!DOCTYPE html>
<html>

    <head>
        <title>Quote List</title>
    </head>

    <body>
        <div class="heading">
            <div class="header" style="width:100%;float: left;padding-bottom:10px;">
                <img src="<?php echo 'images/logo/' . Yii::app()->user->pdf_company_logo; ?>"/>
            </div>
            <div class="col-12 text-center" style="margin: 0 auto;">
                <h1><u>QUOTATION LIST</u></h1>
            </div>
            <div class="col-12">
                <div class="details-box">
                    <table class="table" style="width:100%">
                        <?php if ($qtn_start_from_date != '') { ?>
                            <tr>
                                <td style="width: 20%"><b>Quotation From </b></td>
                                <td>
                                    <?php echo date('d/m/Y', strtotime($qtn_start_from_date)); ?>
                                </td>
                            </tr>
                        <?php } ?>
                        <?php if ($qtn_start_to_date != '') { ?>
                            <tr>
                                <td style="width: 20%"><b>Quotation To </b></td>
                                <td>
                                    <?php echo date('d/m/Y', strtotime($qtn_start_to_date)); ?>
                                </td>
                            </tr>
                        <?php } ?>
                        <?php if ($qtn_validity_from_date != '') { ?>
                            <tr>
                                <td style="width: 20%"><b>Valid From</b></td>
                                <td>
                                    <?php echo date('d/m/Y', strtotime($qtn_validity_from_date)); ?>
                                </td>
                            </tr>
                        <?php } ?>
                        <?php if ($qtn_validity_to_date != '') { ?>
                            <tr>
                                <td style="width: 20%"><b>Valid To </b></td>
                                <td>
                                    <?php echo date('d/m/Y', strtotime($qtn_validity_to_date)); ?>
                                </td>
                            </tr>
                        <?php } ?>
                        <?php if ($sales_group != '') { ?>
                            <tr>
                                <td style="width: 20%"><b>Sales Group </b></td>
                                <td>
                                    <?php
                                    $s = MasSalesGroup::model()->findByPK($sales_group);
                                    echo $s->group_name;
                                    ?>
                                </td>
                            </tr>
                        <?php } ?>
                        <?php if ($customer_id != '') { ?>
                            <tr>
                                <td style="width: 20%"><b>Customer</b></td>
                                <td>
                                    <?php
                                    $c = Customer::model()->findByPK($customer_id);
                                    echo $c->customer_name;
                                    ?>
                                </td>
                            </tr>
                        <?php } ?>
                        <?php if ($leadowner_id > 0) { ?>
                            <tr>
                                <td style="width: 20%"><b>Lead Owner</b></td>
                                <td>
                                    <?php
                                    $l = User::model()->findByPK($leadowner_id);
                                    echo $l->first_name . " " . $l->last_name;
                                    ?>
                                </td>
                            </tr>
                        <?php } ?>
                        <?php if ($qtn_country > 0) { ?>
                            <tr>
                                <td style="width: 20%"><b>Country</b></td>
                                <td>
                                    <?php
                                    $country1 = MasCountry::model()->findByPK($qtn_country);
                                    echo $country1['country_name'];
                                    ?>
                                </td>
                            </tr>
                        <?php } ?>
                        <?php if ($qtn_part_no_id > 0) { ?>
                            <tr>
                                <td style="width: 20%"><b>Part No </b></td>
                                <td>
                                    <?php
                                    $part_no_model = Store::model()->findByPK($qtn_part_no_id);
                                    echo $part_no_model->part_number;
                                    ?>
                                </td>
                            </tr>
                        <?php } ?>
                        <?php if ($brand > 0) { ?>
                            <tr>
                                <td style="width: 20%"><b>Brand</b></td>
                                <td>
                                    <?php
                                    $mod_brand = new ProductClass();
                                    $mod_brand = $mod_brand->findByPK($brand);
                                    echo $mod_brand['product_class'];
                                    ?>
                                </td>
                            </tr>
                        <?php } ?>
                        <?php if ($value_from != '') { ?>
                            <tr>
                                <td style="width: 20%"><b>Value From</b></td>
                                <td>
                                    <?php echo $value_from; ?>
                                </td>
                            </tr>
                        <?php } ?>
                        <?php if ($value_to != '') { ?>
                            <tr>
                                <td style="width: 20%"><b>Value To</b></td>
                                <td>
                                    <?php echo $value_to; ?>
                                </td>
                            </tr>
                        <?php } ?>
                        <?php if ($status != '') { ?>
                            <tr>
                                <td style="width: 20%"><b>Status</b></td>
                                <td>
                                    <?php
                                    $status_name = '';
                                    if ($status == 'Y') {
                                        $status_name = 'Open';
                                    }

                                    if ($status == 'C') {
                                        $status_name = 'Closed';
                                    }
                                    if ($status == 'O') {
                                        $status_name = 'Others';
                                    }
                                    if ($status == 'L') {
                                        $status_name = 'Lost';
                                    }
                                    echo $status_name;
                                    ?>                        </td>
                            </tr>
                        <?php } ?>
                        <?php if ($quotes_type != '') {
                            ?><tr>
                                <td style="width: 20%;font-size:11px;"><b>Type</b></td>
                                <td>
                                    <?php echo ($quotes_type == 'sale') ? 'Sales' : 'Service'; ?>
                                </td>
                            </tr>

                        <?php }
                        ?>
                    </table>


                </div>
            </div>
        </div>
        <div class="clearfix"></div>
        <div class="table-body">

            <table id="tbl_qtn_table" class="table ">
                <thead>
                    <tr>
                        <th>SI#</th>
                        <th>Qtn #</th> 
                        <th>Qtn Date</th>  
                        <th>Customer</th>
                        <th>Contact Person</th>
                        <th>Lead Owner</th>
                        <th>Created By</th>
                        <th>Origin</th>

                        <th>Destination</th> 
                        <th>Agent</th>
                        <th>Cnee</th>
                        <th>Ch.Wt</th>
                        <th>Type</th>
                        <th>Status</th>

                        <th>Selling Price</th>
                        <th>Cost</th>
                        <th>Profit</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $condition = '1=1';

                    if ($qtn_start_from_date != '') {
                        $qtn_start_from_date = str_replace('/', '-', $qtn_start_from_date);
                        $qtn_start_from_date = date('Y-m-d', strtotime($qtn_start_from_date));
                        $condition .= ' AND quotation.quotation_date >="' . $qtn_start_from_date . '"';
                    }
                    if ($qtn_start_to_date != '') {
                        $qtn_start_to_date = str_replace('/', '-', $qtn_start_to_date);
                        $qtn_start_to_date = date('Y-m-d', strtotime($qtn_start_to_date));
                        $condition .= ' AND quotation.quotation_date <="' . $qtn_start_to_date . '"';
                    }

                    if ($customer_id != '') {
                        $condition .= ' AND quotation.customer_id ="' . $customer_id . '"';
                    }
                    if ($qtn_shipper_id != '') {
                        $condition .= ' AND quotation.shipper_id= "' . $qtn_shipper_id . '"';
                    }
                    if ($quotation_id != '') {
                        $condition .= ' AND t.quotation_id ="' . $quotation_id . '"';
                    }

                    if ($qtn_consignee_id != '') {
                        $condition .= ' AND quotation.consignee_id  LIKE "%' . $qtn_consignee_id . '%"';
                    }
                    if ($qtn_origin_id != '') {
                        $condition .= ' AND quotation.origin_id ="' . $qtn_origin_id . '"';
                    }
                    if ($qtn_destination_id != '') {

                        $condition .= ' AND quotation.destination_id ="' . $qtn_destination_id . '"';
                    }
                    if ($filter_quotation_transport_type != '') {

                        $condition .= ' AND quotation.transport_type ="' . $filter_quotation_transport_type . '"';
                    }
                    if ($qtn_status != '') {

                        $condition .= ' AND quotation.quotation_status ="' . $qtn_status . '"';
                    }
                    if ($provisional_vendor_id != '') {

                        $condition .= ' AND t.forwarder_id ="' . $provisional_vendor_id . '"';
                    }
                    if ($provisional_transport_type != '') {

                        $condition .= ' AND t.activity_type ="' . $provisional_transport_type . '"';
                    }
                     if($qtn_created_by != ""){
                      $condition .= ' AND quotation.created_by ="' . $qtn_created_by.'"';
                      }
                       if($qtn_leadowner_id != ""){
                      $condition .= ' AND quotation.lead_owner_id ="' . $qtn_leadowner_id.'"';
                      }

                    $model_quote = QuotationItems::model()->with('quotation', 'vendordetails', 'activitytype')->findAll(array('condition' => $condition));

                    foreach ($model_quote as $i => $model) {

                        $destination_id = '';
                        if ((int) $model['quotation']['destination_id'] > 0) {
                            $destination_id = MasCountry::model()->findByPk($model['quotation']['destination_id'])->country_name;
                        }
                        $origin_id = '';
                        if ((int) $model['quotation']['origin_id'] > 0) {
                            $origin_id = MasCountry::model()->findByPk($model['quotation']['origin_id'])->country_name;
                        }
                        
                        
                         switch($model['quotation']['quotation_status']){

                          case 'CL':
                          $row_quotation_status="Closed";
                          break;
                          case 'A':
                          $row_quotation_status="Awaiting";
                          break;
                          case 'CO':
                          $row_quotation_status="Confirmed";
                          break;
                          break;
                          case 'CA':
                          $row_quotation_status="Cancel";
                          break;
                          default:
                          $row_quotation_status="Open";
                          break;
                          } 
                        
                        ?>

                        <tr>
                            <td><?php echo $i + 1; ?></td>
                            <td><?php echo $model->quotation_id; ?></td>

                            <?php if ($model->quotation->quotation_date != '0000-00-00') { ?>
                                <td><?php echo date("d/m/Y", strtotime($model->quotation->quotation_date)); ?></td>
                            <?php } else { ?>
                                <td>&nbsp;</td>
                            <?php } ?>
                            <td style="width:10px;"><?php echo $model->quotation->customer->customer_name; ?></td>
                             <td>
                             <?php
                            if($model->quotation->contact_ids!=""){
                               
                              $contact = explode(",", $model->quotation->contact_ids); 
                              if(count ($contact) >1){
                                   $contactdet = array();
                                foreach ($contact as $row){
                                   
                                  $contactdetails = CustomerContact::model()->findByPK($row);
                                  $contactdet[]= $contactdetails->person_name; 
                                  
                                }
                               
                                if(!empty($contactdet)) {
                                echo   implode(",", $contactdet);  
                                }
                               }
                                else {
                                    $contactdetails = CustomerContact::model()->findByPK($model->quotation->contact_ids);
                                   
                                    echo $contactdetails->person_name;
                                }
                            }
                            
                        
                        ?>
   
                         </td>
                             <td class="nw"><?php echo $model->quotation->leadowner->fullName;?></td>
                              <td class="nw"> <?php echo $model->quotation->createdby->fullName; ?></td>

                            <td><?php echo $origin_id; ?></td>

                            <td><?php echo $destination_id; ?></td>

                            <td width="8%"><?php echo $model->vendordetails->vendor_name; ?></td>
                            <td width="8%"><?php echo $model->quotation->consignee_id; ?></td>
                             <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($model->quotation->chargeable_weight,""); ?></td>
                            <td width="8%"><?php echo $model->activitytype->activity_type; ?></td>
                            <td width="8%"><?php echo $row_quotation_status; ?></td>
                         

                            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($model->planned_selling_price, ""); ?></td>
                            <td  class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($model->planned_cost, ""); ?></td>
                            <?php
                            $planned_profit = $model->planned_selling_price - $model->planned_cost;
                            $total_planned_cost += $model->planned_cost;

                            $total_selling_price += $model->planned_selling_price;
                            $total_planned_profit+=$planned_profit;
                            ?>
                            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($planned_profit, ""); ?></td>

                        </tr>
                    <?php } ?>
                    <tr>
                        <td colspan="14"> </td>

                        <td class="text-right"><b> <?php echo Yii::app()->numberFormatter->formatCurrency($total_selling_price, " "); ?></b> </td>
                        <td class="text-right"><b> <?php echo Yii::app()->numberFormatter->formatCurrency($total_planned_cost, " "); ?></b> </td>
                        <td class="text-right"><b> <?php echo Yii::app()->numberFormatter->formatCurrency($total_planned_profit, " "); ?></b> </td>


                    </tr>

                </tbody>
            </table>

            <htmlpagefooter name="myfooter">
                <div style="text-align:center;width:100%;font-size:10px"><?= Yii::app()->user->footer_autogenerated; ?>
                    <?php
                    date_default_timezone_set("Asia/Dubai");
                    echo date('d/m/Y') . " " . date("h:i:sa");
                    ?>
                </div>
                <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; background-color: #d7faeb;">
                    <div style="text-align:center;width:100%">
                        <b><?= Yii::app()->user->footer_line_1 ?></b><br>
                        <?= Yii::app()->user->footer_line_2 ?>
                    </div>
                    <div style="text-align:center;width:100%">Page {PAGENO} of {nb} </div>
                </div>
            </htmlpagefooter>
            <sethtmlpagefooter name="myfooter" page="all" value="on" />
    </body>

</html>