<!DOCTYPE html>
<html>

    <head>
        <title>Gross Profit</title>
    </head>
        <body>
        <div class="heading">
             <div class="logo col-6">
                <img src="images/pdf/logo.png">
            </div>
        <div class="col-12 text-center" style="margin: 0 auto;">
            <h1><u>Gross Profit</u></h1>
        </div>
        <div class="col-12">
            <div class="details-box">
                <table class="table" style="width:100%">
                    <?php  if($from_date !=''){  ?>
                    <tr>
                        <td style="width: 20%"><b>From </b></td>
                        <td>
                            <?php echo date('d/m/Y', strtotime($from_date)); ?>
                        </td>
                    </tr>
                    <?php } ?>
                    <?php   if ($to_date != '') {  ?>
                    <tr>
                        <td style="width: 20%"><b> To</b></td>
                        <td>
                            <?php echo date('d/m/Y', strtotime($to_date));?>
                        </td>
                    </tr>
                    <?php } ?>
                    <?php   if ($customer_id != '') {  ?>
                    <tr>
                        <td style="width: 20%"><b>Customer</b></td>
                        <td>
                            <?php $c = Customer::model()->findByPK($customer_id);
                                echo $c->customer_name; ?>
                        </td>
                    </tr>
                    <?php } ?>
                    <?php   if ($leadowner_id  > 0) {?>
                    <tr>
                        <td style="width: 20%"><b>Lead Owner</b></td>
                        <td>
                            <?php $l = User::model()->findByPK($leadowner_id);
                                    echo $l->first_name." ".$l->last_name; ?>
                        </td>
                    </tr>
                    <?php } ?>
                    <?php if ($sales_group != '') { ?>
                    <tr>
                        <td style="width: 20%"><b>Sales Group</b></td>
                        <td>
                            <?php $s = MasSalesGroup::model()->findByPK($sales_group);
                                    echo $s->group_name; ?>
                        </td>
                    </tr>
                    <?php } ?>
                    
                    <?php  if ($inv_type > 0) {?>
                    <tr>
                        <td style="width: 20%"><b>Invoice Type</b></td>
                        <td>
                            <?php $l = MasInvoiceType::model()->findByPK($inv_type);
                                echo $l->inv_name;?>
                        </td>
                    </tr>
                    <?php } ?></table>
            </div>
            </div>
        </div>
        <div class="clearfix"></div>
        <div class="table-body">
            <table id="tbl_invoice_table" class="table table-fixed table-bordered table-primary dataTable">
                <thead>
                    <tr>
                        <th>Sl</th>
                        <th>File ID</th>
                        <th>Invoice No</th>
                        <th>Invoice Date</th>
                        <th>Customer Name</th>                        
                        <th>Currency</th>                        
                        <th>Invoice Value</th> 
                        <th>Value(BC)</th> 
                        <th>Cost</th> 
                        <th>Profit</th> 
                        <th>Profit (%)</th> 
                        <th>Lead Owner </th>
                        <th>Sales Group</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
        $condition = "1=1"; 
            if ($from_date != '') {
                        $from_date = str_replace('/', '-', $from_date);
                        $from_date = date('Y-m-d', strtotime($from_date));
                        $condition .= ' AND I.invoice_date >="' . $from_date . '"';
                    }
                    if ($to_date != '') {
                        $to_date = str_replace('/', '-', $to_date);
                        $to_date = date('Y-m-d', strtotime($to_date));
                        $condition .= ' AND I.invoice_date <="' . $to_date . '"';
                    }
                    if ($customer_id != '') {
                        $condition .= ' AND C.id = "' . $customer_id . '"';
                    }
                    if ($sales_group > 0) {
                        $condition .= ' AND I.sales_group = "' . $sales_group . '"';
                    }
                    if ($leadowner_id > 0) {
                        $condition .= ' AND (F.lead_owner_id = "' . $leadowner_id . '" OR I.lead_owner_id = "' . $leadowner_id . '")';
                    }
                    if ($inv_type > 0) {
                        $condition .= ' AND I.invoice_type = "' . $inv_type . '"';
                    }
                    $total_invoice_val = $total_profit = $total_cost = 0;
                    $query = 'SELECT 
                        SUM(IT.rate) AS selling_price,
                        I.invoice_date AS invoice_date,
                        I.delivery_ids AS delivery_note_ids,
                        I.file_id AS file_id,
                        I.id AS invoiceid,
                        I.exchange_rate AS exchange_rate,
                        CONCAT(IC.inv_code,"-",I.invoice_no) AS invoice_no,
                        C.customer_name AS customer,I.sales_group,F.lead_owner_id AS file_lead_owner_id,I.lead_owner_id AS invoice_lead_owner_id,
                        (I.grand_total-I.total_tax_amount) AS  invoice_amt,
                        (I.grand_total-I.total_tax_amount) * I.exchange_rate AS invoice_value_bc,
                        CR.currency_code AS currency_name
                        FROM erp_invoice_item IT
                        LEFT JOIN erp_invoice I ON I.id = IT.invoice_id 
                        LEFT JOIN erp_master_file F ON F.id = I.file_id 
                        LEFT JOIN erp_customer C ON I.customer_id = C.id
                        LEFT JOIN erp_mas_currency CR ON I.currency = CR.id
                        LEFT JOIN erp_mas_invoice_type IC ON I.invoice_type = IC.id
                        WHERE ' . $condition . '
                        GROUP BY I.id
                        ORDER BY I.id DESC';
                    $model_invoice = Yii::app()->db->createCommand($query)->queryAll();
                    $no = 0;
                    $invoice_amt =0;
                    foreach ($model_invoice as $i => $model) {
                        
                        $exchange_rate  = $model['exchange_rate'];
                        
                        /***************  check credit note amt ***************/
                        $credit_note_amt  = 0;                        
                        $creditNote = Yii::app()->db->createCommand()
                                ->select('sum(credited_amount) as credited_amount')
                                ->from('erp_creditnote')
                                ->where('invoice_id = ' . $model['invoiceid'])
                                ->queryRow();
                        if($creditNote['credited_amount']>0){
                            $credit_note_amt = $creditNote['credited_amount'];
                        }
                        /************************   end credit Note amt ******************/
                        /***************   check credit note actual cost  ***********************/ 
                        $cn_cost  = 0;                       
                        $model_credit_note = CreditnoteItem::model()->with('parent')->findAll(array('condition' => 'parent.invoice_id IN (' .$model['invoiceid'] . ')'));
                        if (!empty($model_credit_note)){
                            foreach ($model_credit_note as $each) {
                                //$cost += ($each->quantity * $each->cost_price);
                                $cn_product_id  = $each['product_id'];
                                //$cn_quantity    = $each['returned_quantity'];
                                $model_cn_cost  = StockLedger::model()->find(array('condition' => 'header_id IN (' . $model['delivery_note_ids'] . ') AND product_id="'.$cn_product_id.'"'));
                                if(empty($model_cn_cost['cost_price']) OR $model_cn_cost['cost_price']<=0){
                                    $model_cn_cost['cost_price'] = 0;
                                }
                                $cn_cost += (($each['returned_quantity']+$each['returned_bonus_qty']) * $model_cn_cost['cost_price']);
                            }
                        }
                        /************************   end credit note actual cost ******************/
                        
                        $actual_invoice_amt = $model['invoice_amt']-$credit_note_amt;
                        $invoice_value_bc   = $actual_invoice_amt*$exchange_rate;
                        //$total_selling_price = $model['invoice_value_bc'];
                        $total_selling_price = $invoice_value_bc;
                        ?>
                        <?php
                        $no++;
                        $cost = 0;
                        $ledger = StockLedger::model()->findAll(array('condition' => 'header_id IN (' . $model['delivery_note_ids'] . ')'));
                        if (!empty($ledger))
                            foreach ($ledger as $each) {
                                $cost += ($each->quantity * $each->cost_price);
                            }
                        ?>
                        <tr>
                            <td class="text-right"> <?php echo $no; ?></td>
                            <td class="text-right">
                                <?php echo $model['file_id']; ?>
                            </td>
                            <td class="text-right">
                                <?php echo $model['invoiceid']; ?>
                            </td>
                            <?php
                            $date = $model['invoice_date'];
                            if ($date != '0000-00-00') {
                                $newdate = date("d/m/Y", strtotime($date));
                                ?>
                                <td>
                                    <?= $newdate; ?>
                                </td>
                            <?php } else { ?>
                                <td></td>
                            <?php } ?>
                            <td> 
                                <?php echo $model['customer']; ?>
                            </td>
                            <td >
                                <?php echo $model['currency_name']; ?>
                            </td>

                            <td class="text-right"> <?php //echo Yii::app()->numberFormatter->formatCurrency($model['invoice_amt'], " ");
                            //$invoice_amt +=$model['invoice_amt'];
                             echo Yii::app()->numberFormatter->formatCurrency($actual_invoice_amt, " ");
                            $invoice_amt +=$actual_invoice_amt;
                            ?>

                            </td>

                            <td class="text-right"> <?php echo Yii::app()->numberFormatter->formatCurrency($total_selling_price, " "); ?>
                                <?php $total_invoice_val += ($total_selling_price); ?> 
                            </td>

                            <td class="text-right"> 
                                <?php echo Yii::app()->numberFormatter->formatCurrency($cost, " "); ?>
                                <?php $total_cost += $cost; ?>
                            </td>

                            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency(($total_selling_price + $cost), " "); ?>  </td>

                            <?php
                            $total_profit += ($total_selling_price - $cost);
                            $profit_in_percentage =0;
                            if($total_selling_price > 0){
                                $profit_in_percentage = (($total_selling_price + $cost) / $total_selling_price) * 100;
                            }
                            ?>
                            <td class="text-right"><? echo Yii::app()->numberFormatter->formatCurrency($profit_in_percentage," ") ?>  </td>
                            <td class="nw">
                                <?php 
                                if($model['invoice_lead_owner_id'] > 0){
                                    $lead_owner_id = $model['invoice_lead_owner_id'];
                                }
                                else{
                                    $lead_owner_id = $model['file_lead_owner_id'];
                                }
                                $l = User::model()->findByPK($lead_owner_id);
                                    echo $l->fullname; ?>
                            </td>
                            <td class="nw">
                                <?php
                                echo MasSalesGroup::model()->findByPk($model['sales_group'])->group_name;
                                ?>
                            </td>
                        </tr>


                    <?php }
                    ?>
			<tr>
                        <td colspan="7"> </td>
                        <!--td class="text-right"><b><?php //echo Yii::app()->numberFormatter->formatCurrency($invoice_amt, " "); ?></b> </td-->
                        <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_invoice_val, " "); ?></b></td>
                        <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_cost, " "); ?></b></td>
                        <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_profit, " "); ?></b><b> 
                                <?php echo $profit; ?></b> </td>
                        
                        <td class="text-right"><b></b> </td>
                        <td colspan="2" class="text-right"><b></b> </td>
                    </tr>
                        
                </tbody>
            </table>
           
        </div>

    <htmlpagefooter name="myfooter">
        <div style="text-align:center;width:100%;font-size:10px"><?= Yii::app()->user->footer_autogenerated; ?>
            <?php
                      date_default_timezone_set("Asia/Dubai");
                     echo date('d/m/Y')." ".date("h:i:sa"); ?>
        </div>
        <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; background-color: #d7faeb;">
             <div style="text-align:center;width:100%">
                <b><?= Yii::app()->user->footer_line_1 ?></b><br>
                <?= Yii::app()->user->footer_line_2 ?>
            </div>
            <div style="text-align:center;width:100%">Page {PAGENO} of {nb} </div>
        </div>
    </htmlpagefooter>
</body>

</html>
