<html>

    <head>
        <title> Provisional Job Order List </title>
    </head>

    <body>
        <div class="heading">
            <div class="header" style="width:100%;float: left;padding-bottom:10px;">
                <img src="<?php echo 'images/logo/' . Yii::app()->user->pdf_company_logo; ?>"/>
            </div>
        </div><div class="panel">
            <div class="panel-heading panel-theme clearfix report-head">
                List of Provisional Job Order Report
                <div class="pull-right">
                    <div class="filter_details">
                        <?php if ($provisional_from_date != '') { ?>
                            <div class="filter-item">
                                <label>Provisional From :</label>
                                <?php echo date('d/m/Y', strtotime($provisional_from_date)); ?>

                            </div>
                            <?php
                        }
                        if ($provisional_to_date != '') {
                            ?>
                            <div class="filter-item">
                                <label>Provisional To :</label>
                                <?php echo date('d/m/Y', strtotime($provisional_to_date)); ?>

                            </div>

                        <?php } ?>
                    </div>
                </div>
            </div>
            <div class="panel-body">
                <div class="table-responsive">
                    <table id="tbl_invoice_table" class="table table-fixed table-bordered table-primary dataTable">
                        <thead>
                            <tr>
                                <th>No</th>
                                <th>Job No</th>
                                <th>Customer</th>
                                <th>Lead Owner</th>
                                <th>Forwarder</th>
                                <th>AWB No</th>
                                <th>Type</th>
                                <th>Selling Price</th>
                                <th>Planned Cost</th>
                                <th>Planned Profit</th>

                            </tr>
                        </thead>
                        <tbody>
                        <tbody>
                            <?php
                              $condition="job_order_status!='CN'";


                            if ($provisional_from_date != '') {
                                $provisional_from_date = str_replace('/', '-', $provisional_from_date);
                                $provisional_from_date = date('Y-m-d', strtotime($provisional_from_date));
                                $condition .= ' AND joborder.job_date >="' . $provisional_from_date . '"';
                            }
                            if ($provisional_to_date != '') {
                                $provisional_to_date = str_replace('/', '-', $provisional_to_date);
                                $provisional_to_date = date('Y-m-d', strtotime($provisional_to_date));
                                $condition .= ' AND joborder.job_date <="' . $provisional_to_date . '"';
                            }


                            if ($provisional_customer_id > 0) {

                                $condition .= ' AND joborder.customer_id ="' . $provisional_customer_id . '"';
                            }
                            if ($provisional_leadowner_id > 0) {

                                $condition .= ' AND joborder.lead_owner_id ="' . $provisional_leadowner_id . '"';
                            }


                            if ($job_order_id != "") {

                                $condition .= ' AND job_order_id ="' . $job_order_id . '"';
                            }
                            if ($provisional_vendor_id != "") {

                                $condition .= ' AND t.shipper_id ="' . $provisional_vendor_id . '"';
                            }
                            if ($provisional_transport_type != "") {

                                $condition .= ' AND t.activity_type ="' . $provisional_transport_type . '"';
                            }
                            if ($provisional_awb_no != "") {

                                $condition .= ' AND t.awb_no ="' . $provisional_awb_no . '"';
                            }


                            $model_provisional_detailed = JobOrderAgentDetails::model()->with('joborder')->findAll(array('condition' => $condition, 'order' => 'job_order_id DESC'));

                            $total = 0;
                            $actual_cost = 0;
                            $total_selling_price = 0;
                            $total_planned_cost = 0;
                            $total_planned_profit = 0;
                            $total_actual_cost = 0;
                            $total_actual_profit = 0;

                            foreach ($model_provisional_detailed as $i => $model) {

                                $planned_profit = $model->planned_selling_price - $model->planned_cost;
                                //$actual_profit = $invoice_amount - $model->actual_cost;
                                $actual_profit = 0;
                                $planned_profit_style = "";
                                if ($planned_profit < 0) {
                                    $planned_profit_style = "color:red";
                                }

                                $actual_profit_style = "";
                                if ($planned_profit > $actual_profit) {
                                    $actual_profit_style = "color:red";
                                } else if ($planned_profit < $actual_profit) {
                                    $actual_profit_style = "color:green";
                                }
                                ?>

                                <tr>

                                    <td width="2%"><?php echo $i + 1; ?></td>

                                    <td width="5%"><?php echo $model->joborder->id; ?></td>
                                    <td width="15%"><?php echo $model->joborder->customer->customer_name; ?></td>
                                    <td width="10%">
                                        <?php echo $model->joborder->leadowner->first_name . ' ' . $model->joborder->leadowner->last_name; ?>
                                    </td>
                                    <td width="8%"><?php echo $model->shipper->vendor_name; ?></td>
                                    <td width="10%"><?php echo $model->awb_no; ?></td>
                                    <td width="8%"><?php echo $model->activitytype->activity_type; ?></td>
                                    <td width="5%" class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($model->planned_selling_price, ""); ?></td>
                                    <td width="5%" class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($model->planned_cost, ""); ?></td>
                                    <td width="5%" class="text-right" style="<?php echo $planned_profit_style; ?>"><?php echo Yii::app()->numberFormatter->formatCurrency($planned_profit, ""); ?></td>
                                    <?php
                                    $total_planned_cost += $model->planned_cost;
                                    $total_invoice_amount += $grand_total;
                                    $total_selling_price += $model->planned_selling_price;
                                    $total_planned_profit += $planned_profit;
                                    ?>

                                </tr>
                            <?php } ?>

                            <tr>
                                <td colspan="7"> </td>
                                <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_selling_price, " "); ?></b></td>
                                <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_planned_cost, " "); ?></b></td>
                                <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_planned_profit, " "); ?></b></td>
                            </tr>
                        </tbody>
                    </table>
                    <br>

                </div>
            </div>
        </div>
    <htmlpagefooter name="myfooter">
        <div style="text-align:center;width:100%;font-size:10px"><?= Yii::app()->user->footer_autogenerated; ?>
            <?php
            date_default_timezone_set("Asia/Dubai");
            echo date('d/m/Y') . " " . date("h:i:sa");
            ?>
        </div>
        <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; background-color: #d7faeb;">
            <div style="text-align:center;width:100%">
                <b><?= Yii::app()->user->footer_line_1 ?></b><br>
                <?= Yii::app()->user->footer_line_2 ?>
            </div>
            <div style="text-align:center;width:100%">Page {PAGENO} of {nb} </div>
        </div>
    </htmlpagefooter>
    <sethtmlpagefooter name="myfooter" page="all" value="on" />
</body>

</html>

