<!DOCTYPE html>
<html>

    <head>
        <title> Commission / Incentive Report</title>
    </head>

    <body>
        <div class="heading">
             <div class="logo col-6">
                <img src="images/pdf/logo.png">
            </div> 
        <div class="col-12 text-center" style="margin: 0 auto;">
            <h1><u>Invoice Commission / Incentive Invoice Report</u></h1>
        </div>
        <div class="col-12">
            <div class="details-box">
                <table class="table" style="width:100%">
                    <?php  
                    $customer_id = $arr_details['customer_id'];
                        $leadowner_id = $arr_details['leadowner_id'];
                        $from_date = $arr_details['from_date'];
                        $to_date = $arr_details['to_date'];
                        $condition = "1=1 ";
                        if ($from_date != '') {
                            $str_from_date = str_replace('/', '-', $from_date);
                            $str_from_date = date("Y-m-d", strtotime($str_from_date));
                            $condition .= ' AND t.invoice_date >="' . $str_from_date . '"';
                        }
                        if ($to_date != '') {
                            $str_to_date = str_replace('/', '-', $to_date);
                            $str_to_date = date("Y-m-d", strtotime($str_to_date));
                            $condition .= ' AND t.invoice_date <="' . $str_to_date . '"';
                        }
                        if ($customer_id > 0) {
                            $condition.=" AND t.customer_id=" . $customer_id;
                        }
                        if ($leadowner_id > 0) {
                            $condition.=" AND file.lead_owner_id=" . $leadowner_id;
                        }
                    if($from_date !=''){  ?>
                    <tr>
                        <td style="width: 20%"><b>From Date </b></td>
                        <td>
                            <?php echo $from_date; ?>
                        </td>
                    </tr>
                    <?php } ?>
                    <?php  if($to_date !=''){  ?>
                    <tr>
                        <td style="width: 20%"><b>To Date </b></td>
                        <td>
                            <?php echo $to_date; ?>
                        </td>
                    </tr>
                    <?php } ?>
                    <?php if($customer_id > 0){?>
                    <tr>
                        <td style="width: 20%"><b>Customer</b></td>
                        <td>
                            <?php 
                            $c = Customer::model()->findByPK($customer_id);
                            echo $c->customer_name; ?>
                        </td>
                    </tr>
                    <?php } ?>
                    <?php if ($leadowner_id > 0) { ?>
                    <tr>
                        <td style="width: 20%"><b>Lead Owner</b></td>
                        <td>
                            <?php $l = User::model()->findByPK($leadowner_id);
                                    echo $l->first_name." ".$l->last_name ?>
                        </td>
                    </tr>
                    <?php } ?>    
                </table>
            </div>
                </div>
                
            </div>
        <div class="clearfix"></div>
        <div class="table-body">
                    <table id="tbl_order_table" class="table table-fixed table-bordered table-primary dataTable">
                        <thead>
                            <tr>
                                <th>File No</th>
                                <th>Invoice No</th>
                                <th>Invoice Date</th>
                                <th>Customer</th>
                                <th>Lead Owner</th>
                                <th>Net Sale</th>
                                <th>Cost Rate</th>
                                <th>Profit</th>
                                <th>Profit(%)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $files = Invoice::model()->with('items', 'returnedAmount','file')->findAll(array('condition' => $condition, 'order' => 't.invoice_no ASC'));
                            $grand_total = 0;
                            $cnt = 0;
                            $total_net_sale = 0;
                            $total_net_cost_rate = 0;
                            $total_profit = 0;
                            foreach ($files as $i => $eachFile) {
                                $cost_rate = 0;
                                $net_cost_rate = 0;
                                foreach ($eachFile->items as $products) {
                                    
                                $quantity	=	$products->quantity;
                
                                 $modelProduct = new Store();
                				$product_details = $modelProduct->findbypk($products->product_id);
                				
                				$actual_rate = $product_details->rate;
                				
                				$product_class_id = $product_details->brand_class_id;
                				
                				$arr_master_settings	=	ProfitSettings::model()->find('product_class_id='.$product_class_id);
                				
                				
                				$landing_cost_percentage = $arr_master_settings->landing_cost_percentage;
                        		$internal_cost_percentage = $arr_master_settings->internal_cost_percentage;
                        		
                        		$landing_cost_price	=($actual_rate+($actual_rate*($landing_cost_percentage/100)));
                        		$incentive_cost_price=($landing_cost_price+($landing_cost_price*($internal_cost_percentage/100)));
                        		
                        		
                        		$cost_rate          =	$incentive_cost_price * $quantity;
                                $net_cost_rate      += $cost_rate;
                                    
                                    
                                    /*$query = "SELECT cost_value_per_unit,total_cost_value FROM {{profit_calc}} AS PC 
                          INNER JOIN {{profit_calc_item}} AS PCI ON PC.id=PCI.profit_calc_id 
                          WHERE PC.file_id=" . $eachFile->file_id . " AND PCI.product_id=" . $products->product_id;
                                    $arr_cost_rate = Yii::app()->db->createCommand($query)->queryAll();

                                    $quantity = $products->quantity;
                                    if (count($arr_cost_rate) > 0) {
                                        //$cost_rate = number_format(round($arr_cost_rate[0]['total_cost_value'], 2), 2, '.', '');
                                        $cost_rate = number_format(round($arr_cost_rate[0]['cost_value_per_unit'], 2), 2, '.', '');
                                        $cost_rate = $cost_rate * $quantity;
                                        $net_cost_rate+= $cost_rate;
                                    }*/
                                }
                                //$invoice_total = $eachFile->grand_total;
                                $invoice_total      = ($eachFile->grand_total-$eachFile->total_tax_amount);
                                //$credit_total = $eachFile->returnedAmount;
                                $credit_total 		= ($eachFile->returnedAmount-$eachFile->returnedVATAmount);
                                $net_total = (($invoice_total - $credit_total) * $eachFile->file->order->exchange_rate);
                                $grand_total = $grand_total + $net_total;
                                $profit = 0;
                                if ($net_total > 0)
                                    $profit = $net_total - $net_cost_rate;
                                $profit_in_percentage = ($net_total > 0) ? round(($profit / $net_total) * 100, 2) : 0;
                                
                                $invoice_no   = $eachFile->invoice_no;
                                $invoice_type = $eachFile->invoice_type;
                                if((int) $invoice_type > 0){
                                    $modelInvoiceType         = new MasInvoiceType();
                                    $arr_invoice_type_details = $modelInvoiceType->findByPk((int) $invoice_type);
                                    $inv_code                 = $arr_invoice_type_details->inv_code;
                                    $invoice_no               = $inv_code.'-'.$invoice_no;
                                }

                                $leadOwnerName = "";
                                if (isset($eachFile->file->leadowner->first_name))
                                    $leadOwnerName = $eachFile->file->leadowner->first_name . " " . $eachFile->file->leadowner->last_name;
                                ?>
                                <tr>
                                    <td class = "cell-left"><?php echo $eachFile->file_id; ?></td>
                                    <td class = "cell-left"><?php echo $invoice_no; ?></td>
                                    <td><?php echo date("d/m/Y", strtotime($eachFile->invoice_date)); ?></td>
                                    <td class = "cell-left"><?php echo $eachFile->customer->customer_name; ?></td>
                                    <td class = "cell-left"><?php echo $leadOwnerName; ?></td>
                                    <td  class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($net_total, ""); ?></td>
                                    <td  class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($net_cost_rate, ""); ?></td>
                                    <td  class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($profit, ""); ?></td>
                                    <td  class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($profit_in_percentage, ""); ?></td>
                                </tr>
                                <?php
                                $total_net_sale+=$net_total;
                                $total_net_cost_rate+=$net_cost_rate;
                                $total_profit+=$profit;
                                $cnt++;
                            }
                            if ($cnt == 0) {
                                ?>
                                <tr class = "' . $class . '"><td colspan="8">No Result Found</td></tr>
                                <?php
                            } else {
                                ?>
                                <tr class = "' . $class . '">
                                    <td class = "cell-left"></td>
                                    <td class = "cell-left"></td>
                                    <td class = "cell-left"></td>
                                    <td class = "cell-left"></td>
                                    <td class = "cell-left"></td>
                                    <td  class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_net_sale, ""); ?></b></td>
                                    <td  class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_net_cost_rate, ""); ?></b></td>
                                    <td  class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_profit, ""); ?></b></td>
                                    <td  class="text-right"></td>
                                </tr>
                            <?php } ?>

                        </tbody>
                    </table>

                </div>
        <htmlpagefooter name="myfooter">
        <div style="text-align:center;width:100%;font-size:10px"><?= Yii::app()->user->footer_autogenerated; ?>
            <?php
                      date_default_timezone_set("Asia/Dubai");
                     echo date('d/m/Y')." ".date("h:i:sa"); ?>
        </div>
        <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; background-color: #d7faeb;">
             <div style="text-align:center;width:100%">
                <b><?= Yii::app()->user->footer_line_1 ?></b><br>
                <?= Yii::app()->user->footer_line_2 ?>
            </div>
            <div style="text-align:center;width:100%">Page {PAGENO} of {nb} </div>
        </div>
    </htmlpagefooter>
</body>

</html>
