<?php
if ($type == 'LCP') {
    $display_type = "Landing Cost Price";
} else if ($type == 'BCP') {
    $display_type = "Base Cost Price";
} else if ($type == 'ICP') {
    $display_type = "Incentive Cost Price";
} else if ($type == 'INCP') {
    $display_type = "Internal Cost Price";
}
?>
<html>
    <head>
        <title><?php echo $display_type; ?></title>  
    </head>
    <body>
        <div class="heading">
            <div class="logo col-6">
                <img src="<?php echo Yii::app()->baseUrl . '/images/logo/' . Yii::app()->user->pdf_company_logo; ?>" class="logo">
            </div>

        </div>
        <div class="panel">
            <div class="panel-heading panel-theme clearfix report-head ">
                Pricing Group
                <div class="pull-right">
                    <div class="filter_details">            
                        <?php
                        if ($type != '') {
                            ?>
                            <div class="filter-item">
                                <label>price group: </label>
                                <?php echo $display_type; ?>
                            </div>

                            <?php
                        }
                        ?>   
                    </div>
                </div>
            </div>
            <?php
            $sql = "SELECT rate,part_number,brand_class_id,id
                            FROM crm_store where isActive='Y' AND inventory_item_type='1' ORDER BY id ASC";
            $model_group = Yii::app()->db->createCommand($sql)->queryAll();
            ?>
            <div class="panel-body">
                <div class="table-responsive">
                    <table id="tbl_invoice_table" class="table table-fixed table-bordered table-primary dataTable">
                        <thead>
                            <tr>
                                <th>No</th>
                                <th>Part Number</th>
                                <th>Rate</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $sno = 1;

                            if (!empty($model_group)) {
                                foreach ($model_group AS $model_group) {

                                    $actual_rate = $model_group['rate'];
                                    $product_class_id = $model_group['brand_class_id'];


                                    $arr_master_settings = ProfitSettings::model()->find('product_class_id=' . $product_class_id);
                                    $landing_cost_percentage = $arr_master_settings['landing_cost_percentage'];
                                    $internal_cost_percentage = $arr_master_settings->internal_cost_percentage;
                                    $landing_cost_price = ($actual_rate + ($actual_rate * ($landing_cost_percentage / 100)));
                                    $incentive_cost_price = ($landing_cost_price + ($landing_cost_price * ($internal_cost_percentage / 100)));


                                    $model_cost_price = CostPriceGroup::model()->find('product_id=' . $model_group['id']);

                                    if ($type == 'LCP') {
                                        $rate = $landing_cost_price;
                                    } else if ($type == 'BCP') {
                                        $rate = $actual_rate;
                                    } else if ($type == 'ICP') {
                                        $rate = $incentive_cost_price;
                                    } else if ($type == 'INCP') {
                                        $rate = $model_cost_price->cost_price1;
                                    }
                                    ?>
                                    <tr>
                                        <td><?php echo $sno; ?></td>
                                        <td><?php echo $model_group['part_number']; ?></td>
                                        <td style="text-align: right;"><?php echo number_format((float) $rate, 2, '.', ''); //$model_group['base_sales_price'];  ?></td>

                                    </tr>
                                    <?php
                                    $sno++;
                                }
                            } else {
                                ?>
                                <tr>
                                    <td colspan="8">No data found</td>
                                </tr>
                                <?php
                            }
                            ?>
                        </tbody>
                    </table>


                </div>
            </div>

        </div>
            <htmlpagefooter name="myfooter">

        <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; ">
            <div style="binvoice-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; ">
                <div style="text-align:center;width:100%">This report is auto generated by Bluesky ERP on
                    <?php
                    date_default_timezone_set("Asia/Dubai");
                    echo date('d/m/Y') . " " . date("h:i:sa");
                    ?>
                    
                </div>
                <div style="text-align:center;width:100%">Page {PAGENO} of {nb} </div>
            </div></div>
    </htmlpagefooter>
    <sethtmlpagefooter name="myfooter" page="all" value="on" />
    </body>
</html>

