<html>
<head>
    <title>STOCK STATE</title>
</head>
<body>
    <div class="heading">
        <div class="header" style="width:100%; float:left; padding-bottom:10px;">
            <img src="<?php echo 'images/logo/' . Yii::app()->user->pdf_company_logo; ?>"/>
        </div>
    </div>
    <div class="panel">
        <div class="col-12 text-center" style="margin: 0 auto;">
            <h1><u>STOCK STATE</u></h1>
        </div>
        <div class="col-12">
            <div class="details-box">
                <table class="table" style="width:100%">
                    <?php if ($to_date != '') { ?>
                        <tr>
                            <td><b>As on date</b></td>
                            <td><?php echo date('d/m/Y', strtotime($to_date)); ?></td>
                        </tr>
                    <?php } ?>
                    <?php if ($generic_id != '') {
                        $modelGeneric = MasGeneric::model()->findByPk($generic_id); ?>
                        <tr>
                            <td><b>Generic</b></td>
                            <td><?php echo $modelGeneric->generic_name; ?></td>
                        </tr>
                    <?php } ?>
                    <?php if ($brand_id != '') {
                        $modelBrand = ProductClass::model()->findByPk($brand_id); ?>
                        <tr>
                            <td><b>Brand / Class</b></td>
                            <td><?php echo $modelBrand->product_class; ?></td>
                        </tr>
                    <?php } ?>
                </table>
            </div>
        </div>
        <div class="row">&nbsp;</div>
        <div class="table-body">
            <table class="table table-fixed table-bordered table-primary dataTable">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Customer</th>
                        <th>Part Number</th>
                        <th>Description</th>
                        <th>Generic</th>
                        <th>Brand / Class</th>
                        <th>Quantity</th>
                        <th>Rate</th>
                        <th>Value</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $totalValue = 0;
                    foreach ($model as $i => $row) {
                        $total_qty = $row['in_qty'] - $row['out_qty'];
                        $total = number_format(round(($total_qty * $row['rate']), 4), 2, '.', '');
                        $totalValue += ($total_qty * $row['rate']);
                    ?>
                        <tr>
                            <td><?php echo $i + 1; ?></td>
                            <td><?php echo $row['customer_name']; ?></td>
                            <td><?php echo $row['part_number']; ?></td>
                            <td><?php echo $row['description']; ?></td>
                            <td><?php echo $row['generic_name']; ?></td>
                            <td><?php echo $row['brand']; ?></td>
                            <td><?php echo $total_qty; ?></td>
                            <td><?php echo $row['rate']; ?></td>
                            <td class="text-right"><?php echo number_format((float)$total, 2, '.', ''); ?></td>
                        </tr>
                    <?php } ?>
                    <tr>
                        <td colspan="8"></td>
                        <td class="text-right"><?php echo number_format((float)$totalValue, 2, '.', ''); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
        <htmlpagefooter name="myfooter">
            <div style="text-align:center; width:100%; font-size:10px">
                <?= Yii::app()->user->footer_autogenerated; ?>
                <?php
                date_default_timezone_set("Asia/Dubai");
                echo date('d/m/Y') . " " . date("h:i:sa");
                ?>
            </div>
            <div style="border-top: 1px dotted #000000; font-size:12px; text-align:center; padding-top:10px; background-color:#d7faeb;">
                <div style="text-align:center; width:100%;">
                    <b><?= Yii::app()->user->footer_line_1; ?></b><br>
                    <?= Yii::app()->user->footer_line_2; ?>
                </div>
                <div style="text-align:center; width:100%;">Page {PAGENO} of {nb}</div>
            </div>
        </htmlpagefooter>
    </div>
</body>
</html>
