<script>
    $(document).ready(function () {
    var table_id = "#tbl_quotation_price_list";
    var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
    data.display_type = $("#display_type").val();
    data.country_id = $("#country_id").val();
    data.destination_country_id = $("#destination_country_id").val();
    data.agent = $("#agent").val();
    data.transport_type = $("#transport_type").val();
    return data;
    }).DataTable({
    scrollY: "645px",
            pageLength: 50,
            processing: true,
            ajax: {
            url: "<?php echo Yii::app()->createUrl('quotationpricelist/GetList') ?>",
                    type: "POST",
                    cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
            $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
            AddContextMenu(nRow, aData);
            if(aData[8].type=='E'){
                    $("td", nRow).css("background-color", "#aaedc6"); //export
            }
            if(aData[8].type=='I'){
                $("td", nRow).css("background-color", "#FEFCBC"); //import
            }
            if (aData[8].status == "N")  {
            $("td", nRow).addClass("bg-danger");
            }
            }
    });
    });
    function AddContextMenu(row, datas) {
        var mas_edit=0;
        var mas_disable=0;
        <?php if (isset(Yii::app()->user->havePermissionOn['quotation_price_edit']) || Yii::app()->user->authorised_user == 1) { ?>
            var mas_edit=1;
        <?php } ?>
        <?php if (isset(Yii::app()->user->havePermissionOn['quotation_price_disable']) || Yii::app()->user->authorised_user == 1) { ?>
            var mas_disable=1;
        <?php } ?> 
      
        $(row).contextMenu({
        selector: 'td',
            items: {
            "edit": {

                name: "Edit",
                        icon: "edit",
                        accesskey: "e",
                        callback: function () {
                        loadPopupModal("quotationpricelist/create&id=" + datas[8].id, datas[8].code, "lg");
                        }, 
                    disabled: function(key, opt) { 
                        // this references the trigger element
                        if(mas_edit=='0'){
                            return !this.data('editDisabled'); 
                        }
                    }
                },
                "Disable_Enable":{
                        name: (datas[8].status == "Y") ?"Disable" : "Enable",
                                icon: "edit",
                                accesskey: "d",
                                callback: function () {
                                Disable(datas[8].id, datas[8].status);
                                },
                    disabled: function(key, opt) { 
                            // this references the trigger element
                            if(mas_disable=='0'){
                                return !this.data('Disable_EnableDisabled'); 
                            }
                    }
                }

            }
    });
    }
</script>
<script>
    function Disable(id, status){
    var r = confirm((status == "Y") ? 'Are you sure to disable this?' : 'Are you sure to enable this?');
    if (r == true)
    {
    jQuery.ajax({
    'type'  : 'post',
            'datatype' :'json',
            'data'  : 'id=' + id + "&status=" + status,
            'url'  : $('#liveSite').val() + 'index.php?r=quotationpricelist/Disable',
            'cache': false,
            'success':function(data){
            if (data.status == 'fail'){
            t8.error('Error while Delete');
            } else {
            $('#tbl_quotation_price_list').DataTable().ajax.reload()
                    t8.success(' Success!');
            }
            }
    });
    }


    }
</script>
<section class="panel" style="background-color:#F6F3EE;">
    <div class="panel-heading clearfix panel-theame">
        <div class="top_controls_select"> 
            <div class="col-sm-2" style="margin-left:-20px;">
                <i class="fa fa-money"></i> Price List
            </div>
            <div class="pull-right">
           
           
            <div class="col-sm-2">
                 <?php echo CHtml::dropdownlist('agent', '', array( "UPS1" => "UPS1", "UPS2" =>"UPS2", "FEDEX" =>"FEDEX", "DHL" =>"DHL"), array('class' => 'form-control','prompt' => '--All Agents--', 'onchange' => 'reloadTable("#tbl_quotation_price_list")')); ?>
            </div>
           <div class="col-sm-2">
                <?php echo CHtml::dropdownlist('country_id', '',   MasCountry::getCountryName(), array('class' => 'form-control','prompt' => '--Origin--', 'data-search'=>'true','onchange' => 'reloadTable("#tbl_quotation_price_list")')); ?>
            </div> 
            <div class="col-sm-2">
                <?php echo CHtml::dropdownlist('destination_country_id', '',   MasCountry::getCountryName(), array('class' => 'form-control','prompt' => '-Destination-','data-search'=>'true', 'onchange' => 'reloadTable("#tbl_quotation_price_list")')); ?>
            </div>
            <div class="col-sm-2">
                <?php echo CHtml::dropdownlist('transport_type', '', array( "E" => "Export", "I" =>"Import"), array('class' => 'form-control','prompt' => '--All Type--', 'onchange' => 'reloadTable("#tbl_quotation_price_list")')); ?>
           
            </div>
            <div class="col-sm-2">
            <button class="btn btn-sm btn-theme" onclick="loadPopupModal('quotationpricelist/uploadIndex','Upload  Price List','lg')"><i class="fa fa-upload"></i> Upload</button>
            </div>
           
               
            <div class="col-sm-2">
                 <?php if (isset(Yii::app()->user->havePermissionOn['quotation_price_add']) || Yii::app()->user->authorised_user == 1) { ?>

               <button class="btn btn-sm btn-theme" onclick="loadPopupModal('quotationpricelist/create', 'Add New Price List', 'lg')"><i class="fa fa-plus"></i> ADD</button>

            <?php } ?>
            </div>
            </div>
        </div>
    </div>
    <!--<header class="panel-heading clearfix panel-theame">-->
    <!--    <i class="fa fa-money"></i> Quotation Price List    -->
    <!--    <div class="pull-right">-->
    <!--        <//?php if (isset(Yii::app()->user->havePermissionOn['master_country_add']) || Yii::app()->user->authorised_user == 1) { ?>-->

    <!--            <button class="btn btn-sm btn-theme" onclick="loadPopupModal('quotationpricelist/create', 'Add New Quotation Price', 'lg')"><i class="fa fa-plus"></i> ADD</button>-->

    <!--        <//?php } ?></div>-->

    <!--</header>-->
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_quotation_price_list" style="font-size:13px;">
                <thead>
                    <tr>
                       <th>SI No</th>
                        <th>Agent</th>
                        <th>Origin</th>
                        <th>Destination</th>
                        <th>Weight</th>
                        <th>Price</th>
                        <th>Type</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                    <th>SI No</th>
                        <th>Agent</th>
                        <th>Origin</th>
                        <th>Destination</th>
                        <th>Weight</th>
                        <th>Price</th>
                        <th>Type</th>
                    </tr>
                </tfoot>
            </table>
        </div>
        <div class="color-indicator">
                 <span style="display: inline-block;width:30px;height:30px;background:#aaedc6; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> Export</span>
                <span style="display: inline-block;width:30px;height:30px;background:#FEFCBC; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> Import</span>
             </div>
    </div>
</section>
