<!DOCTYPE html>
<html>
    <?php 
        $crm_login_company_id       = Yii::app()->user->master_user_company_id;
        $privillage_modal           = new MasCompanySettings();
        $privillage_condition       = 'crm_company_id='.$crm_login_company_id;
        $privillage_count           = $privillage_modal->count(array('condition'=>$privillage_condition));
        $privillage_settings_module = $privillage_modal->find();
        $master_permission        = $privillage_settings_module->permissions;
        $master_permission_array  = json_decode($master_permission, true);
    ?>

<head>
    <title>Quotes List</title>
</head>

<body>
 
    <div class="">
        <div class="col-6">
            <br>
            <div class="h3" style="margin-top: 0;margin-bottom: 0;">
                <?php 
                $modelName="QuotesItem";
                $criteria = new CDbCriteria();
                $criteria->with = array('parent.file', 'parent');
                $criteria->group = "product_id";
                $criteria->order = "product_id";
                $criteria->addCondition("file.current_process_status = 'Q' OR file.current_process_status = 'O' OR file.current_process_status = 'PD' OR file.current_process_status = 'PI'", 'AND');
                $criteria->select = array('*', 'SUM(quantity) AS item_qty');
                if ($id > 0) {
                    $criteria->addCondition("parent.id=" . $id, 'AND');
                    $modelItems = $modelName::model()->findAll($criteria);
                    $model = new Quotes();
                    $model =$model->findByPk($id);
                    $file_data =  'QUOTATION : ' . $model->file_id . '/' . $id;
                } else {
                    $modelItems = $modelName::model()->findAll($criteria);
                    $file_data = " ALL OPEN QUOTATIONS";
                }?>
                <?php echo 'LIST OF ITEMS TO BE ORDERED FOR '.$file_data; ?>
            </div>
            
                
        </div>
        <div class="col-5 offset-1" style="color:#101010;">
            <div class="text-right">
                <img src="<?php echo 'images/logo/'.Yii::app()->user->pdf_company_logo; ?>" class="logo">
            </div>
            <br>
            
        </div>
    </div>
    <br>
    <div class="col-md-12">
        <table id="" class="table">
            <thead>
                <tr>
                    <tr>
            <th>No.</th>
            <th>Part No.</th>
            <th>Description</th>
            <th>Brand/Class</th>
            <th>Avail.Qty.</th>
            <th>Req.Qty.</th>
            <th>Open.PO.Qty.</th>
            <th>To be Purchased.</th>
        </tr>
                    
            </thead>
            <tbody>
             <?php
              $j = 0;
        foreach ($modelItems as $item) {
            $thisProduct = Store::model()->findByPK($item->product_id);
            $allocatedQuantityForThis = 0;
            
//            if ($id > 0) {
//                $allocond = "product_id=" . $thisProduct->id;
//                $allocond .= " AND file_id=" . $item->parent->file_id;
//                $allocatedQuantityForThis = @AllocatedMaterial::model()->find($allocond)->count;
//            }
            
            //$availableQty = ($thisProduct->total_quantity + floatval($allocatedQuantityForThis)) - $thisProduct->total_allocated_quantity;
            $availableQty = ($thisProduct->total_quantity);
            if ($availableQty < $item->item_qty) {
                //$qty_to_be_purchased = $item->item_qty - ($availableQty + $thisProduct->po_quantity) > 0 ? $item->item_qty - ($availableQty + $thisProduct->po_quantity) : 0;
                $qty_to_be_purchased = $item->item_qty - $availableQty >0? $item->item_qty - $availableQty :0;
                ?>
                <tr>
                <td><?php echo ++$j; ?></td>
                <td class="cell-left"><?php echo $thisProduct->part_number; ?></td>
                <td class="cell-left"><?php echo $thisProduct->description; ?></td>
                <td class="cell-left"><?php echo  $thisProduct->brand_detail->brand; ?></td>
                <td class="cell-right"><?php echo  Yii::app()->numberFormatter->formatDecimal($availableQty); ?></td>
                <td class="cell-right"><?php echo  Yii::app()->numberFormatter->formatDecimal($item->item_qty); ?></td>
                <td class="cell-right"><?php //echo  Yii::app()->numberFormatter->formatDecimal($thisProduct->po_quantity); ?></td>  ,
                <td class="cell-right"><?php echo  Yii::app()->numberFormatter->formatDecimal($qty_to_be_purchased); ?></td>
            </tr>
           <?php
            }
        }
        ?>
                   
            </tbody>
        </table>
       
    </div>
    
    <br/>
    <br/>
    <div style="text-align:center;width:100%;font-size:10px">This report is auto generated by Bluesky ERP on
        <?php
                  date_default_timezone_set("Asia/Dubai");
                 echo date('d/m/Y')." ".date("h:i:sa"); ?>
    </div>
   
    <htmlpagefooter name="myfooter">
        <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; ">
            <div style="text-align:center;width:100%">
                <b><?php echo Yii::app()->user->master_company_name; ?></b>
                <br/>
                <?php echo $model_Company->company_address; ?>
                <?php echo '  '.$model_Company->company_location; ?>
                <?php echo ' '.$model_Company->country->country_name; ?>
                <?php echo 'Phone : '.Yii::app()->user->company_general_phone_no; ?> ,
                <?php echo 'Email : '.Yii::app()->user->company_general_email; ?>
            </div>
            <div style="text-align:center;width:100%">Page {PAGENO} of {nb} </div>
        </div>
    </htmlpagefooter>
</body>

</html>
