<!DOCTYPE html>
<html>

    <head>
        <title>Gross Profit</title>
    </head>

    <body>

        <div class="heading">
            <div class="logo col-6">
                <img src="<?php echo Yii::app()->baseUrl . '/images/logo/' . Yii::app()->user->pdf_company_logo; ?>" class="logo">
            </div>

        </div>
        <div class="clearfix"></div>
        <div class="title">
            <div class="col-6">
                <div style="height: 10px;"></div>
            </div>
            <div class="col-6 text-right">
                <h1>Gross Profit</h1>
                <div class="pull-right">
                    <div class="filter_details">

                        <?php
                        if ($from_date != '') {
                            ?>
                            <div class="filter-item">
                                <label>Gross Profit From : </label>
                                <?php echo $from_date ?>
                            </div>
                            <?php
                        }
                        ?>
                        <?php
                        if ($to_date != '') {
                            ?>
                            <div class="filter-item">
                                <label>Gross Profit To : </label>
                                <?php echo $to_date ?>
                            </div>
                            <?php
                        }
                        ?>
                        <?php
                        if ($customer_id != '') {
                            ?>
                            <div class="filter-item">
                                <label>Customer :</label>
                                <?php
                                $c = Customer::model()->findByPK($customer_id);
                                echo $c->customer_name;
                                ?>
                            </div>
                            <?php
                        }
                        ?>

                    </div>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
        <div class="table-body">
            <table id="tbl_enquiry_table" class="table">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Invoice No</th>
                        <th>Invoice Date</th>
                        <th>Customer Name</th>
                        <th>Currency</th>
                        <th>Invoice Value</th>
                        <th>Value(BC)</th>
                        <th>Cost</th>                        
                        <th>Profit</th>
                        <th>Profit (%)</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $condition = " WHERE 1=1";
                    if ($from_date != '') {
                        $from_date = str_replace('/', '-', $from_date);
                        $from_date = date('Y-m-d', strtotime($from_date));
                        $condition .= ' AND invoice_date >="' . $from_date . '"';
                    }
                    if ($to_date != '') {
                        $to_date = str_replace('/', '-', $to_date);
                        $to_date = date('Y-m-d', strtotime($to_date));
                        $condition .= ' AND invoice_date <="' . $to_date . '"';
                    }

                    if ($customer_id != '') {

                        $condition .= ' AND customer.id  ="' . $customer_id . '"';

                        //var_dump($condition );
                        //die;
                    }

                    if ($leadowner_id != '') {
                        $condition .= ' AND lead_owner_id ="' . $leadowner_id . '"';
                    }

                    if ($sales_group != '') {

                        $condition .= ' AND sales_group ="' . $sales_group . '"';

                        //var_dump($condition );
                        //die;
                    }

                    if ($inv_type != '') {

                        $condition .= ' AND invoice_type ="' . $inv_type . '"';

                        //var_dump($condition );
                        //die;
                    }

                    $SQL = 'SELECT invoice.id AS invoice_ref_no,invoice_date,invoice.lead_owner_id AS lead_owner_id,CONCAT(first_name," ",last_name) AS lead_owner_name,sales_group,delivery_ids,grand_total AS invoice_value,(grand_total*invoice.exchange_rate) AS invoice_value_bc,invoice_no,customer_name,crm_mas_currency.currency AS currency_name,currency_code,invoice.exchange_rate,invoice_type,sg.group_name AS sales_group_name,(SELECT SUM(cost_rate) FROM crm_stock_ledger WHERE master_table_id=invoice.delivery_ids GROUP BY delivery_ids) AS total_cost_rate FROM crm_invoice AS invoice INNER JOIN crm_customer AS customer ON invoice.company_id =customer.id 
                    LEFT JOIN crm_mas_currency  ON invoice.currency=crm_mas_currency.id 
                    LEFT JOIN crm_mas_sales_group AS sg ON invoice.sales_group=sg.id 
                    LEFT JOIN cumuluse_erp_norden_main.crm_user AS users ON invoice.lead_owner_id=users.id ' . $condition;



                    $arr_gross_profit_details = Yii::app()->db->createCommand($SQL)->queryAll();

                    //$total=0;
                    //$model_invoice = Grossprofit::model()->findAll(array('condition'=>$condition,'order'=>'t.invoice_ref_no DESC'));
                    //$model_invoice = Grossprofit::model()->findAll(array('condition'=>$condition));
                    $profit = "";

                    foreach ($arr_gross_profit_details as $i => $gross_profit_details) {


                        $total_cost_rate = $gross_profit_details['total_cost_rate'];
                        $invoice_value_bc = $gross_profit_details['invoice_value_bc'];
                        $profit_value = ($invoice_value_bc - $total_cost_rate);
                        $profit+= $profit_value;

                        $profit_in_percentage = (($invoice_value_bc) > 0) ? round(($profit_value / $invoice_value_bc) * 100, 2) : 0;
                        ?>
                        <tr>
                            <td>
                                <?php echo $i + 1; ?>
                            </td>
                            <td>
                                <?php echo $gross_profit_details['invoice_no']; ?>
                            </td>



                            <?php
                            $date = $gross_profit_details['invoice_date'];
                            if ($date != '0000-00-00') {
                                $newdate = date("d/m/Y", strtotime($date));
                                ?>
                                <td>
                                    <?= $newdate; ?>
                                </td>
                            <?php } else { ?>
                                <td></td>
                            <?php } ?>
                            <td class="text-left"> 
                                <?php echo $gross_profit_details['customer_name']; ?>
                            </td>
                            <td >
                                <?php echo $gross_profit_details['currency_name']; ?>
                            </td>

                            <td class="text-right"> <?php echo Yii::app()->numberFormatter->formatCurrency($gross_profit_details['invoice_value'], ""); ?>

                            </td>

                            <td class="text-right"> <?php echo Yii::app()->numberFormatter->formatCurrency($gross_profit_details['invoice_value_bc'], ""); ?>

                            </td>

                            <td class="text-right"> 
                                <?php
                                if (!empty($actual_cost)) {
                                    $cost = $actual_cost;
                                } else {
                                    $cost = "0";
                                }


                                echo $cost;
                                ?>
                            </td>

                            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($profit_value, ""); ?>  </td>

                            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($profit_in_percentage, ""); ?>  </td>

                        </tr>


                    <?php }
                    ?>
                    <tr>
                        <td colspan="8"> </td>
                        <td class="text-right"><b> <?php echo $profit; ?></b> </td>
                        <td colspan="1"> </td>
                    </tr>
                </tbody>
            </table>
            <label>
                <?php echo $SQL; ?>
            </label>
        </div>

        <!--        <div style="text-align:center;width:100%;font-size:10px">This report is auto generated by Bluesky ERP on
        <?php
// date_default_timezone_set("Asia/Dubai");
// echo date('d/m/Y')." ".date("h:i:sa"); 
        ?>
            </div>-->
    <htmlpagefooter name="myfooter">

        <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; ">
            <div style="binvoice-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; ">
                <div style="text-align:center;width:100%">This report is auto generated by Bluesky ERP on
                    <?php
                    date_default_timezone_set("Asia/Dubai");
                    echo date('d/m/Y') . " " . date("h:i:sa");
                    ?>
                    <?php /*
                      $model_Company = MasCompany::model()->find(); ?>
                      <b><?php echo $model_Company->company_name; ?></b>
                      <br/>
                      <?php
                      echo $model_Company->billing_address; ?>
                      <?php echo '  '.$model_Company->billing_city; ?>
                      <?php// echo ' '.$model_Company->country->country_name; ?>
                      <?php echo 'Phone : '.$model_Company->genral_phno ; ?> ,
                      <?php echo 'Email : '.$model_Company->genral_email; */ ?>
                </div>
                <div style="text-align:center;width:100%">Page {PAGENO} of {nb} </div>
            </div></div>
    </htmlpagefooter>
    <sethtmlpagefooter name="myfooter" page="all" value="on" />
</body>

</html>
