<!DOCTYPE>
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Invoice Report</title>
    <style type="text/css">
    .header-1 {
        width: 100%;
    }

    .logo1,
    .right-text {
        width: 20%;
        float: left;
        font-size: 13px;
    }

    .title-add {
        width: 60%;
        float: left;
        text-align: center;
    }

    .table-gst {
        border-collapse: collapse;
        font-size: 12px;
        width: 100%;
    }

    .table-gst th,
    .table-gst td {
        border: 1px solid #000;
        padding: 5px;
        vertical-align: top;
    }

    .table-gst th {
        background: #bdd7ee;
    }
    </style>
</head>
<?php $modelMasCompany = MasCompany::model()->findByPk(Yii::app()->user->master_user_company_id); ?>
<body>
    <div class="header-1">
        <div class="logo1">
            <br>
            
            <?php echo CHtml::image(Yii::app()->baseUrl . '/images/logo/'.Yii::app()->user->pdf_company_logo); ?>
        </div>
        <div class="title-add">
            <h4 style="margin: 0"><?php echo Yii::app()->user->master_company_name;?></h4>
            <h5 style="margin: 0">
                <?php echo MasCompany::getBillingAddress();?>
                <?php 
               	if(!empty($modelMasCompany->genral_phno)){
               		echo '<br>';
                	echo 'Telephone No: <b>'.$modelMasCompany->genral_phno.'</b>';
                } 
                ?>
                <!-- br>GSTIN: <?php //echo $modelMasCompany->general_gstin_no;?>
                <br>CIN: <?php //echo $modelMasCompany->general_cin_no;?> -->
            </h5>
        </div>
        <div class="right-text">
            <br>
            <br> <!-- Original for Receipient -->
        </div>
    </div>
    <br>
    <table class="table-gst">
        <tbody>
            <tr>
                <th colspan="6">
                    <h3 style="margin: 0">Tax Invoice</h3></th>
            </tr>
            <tr>
                <td colspan="3" width="50%">Invoice No: <b><?php echo $model->id;?></b></td>
                <td colspan="3" width="50%">Transport Mode:</td>
            </tr>
            <tr>
                <td colspan="3" width="50%">Invoice Date: <b><?php echo $model->invoice_date;?></b></td>
                <td colspan="3" width="50%">Vehicle Number:</td>
            </tr>
            <tr>
                <td colspan="2" width="40%">Reverse Charge (Y/N): </td>
                <td width="10%"></td>
                <td colspan="3" width="50%">Date of Supply:</td>
            </tr>
            <tr>
                <td width="30%">State: <b><?php echo $model->company->billingState->state_province;?></b></td>
                <td width="10%"></td>
                <td width="10%"></td>
                <td colspan="3" width="50%">Place of Supply:</td>
            </tr>
            <tr>
                <td colspan="6">&nbsp;</td>
            </tr>
            <tr>
                <th colspan="3" width="50%" class="text-center">Bill to Party</th>
                <th colspan="3" width="50%" class="text-center">Ship to Party</th>
            </tr>
            <tr>
                <td colspan="3" width="50%">Name: <b><?php echo $model->customer->customer_name; ?></b></td>
                <td colspan="3" width="50%">Name: <b><?php echo $model->customer->customer_name; ?></b></td>
            </tr>
            <tr>
                <td colspan="3" width="50%">Address: <b><?php echo $model->customer->customer_address; ?></b></td>
                <td colspan="3" width="50%">Address: <b><?php echo $model->customer->customer_shipping_address; ?></b></td>
            </tr>
            <tr>
                <td colspan="3" width="50%">GSTIN: <b><?php //echo $model->customer->customer_tin_no;?></b></td>
                <td colspan="3" width="50%">GSTIN: <b><?php //echo $model->customer->customer_tin_no;?></b></td>
            </tr>
            <tr>
                <td width="30%">State: <b><?php echo $model->customer->customer_state;?></b></td>
                <td width="10%">Code: </td>
                <td width="10%"><b><?php echo $model->customer->customer_postal_code;?></b></td>
                <td width="30%">State: <b><?php echo $model->customer->customer_shipping_state;?></b></td>
                <td width="10%">Code: </td>
                <td width="10%"><b><?php echo $model->customer->customer_shipping_postal_code 	;?></b></td>
            </tr>
        </tbody>
    </table>
    <table class="table-gst">
        <thead>
            <tr>
                <th rowspan="2">No</th>
                <th rowspan="2">Product Desc</th>
                <th rowspan="2">HSNC</th>
                <th rowspan="2">UOM</th>
                <th rowspan="2">Qty</th>
                <th rowspan="2">Rate</th>
                <th rowspan="2">Amount</th>
                <th rowspan="2">Dis.</th>
                <th rowspan="2">Taxable</th>
                <th colspan="4">VAT</th>
                <th rowspan="2">Total</th>
            </tr>
            <tr>
                <th colspan="1">Rate</th>
                <th colspan="1">Amount</th>
                
            </tr>
        </thead>
        <tbody>
            <?php foreach($model->items as $i=>$inv_items){ ?>
            <tr>
                <td><?php echo $i+1; ?></td>
                <td><?php echo $inv_items->product->description; ?></td>
                <td><?php echo $inv_items->product->inventory->hsir_code; ?></td>
                <td><?php echo $inv_items->product->unit->symbol;?></td>
                <td><?php echo $inv_items->quantity; ?></td>
                <td class="text-right" ><?php echo  Yii::app()->numberFormatter->formatCurrency($inv_items->rate, ""); ?></td>
                <td class="text-right" ><?php echo  Yii::app()->numberFormatter->formatCurrency($inv_items->amount, ""); ?></td>
                <td><?php echo ''; ?></td>
                <td><?php echo ''; ?></td>
                
                <td class="text-right" ><?php echo  Yii::app()->numberFormatter->formatCurrency($inv_items->tax_vat_percentage, "");?>%</td>
                <td colspan="3" class="text-right" ><?php echo Yii::app()->numberFormatter->formatCurrency($inv_items->tax_vat_amount, "");?></td>
                <td class="text-right" ><?php echo Yii::app()->numberFormatter->formatCurrency($inv_items->net_amount, ""); ?></td>
                
            </tr>
            <?php 
            $total_amount+=$inv_items->net_amount;
                } ?>
            
            <?php
            		$grand_total=$total_amount;
            		
            		
            		
            		foreach ($model->adItems as $i => $eachItem) {
            			if (($eachItem->calculated_value) > 0) {
            				?>
            		                        <tr>
							                <td colspan="9"></td>
							                <td colspan="2"><b>
							                <?php 
							                if(isset($eachItem->particular) && $eachItem->particular!="" && $eachItem->account->description!="")
							                {
							                	echo $eachItem->account->description;
							                }
							                else
							                {
							                	echo "Additions";
							                }
							                ?>
							                </b></td>
							                <td  class="text-right" ><b><?php echo Yii::app()->numberFormatter->formatCurrency($eachItem->calculated_value,"");?></b></td>
							            	</tr>
            		                            	<?php
            		
            		                            	$grand_total+=$eachItem->calculated_value;
            		                            }
            		            		}
            		            		
            		            		
            		            		foreach ($model->dedItems as $i => $eachItem) {
            		            			if (($eachItem->calculated_value) > 0) {
            		            				?>
            		            		            				<tr>
            		            					                <td colspan="9"></td>
            		            					                <td colspan="4"><b>
            		            					                <?php 
            		            					                if(isset($eachItem->particular) && $eachItem->particular!="" && $eachItem->account->description!="")
													                {
													                	echo $eachItem->account->description;
													                }
													                else
													                {
													                	echo "Additions";
													                }?>
													                </b></td>
            		            					                <td  class="text-right" ><b><?php echo Yii::app()->numberFormatter->formatCurrency($eachItem->calculated_value,"");?></b></td>
            		            					            	</tr>
            		            		            		        <?php
            		            		            		        $grand_total-=$eachItem->calculated_value;
            		            		            		     }
            		            		            		}
            		            		            		
            		
                            ?>
                            
                            
                            <tr>
                <th colspan="9" class="text-center"> <?php echo ucfirst($this->widget('ext.NumtoWord.NumtoWord', array('num' => $model->grand_total))->result) . ' only';?></th>
                <td colspan="4">Total Amount before Tax</td>
                <td  class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($grand_total, "");?></b></td>
            </tr>
            <?php 
            $total_tax_amount =0;
			 ?>
            <tr>
                <td colspan="9"></td>
                <td colspan="4">Add CGST</td>
                <td  class="text-right" ><b><?php echo Yii::app()->numberFormatter->formatCurrency($model->total_tax_amount,"");?></b></td>
            </tr>
            <?php 
            $total_tax_amount+=$model->total_tax_amount;
            ?>
            
            <?php 
            
            $grand_total+=$total_tax_amount;
            ?>
            
            <tr>
                 <td colspan="9"></td>
                <td colspan="4">Total Tax Amount</td>
                <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_tax_amount,"");?></b></td>
            </tr>
            <tr>
            	 <td colspan="9"></td>
                <td colspan="4">Total Amount after Tax: </td>
                <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($grand_total,"");?></b></td>
            </tr>
            <?php 
            $bank = OwnerBankDetails::model()->find(array('condition' => 'currency_id=' . $model->currency));
            ?>
            <tr>
                <th colspan="6">Bank Details</th>
                <td colspan="3" rowspan="4"></td>
                <th colspan="4">GST on Reverse Charge</th>
                <td class="text-right"><b>0.00</b></td>
            </tr>
            <tr>
                <td colspan="6">Bank A/C: <b><?php echo $bank->bank_account_name;?></b></td>
                <td colspan="5">
                    <small>Ceritified that the particulars given above are true and correct</small>
                </td>
            </tr>
            <tr>
                <td colspan="6">Bank IFSC: <b><?php echo $bank->bank_ifsc;?></b></td>
                <td colspan="5" class="text-center">
                    For <?php echo Yii::app()->user->master_company_name;?>
                </td>
            </tr>
            <tr>
                <td colspan="6" rowspan="2">Terms & conditions</td>
                <td colspan="5" class="text-center">
                    <br>
                    <br>
                    <br>
                    <br>
                    <br>
                </td>
            </tr>
            <tr>
                <td colspan="3" class="text-center">Common Seal</td>
                <td colspan="5" class="text-center">Authorised Signatory</td>
            </tr>
        </tbody>
    </table>
    <div class="clearfix"></div>
</body>

</html>
                            
            
            <tr>
                <th colspan="12" class="text-center"> <?php echo ucfirst($this->widget('ext.NumtoWord.NumtoWord', array('num' => $model->grand_total))->result) . ' only';?></th>
                <td colspan="3">Total Amount before Tax</td>
                <td  class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($grand_total, "");?></b></td>
            </tr>
            <?php 
            $total_tax_amount =0;
            ?>
            <tr>
                <td colspan="3" rowspan="4">Add VAT</td>
                <td  class="text-right" ><b><?php echo Yii::app()->numberFormatter->formatCurrency($model->total_tax_amount,"");?></b></td>
            </tr>
            <?php 
            	$total_tax_amount=$model->total_tax_amount;
            
            $grand_total+=$total_tax_amount;
            ?>
            
            <tr>
                <td colspan="4">Total Tax Amount</td>
                <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_tax_amount,"");?></b></td>
            </tr>
            <tr>
                <td colspan="4">Total Amount after Tax: </td>
                <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($grand_total,"");?></b></td>
            </tr>
            <?php 
            $bank = OwnerBankDetails::model()->find(array('condition' => 'currency_id=' . $model->currency));
            ?>
            <tr>
                <th colspan="6">Bank Details</th>
                <td colspan="3" rowspan="4"></td>
                <th colspan="4">GST on Reverse Charge</th>
                <td class="text-right"><b>0.00</b></td>
            </tr>
            <tr>
                <td colspan="6">Bank A/C: <b><?php echo $bank->bank_account_name;?></b></td>
                <td colspan="5">
                    <small>Ceritified that the particulars given above are true and correct</small>
                </td>
            </tr>
            <tr>
                <td colspan="6">Bank IFSC: <b><?php echo $bank->bank_ifsc;?></b></td>
                <td colspan="5" class="text-center">
                    For <?php echo Yii::app()->user->master_company_name;?>
                </td>
            </tr>
            <tr>
                <td colspan="6" rowspan="2">Terms & conditions</td>
                <td colspan="5" class="text-center">
                    <br>
                    <br>
                    <br>
                    <br>
                    <br>
                </td>
            </tr>
            <tr>
                <td colspan="3" class="text-center">Common Seal</td>
                <td colspan="5" class="text-center">Authorised Signatory</td>
            </tr>
        </tbody>
    </table>
    <div class="clearfix"></div>
</body>

</html>