<div class="tab-content">
    <div class="tab-pane active" id="masterunit_sec">
        <section class="panel" style="background-color:#F6F3EE;">
            <header class="panel-heading clearfix panel-theame">
                <i class="fa fa-users"></i> Master Unit
                 <?php if ((isset(Yii::app()->user->havePermissionOn['mas_inv_unit_add']) || Yii::app()->user->authorised_user == 1)) { ?>
                <div class="pull-right">
                    <button class="btn btn-sm btn-theme" onclick="loadPopupModal('masunit/create', 'New Master Unit', 'lg')"><i class="fa fa-plus"></i> ADD</button>
                </div>
                <?php } ?>
                </header>  
            <div class="panel-body">
                <div class="custom-data-table">
                    <table class="table table-hover table-bordered personal-task" id="tbl_masterunit" style="font-size:13px;">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Unit</th>
                                <th>Label</th>
                                <th>BaseUnit</th>
                                <th>Factor</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </section>
    </div>
</div>
<script>
    $(document).ready(function () {
        var table_details_id = "#tbl_masterunit";
        table_details = $(table_details_id).on("preXhr.dt", function (e, settings, data) {
        data.outlet = $("#unit_outlet").val();
        return data;
    }).DataTable({
            scrollY: "550px",
            "bAutoWidth": true,
            pageLength: 50,
            ajax: {
                url: "index.php?r=masunit/getlist",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            order: [[1, "asc"]],
            aoColumnDefs: [
              { "bSortable": false, "aTargets": [5] },
              {
                 "targets": [6,7],
                 "visible": false,
              },
            ],
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {

                if (aData[6] == "N") {
                    $("td", nRow).addClass("bg-danger");
                }
                if (aData[7] == "Y") {
                    $("td", nRow).addClass("bg-success");
                }
            }
        });
        $(".dataTables_scrollFoot").hide();

    });
</script>