<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("CheckBaseUnit", "function CheckBaseUnit(val){
if(val=='N')
{
$('#base_unit').show();        
}
else {
$('#base_unit').hide();
}
}", CClientScript::POS_HEAD);
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'masunit-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
    ));
    $readonly=false;
    if($model->id>0){
        $mod_stockledger = StockLedger::model()->findAll(array('condition'=>'unit='.$model->id));
        if(!empty($mod_stockledger)){
            $readonly=true;
        }
    }
?>

    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'unit_name', array('data-label' => 'Name <span style="color:red;">*</span>')); ?>
                <?php echo $form->hiddenField($model, 'id'); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'label',array('data-label' => 'Label <span style="color:red;">*</span>')); ?>
            </li>
            <li class="col-sm-4">
                <?php 
                if($readonly==true){
                    $value= ($model->base_unit=="Y")?'YES':'No';
                    echo CHtml::textfield('base_unit',$value,array('data-label' => 'Is Base Unit <span style="color:red;">*</span>','readonly'=>true));
                    echo $form->hiddenField($model, 'base_unit'); 
                }
                else
                echo $form->dropDownList($model, 'base_unit', array('Y'=>'Yes','N'=>'No'),array('data-label' => 'Is Base Unit <span style="color:red;">*</span>',"onchange"=>"CheckBaseUnit(this.value)")); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->dropDownList($model, 'is_default', array('Y'=>'Yes','N'=>'No'),array('data-label' => 'Is Default <span style="color:red;">*</span>')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->dropDownList($model, 'active',array('Y'=>'Yes','N'=>'No'), array('data-label' => 'Is Active <span style="color:red;">*</span>')); ?>
            </li>
        </ul>
        <ul class="clearfix form-ul material" id="base_unit" style="display:<?=$model->base_unit=='N'?'block':'none'?>">
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'unit_exchange_rate', array('data-label' => 'Conversion Factor <span style="color:red;">*</span>','onkeypress' => 'return isNumberKey(event);','readonly'=>$readonly)); ?>
            </li>
            <li class="col-sm-4">
                <?php 
                if($readonly==true){
                    $base=$model->BaseUnit;
                    echo CHtml::textfield('base_unit',$base,array('data-label' => 'Base Unit <span style="color:red;">*</span>','readonly'=>true));
                    echo $form->hiddenField($model, 'base_unit_id'); 
                }
                else
                echo $form->dropDownList($model, 'base_unit_id',MasUnit::getAllBaseUnits($model->id),array('data-label' => 'Base Unit <span style="color:red;">*</span>')); ?>
            </li>
        </ul>
    </div>
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-default" id="unit_close" data-dismiss="modal">Close</button>
    <?php 
                $url = Yii::app()->createUrl('masunit/Save');
                echo CHtml::ajaxSubmitButton('Save', $url, array(
                            'dataType' => 'json',
                            'type' => 'post',
                            'success' => 'function(data) {
                                if(data.status=="success"){  
                                    $("#unit_close").click();                                        
                                    t8.success("Unit Details Saved Successfully!");
                                    reloadTable("#tbl_masterunit");
                                } else { 
                                    $("#masunit-form .masunit-save-btn").prop("disabled", false);
                                    $("#masunit-form .masunit-save-btn").addClass("btn-theme").removeClass("btn_loading");
                                    $.each(data, function(key, val) {
                                        $("#masunit-form #"+key+"_em_").text(val).show(); 
                                        t8.error(""+val+""); 
                                    }); 
                                } 
                            }',
                            'beforeSend' => 'function(){
                                $(".toast8-error").hide(); 
                                $("#loader").show();
                                $("#masunit-form .masunit-save-btn").prop("disabled", true);                                
                                $("#masunit-form .masunit-save-btn").addClass("btn_loading").removeClass("btn-theme");
                                
                            }',
                            'complete' => 'function(){
                                $("#loader").hide();
                                $("#masunit-form .masunit-save-btn").prop("disabled", false);                                
                                $("#masunit-form .masunit-save-btn").addClass("btn-theme").removeClass("btn_loading");
                            }'
                                
                    ), array('id' => 'mybtn' . rand(), 'class' => 'masunit-save-btn btn btn-theme'));
           
    ?>
</div>
<?php $this->endWidget(); ?>
