<?php
$this->pageTitle = '404 Not Found';
?>

<style>
    body {
        margin: 0;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background: #f4f6f8;
        color: #333;
        display: flex;
        justify-content: center;
        align-items: center;
        height: 100vh;
    }

    .error-container {
        text-align: center;
        padding: 40px;
        background: white;
        border-radius: 10px;
        box-shadow: 0 5px 30px rgba(0, 0, 0, 0.1);
        max-width: 500px;
        width: 90%;
    }

    .error-code {
        font-size: 96px;
        font-weight: bold;
        color: #e74c3c;
    }

    .error-message {
        font-size: 24px;
        margin: 20px 0;
    }

    .error-description {
        font-size: 16px;
        color: #777;
        margin-bottom: 30px;
    }

    .back-button {
        display: inline-block;
        text-decoration: none;
        color: white;
        background: #3498db;
        padding: 12px 24px;
        border-radius: 6px;
        font-weight: bold;
        transition: background 0.3s ease;
    }

    .back-button:hover {
        background: #2980b9;
    }

    @media (max-width: 600px) {
        .error-code {
            font-size: 72px;
        }
        .error-message {
            font-size: 20px;
        }
    }
</style>

<div class="error-container">
    <div class="error-code">404</div>
    <div class="error-message">Oops! Page not found.</div>
    <div class="error-description">
        The page you're looking for might have been removed, had its name changed, or is temporarily unavailable.
    </div>
    <a href="<?php echo Yii::app()->homeUrl; ?>" class="back-button">Go to Homepage</a>
</div>
