
<section>
    <div class="panel-body">
        <div class="table-responsive">
            <table id="tbl_invoice_table" class="table table-fixed table-bordered table-primary dataTable" style="font-size:12px;">
                <thead>
                    <tr>
                        <th class="text-center">
                            Salesman
                        </th>
                        <th class="text-center">
                            Target (Yearly)
                        </th>
                        <th class="text-center">
                            Invoice Amount (YTD)
                        </th>
                        <th class="text-center">
                            Provisional Profit
                        </th>
                        <th class="text-center">
                            Variance
                        </th>
                        <th class="text-center">
                            Variance %
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["dashboard_view_all_trend"])) {
                        $condition = " isActive = 'Y' AND is_lead_owner ='Y' ";
                    } else {
                        $condition = "id=" . Yii::app()->user->id;
                    }
                    $userList = User::model()->findAll([
                        "condition" => $condition,
                        'order' => 'first_name asc']);
                    $year = date("Y");
                    foreach ($userList as $key => $user) {
//                        $SQL = "SELECT SUM(grand_total) AS invoice_amount FROM erp_invoice JOIN erp_job_order ON (erp_invoice.order_id = erp_job_order.id )  where erp_job_order.job_order_status!='CN' AND  erp_job_order.lead_owner_id = " . $user->id . " AND YEAR(job_date ) = '$year' ";
                        $SQL = "SELECT SUM(erp_invoice_item.net_amount + erp_invoice_item.tax_vat_amount) AS invoice_amount FROM erp_invoice JOIN erp_invoice_item ON (erp_invoice_item.invoice_id = erp_invoice.id) JOIN erp_job_order ON (erp_invoice.order_id = erp_job_order.id )  where  erp_job_order.lead_owner_id = " . $user->id . " AND YEAR(job_date ) = '$year' ";

                        //echo $SQL;
                        $invoice_amount = Yii::app()->db->createCommand($SQL)->queryScalar();

                        $SQL_CR = "SELECT SUM(credited_amount * erp_creditnote.exchange_rate) AS credited_amount FROM `erp_creditnote` JOIN erp_invoice ON erp_invoice.id = erp_creditnote.invoice_id  JOIN erp_job_order ON (erp_invoice.order_id = erp_job_order.id )  WHERE erp_job_order.lead_owner_id = " . $user->id . "  AND YEAR(job_date) = '$year' ";

                        //echo $SQL_CR;
                        $credited_amount = Yii::app()->db->createCommand($SQL_CR)->queryScalar();

                        $invoice_amount = $invoice_amount - $credited_amount;

                        $SQL = "SELECT SUM(planned_selling_price) AS total_selling_price, SUM(planned_cost) AS total_planned_cost, SUM(actual_cost) AS total_actual_cost FROM erp_job_order_agent_details JOIN erp_job_order ON( erp_job_order_agent_details.job_order_id = erp_job_order.id )  WHERE job_order_status!='CN' AND `activity_type` != 40 AND erp_job_order.lead_owner_id = $user->id AND YEAR(erp_job_order.job_date) = '$year'; ";
                        $arr_totals = Yii::app()->db->createCommand($SQL)->queryAll();
                        $planned_selling_price = $arr_totals[0]['total_selling_price'];
                        $planned_cost = $arr_totals[0]['total_planned_cost'];
                        $actual_cost = $arr_totals[0]['total_actual_cost'];
                        $planned_profit = $planned_selling_price - $planned_cost;
                        $actual_profit = $invoice_amount - $actual_cost;
                        $varince = $planned_profit - $user->target;
                        // if (empty($user->target)) {
                        //     $varincePer = "0";
                        // } else {
                        //     $varincePer = ($varince * 100) / $user->target;
                        // }
                        if (empty($user->target) || $user->target == 0) {
                            $varincePer = "0";
                        } else {
                            $varincePer = ($varince * 100) / $user->target;
                        }
                        
                        $icon = "";
                        if ($varince > 0) {
                            $spanColor = "style='color:green'";
                            $icon = '&nbsp;<span style="font-size:12px"><i class="fa fa-arrow-up"></i></span>';
                        } else {
                            $spanColor = "style='color:red'";
                            $icon = '&nbsp;<span style="font-size:12px" ><i class="fa fa-arrow-down"></i></span>';
                        }
                        ?>
                        <tr>
                            <td>
                                <?php echo $user->first_name . " " . $user->last_name ?>
                            </td>
                            <td class="text-right">
                                <?php echo number_format((float) $user->target, 2) ?>
                            </td>
                            <td class="text-right">
                                <?php echo number_format((float) $invoice_amount, 2) ?>
                            </td>
                            <td class="text-right">
                                <?php echo number_format((float) $planned_profit, 2) ?>
                            </td>

                            <td class="text-right">
                                <span <?php echo $spanColor ?>>
                                    <?php
                                    echo number_format((float) $varince, 2) . $icon;
                                    ?>

                                </span>
                            </td>
                            <td class="text-right">
                                <?php
                                if (!empty($varincePer)) {
                                    echo number_format((float) $varincePer, 2) . "%";
                                }
                                ?>
                            </td>
                        </tr>
                        <?php
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</section>