

<?php
// Job order
$year = date("Y");
$jo_plot_array = [];
$sql_job_lead_owner = "SELECT MONTH(job_date) m, COUNT(*) AS qty FROM view_job_order_list WHERE job_order_status != 'CN' AND YEAR(job_date) = $year GROUP BY MONTH(job_date) ORDER BY MONTH(job_date); ";
$data_jo_lead_owner = Yii::app()->db->createCommand($sql_job_lead_owner)->queryAll();
foreach ($data_jo_lead_owner as $value) {
    $color = substr(md5(rand()), 0, 6);

    $k = $value["m"];
    $dateObj = DateTime::createFromFormat('!m', $k);
    $monthName = $dateObj->format('F'); // March
    $jo_plot_array[] = ["label" => $monthName,
        "value" => $value["qty"],
        "color" => "#" . $color
    ];
}
$jo_plot = json_encode($jo_plot_array);
?>
<script>
    $(document).ready(function () {
        setTimeout(function () {
            var data = <?php echo $jo_plot ?>;
            var canvas1 = document.getElementById('jo_ownr_1');
            Chart.defaults.global.responsive = true;
            var ctx = canvas1.getContext('2d');
            var pieChart = new Chart(ctx).Pie(data);
        }, 300);
    });

</script>
<div class="clearfix">
    <div class="col-lg-4" data-initial-class="col-lg-4" id="pieChartParent">
        <section class="panel">
            <!--            <header class="panel-heading">
                              Lead- Lead Owner
                        </header>-->
            <div class="panel-body text-center">
                <div class="clearfix canvas-holder" id="jo_container_1">
                    <canvas id="jo_ownr_1" width="400" height="400"></canvas>
                </div>
            </div>
        </section>
    </div>
    <div class="col-lg-8">

        <table class="table table-hover table-bordered personal-task" id="tbl_graph_jo_details">
            <thead>
                <tr>

                    <th>#</th>
                    <th>Month</th>
                    <th>Job Order Count</th>
                </tr>
            </thead>
            <tbody>
                <?php
                foreach ($data_jo_lead_owner as $i => $each) {
                    $k = $each["m"];
                    $dateObj = DateTime::createFromFormat('!m', $k);
                    $monthName = $dateObj->format('F'); // March
                    ?>
                    <tr>

                        <td><?= $i + 1; ?></td>
                        <td class="text-left"><?= $monthName; ?></td>
                        <td class="text-right"><?= number_format((float) $each['qty'], 0); ?></td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
</div>