<?php

class SpaceController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'getlist', 'create', 'save', 'UpdateWorkspace', 'deleteItem', 'shareItem', 'deleteshareItem'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
      
        $this->render('index');
    }

    public function actionCreate() {
        $model = new WorkspaceNote();
        $id = (int) Yii::app()->request->getParam('id');
        $lead_id = (int) Yii::app()->request->getParam('lead_id');
        if ($id > 0) {
            $model = $model->findByPk($id);
            if ($model->due_date != '0000-00-00') {
                $model->due_date = date('d/m/yy', strtotime($model->due_date));
            }
        } else if ($lead_id > 0) {
            $model = $model->find(array('condition' => 't.lead_id = ' . $lead_id));
            if (empty($model)) {
                $lead = Lead::model()->findByPk($lead_id);
                $model = new WorkspaceNote();
                $model->lead_id = $lead_id;
                $model->due_date = date('d/m/yy', strtotime($lead->closing_date));
                $model->title = $lead->file_id . ":" . $lead->customer->customer_name;
                $model->description = $lead->title;
                $model->file_id = $lead->file_id;
            } else {
                if ($model->due_date != '0000-00-00') {
                    $model->due_date = date('d/m/yy', strtotime($model->due_date));
                }
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model), false, false);
    }

    public function actionSave() {
        $model = new WorkspaceNote();
        if (isset($_POST['WorkspaceNote'])) {
            if ((int) @$_POST['WorkspaceNote']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
                $id = (int) @$_POST['WorkspaceNote']['id'];
                $model = $model->findByPk($id);
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
                $model->shared_to = Yii::app()->user->id;
            }
            $model->attributes = $_POST['WorkspaceNote'];
            if (!empty($_POST['WorkspaceNote']['due_date'])) {

                $due_date_array = explode("/", $_POST['WorkspaceNote']['due_date']);
                $model->due_date = $due_date_array[2] . "-" . $due_date_array[1] . "-" . $due_date_array[0];
            }
//            /due_date
            if ($model->save()) {
                $jsonData['status'] = 'success';
                $jsonData['item'] = array(
                    'id' => $model->id,
                    'title' => $model->title,
                    'workspace_id' => $model->workspace_id,
                    'tooltip' => $model->getToolTip()
                );
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actiongetlist() {
        $condition = " 1 = 1";
        $user_id = Yii::app()->user->id;
        if (Yii::app()->user->authorised_user == 1) {
            $condition .= " AND FIND_IN_SET( {$user_id}, shared_to)";
        }
        $models = WorkspaceNote::model()->findAll(array(
            'condition' => $condition
        ));
        $user_list = $this->getUser();

        $data = array();
        foreach ($models as $value) {
            $shared_to = [];
            $_temp_arr = explode(",", $value->shared_to);
            foreach ($_temp_arr as $each_user) {
                if (!empty($each_user)) {
                    $shared_to[] = array(
                        'id' => $each_user,
                        'name' => $user_list[$each_user]
                    );
                }
            }
            $data[] = array(
                'workspace_id' => $value->workspace_id,
                'title' => $value->title,
                'lead_id' => $value->lead_id,
                'file_id' => $models->file_id,
                'id' => $value->id,
                'tooltip' => $value->getToolTip(),
                'shared_to' => $shared_to
            );
        }
        echo json_encode($data);
    }

    public function actionUpdateWorkspace() {
        $workspace_id = (int) Yii::app()->request->getParam('workspace_id');
        if ($workspace_id > 0) {
            $item_id = (int) Yii::app()->request->getParam('item_id');
            $model = WorkspaceNote::model()->findByPk($item_id);
            $model->workspace_id = $workspace_id;
            $model->save();
            echo json_encode(array('status' => 'success'));
        }
    }

    public function actiondeleteItem() {

        $item_id = (int) Yii::app()->request->getParam('id');
        WorkspaceNote::model()->deleteByPk($item_id);
        echo json_encode(array('status' => 'success', 'id' => $item_id));
    }

    public function actionshareItem() {
        $item_id = (int) Yii::app()->request->getParam('id');
        $user_id = (int) Yii::app()->request->getParam('user_id');
        $model = WorkspaceNote::model()->findByPk($item_id);
        $user_list = $this->getUser();

        $_temp_arr = explode(",", $model->shared_to);
        $_temp_arr[] = $user_id;
        $_temp_arr = array_unique($_temp_arr);

        $model->shared_to = implode(",", $_temp_arr);
        $model->save();
        $_temp_arr = explode(",", $model->shared_to);
        foreach ($_temp_arr as $each_user) {
            if (!empty($each_user)) {
                $shared_to[] = array(
                    'id' => $each_user,
                    'name' => $user_list[$each_user]
                );
            }
        }
        $data = array(
            'workspace_id' => $model->workspace_id,
            'title' => $model->title,
            'lead_id' => $model->lead_id,
            'file_id' => $models->file_id,
            'id' => $model->id,
            'tooltip' => $model->getToolTip(),
            'shared_to' => $shared_to
        );
        echo json_encode(array('status' => 'success', 'item' => $data));
    }

    function getUser() {

        $model = User::getUserModels();
        $array = [];
        foreach ($model as $value) {
            $array[$value->id] = $value->getAvatar();
        }
        return $array;
    }

    public function actiondeleteshareItem() {
        $item_id = (int) Yii::app()->request->getParam('id');
        $user_id = (int) Yii::app()->request->getParam('user_id');
        $model = WorkspaceNote::model()->findByPk($item_id);

        $share_to = $model->shared_to;
        $share_to =str_replace($user_id, "", $share_to);
        $_temp_arr = explode(",", $share_to);

        $_temp_arr = array_unique($_temp_arr);

        $model->shared_to = implode(",", $_temp_arr);
        $model->save();

        echo json_encode(array('status' => 'success',));
    }

}
