<div class="table-responsive">
    <table class="table table-hover table-bordered personal-task" id="optional_item_table">
        <tr>
            <th>No</th>
            <th>Product</th>
            <th>Description</th>
            <th>Quantity</th>
            <th>Unit Price</th>
            <th class="text-center">
                <a class="btn btn-xs btn-theme " href="javascript:void(0);" onclick="addTableRow($('#optional_item_table'));"><i class="fa fa-plus"></i></a></th>
        </tr>

        <?php
        foreach ($modelQuoteOptionalItems as $i => $item_detail) {
            if ($item_detail->unit_price == '') {
                $item_detail->unit_price = number_format(0.00, 2, '.', '');
            }
            $value=$item_detail->product->part_number;
            if ($model->qtn_type == 'H') {
                $value=$item_detail->product->hiring_part_number;
            }
            ?>
            <tr>
                <td><label><?php echo ($i + 1); ?></label></td>
                <td>
                    <?php echo CHtml::activeTextField($item_detail, "[" . $i . "]product_name", array('class' => 'tooltipster go', 'value' => $value, 'placeholder' => 'Type & Select', 'onKeyup' => 'js:autoCompleteOptionalProduct(this.id);', 'title' => 'Select product')); ?>
                    <?php echo CHtml::activeHiddenField($item_detail, "[" . $i . "]product_id"); ?>
                    <?php echo CHtml::activeHiddenField($item_detail, "[" . $i . "]id"); ?>
                </td>
                <td>
                    <?php
                    echo CHtml::activeTextArea($item_detail, "[" . $i . "]description", array('class' => 'tooltipster desc desc2 go en-text-area', 'title' => 'Add Description here'));
                    ?>
                </td>
                <td>
                    <?php echo CHtml::activeTextField($item_detail, "[" . $i . "]quantity", array('class' => 'qty go cell-center text-right', 'onkeypress' => 'return isPositiveInteger(event)', 'onkeydown' => 'nextline(event)')); ?>
                </td>
                <td>
                    <?php echo CHtml::activeTextField($item_detail, "[" . $i . "]unit_price", array('class' => 'rate go text-right to_be_calculated', 'onkeypress' => 'return isPositiveNumber(event)', 'onkeydown' => 'nextline(event)')); ?>
                </td>
                <td class="text-center nw" width="1%">
                    <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('id'=>"tditem_delete_".$i,'class' => 'btn btn-xs btn-danger', 'onclick' => 'removeitemoptional($(\'#optional_item_table\'),this,this.id)', 'title' => 'Remove this item')); ?>
                </td>
            </tr>
            <?php
        }
        ?>
    </table>
</div>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("autoCompleteOptionalProduct", "function autoCompleteOptionalProduct(field_id){
        var customer_id =$('#Quotes_customer_id').val();
        var qtn_type =$('#Quotes_qtn_type').val();
        if(customer_id==''){
            t8.error('Please select a customer'); 
            return false;
        }
        else{   
            var arr_fields= field_id.split('_');
            var model_name = arr_fields[0];
            var row_field = arr_fields[1];
            var url = '" . Yii::app()->createUrl('quotation/GetOptionalProduct') . "'+'&qtn_type='+qtn_type+'';
            $('#'+field_id).autocomplete({
                minLength   : 1,
                source      : function (request, response) { autoCompleteSource(request, response,url) },
                focus       : function( event, ui ) { },
                select      : function( event, ui ) {
                                event.preventDefault();
                                trigger_target_id   =   $(event.target).attr('id');
                                var product_id=ui.item.value;
                                var product_name=ui.item.part_number;
                                var desc=ui.item.description;
                                var tot_quantity=ui.item.total_qty;
                                $('#QuotesOptionalItem_'+row_field+'_product_name').val(product_name);
                                $('#QuotesOptionalItem_'+row_field+'_description').val(desc);
                                $('#QuotesOptionalItem_'+row_field+'_product_id').val(product_id);
                                $('#QuotesOptionalItem_'+row_field+'_quantity').val(tot_quantity);
                                $('#QuotesOptionalItem_'+row_field+'_quantity').focus();
                }
            })
        }
}", CClientScript::POS_HEAD);
$cs->registerScript("removeitemoptional", " function removeitemoptional(jQtable,evt,field_id) {
            var arr_fields= field_id.split('_');
            var row_field=arr_fields[2];
            var id=$('#QuotesOptionalItem_'+row_field+'_id').val(); 
            formIdStarter   =   jQtable.attr('id').split(/_(.+)?/)[0];
            var num_rows    =   jQtable.find('tr:gt(0)').length;
            if(num_rows>1){
            var tr  =   $(evt).parent().parent();
            if(isRowEmpty(tr)) {
                if(id!=''){
                    jQuery.ajax({
                        'type': 'post',
                        'dataType': 'json',
                        'url': '" . Yii::app()->createUrl('quotation/removeoptionalitem') . "',
                        'data': {'id':id} ,
                        'cache': false,
                        'success': function(data) {
                            if(data.status=='success'){
                                $(evt).parents('tr').remove();
                                var i=0;
                                jQtable.find('tr:gt(0)').each(function() {
                                    $(this).find('input,textarea,.errorMessage,div,select,a').each(function()
                                    {
                                        old_id = $(this).attr('id');
                                        if(old_id!==undefined) {
                                            new_id = old_id.replace(/\d+/,i);
                                            $(this).attr('id',new_id);
                                        }
                                        old_name = $(this).attr('name');
                                        if(old_name!==undefined) {
                                            new_name = old_name.replace(/\d+/,i);
                                            $(this).attr('name',new_name);
                                        }
                                    });
                                    $(this).find('td:first label').html(++i);
                                });
                                t8.success('Deleted');
                            }else{
                                t8.error('Deletion Not Possible, History Exist');
                            }
                        }
                    });
                }else{
                    $(evt).parents('tr').remove();
                    var i=0;
                    jQtable.find('tr:gt(0)').each(function() {
                        $(this).find('input,textarea,.errorMessage,div,select,a').each(function()
                        {
                            old_id = $(this).attr('id');
                            if(old_id!==undefined) {
                                new_id = old_id.replace(/\d+/,i);
                                $(this).attr('id',new_id);
                            }
                            old_name = $(this).attr('name');
                            if(old_name!==undefined) {
                                new_name = old_name.replace(/\d+/,i);
                                $(this).attr('name',new_name);
                            }
                        });
                        $(this).find('td:first label').html(++i);
                    });
                }
            }
        }else {
            alert('Atleast one item needed here');
        }
    }", CClientScript::POS_HEAD);
