<?php
$form = $this->beginWidget('CActiveForm', array(

    'id' => 'send-mail-customer-form',

    'enableAjaxValidation' => false,

    'enableClientValidation' => false,

    ));
    
    $model = new JobOrderAgentDetails();

?>

 <div class="tab-content">
        <div class="tab-pane active">
            <ul class="clearfix form-ul material">
                <li class="col-sm-6">
                     <?php echo $form->dropDownList($model, 'shipper_id', Vendor::getVendors(), array('title' => 'Agent','data-label'=>'Agent <span style="color:red">*</span>','empty'=>'--Select--')); ?>
                </li>
                
                <li class="col-sm-6">
                    <button type="button" class="load-mail-customer-refresh-btn btn btn-theme" onclick="LoadCustomers();"><i class="fa fa-refresh"></i> Load</button>
                </li>
        
                
               
    		</ul>
        </div>
        
        <div id="div_contact_details"></div>
        
                    <span id="success_message"></span>
                    <span id="error_message" ></span>
      
    </div>

    <div class="form-group" id="process" style="display:none;">
        <div class="progress">
       <div class="progress-bar progress-bar-striped active" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="">
       </div>
      </div>
       </div>

      

    <div class="modal-footer">

            <button type="button" class="btn btn-danger" id="joborder_close" data-dismiss="modal">Close</button>
            <button type="button" class="send-mail-customer-save-btn btn btn-theme" onclick="SendMailToCustomer();" id="btn_send_email" style="display:none;">Send Mail</button>
           
    </div>

    <?php $this->endWidget(); ?>
<?php

    $cs = Yii::app()->getClientScript();
    
    

 $cs->registerScript("LoadCustomers", "function LoadCustomers(){
 
    var shipper_id  =   $('#JobOrderAgentDetails_shipper_id').val();
    if(shipper_id==''){
        t8.error('Please select a shipper');
        return false;
    }
    else{
        jQuery.ajax({
            'data' :{'shipper_id':shipper_id},
            'type':'post',
            'dataType' : 'json',
            'url': '" . Yii::app()->createUrl('logistics/joborder/loadcustomersemail') . "',
            'beforeSend':function()
             {
              $('.load-mail-customer-refresh-btn').attr('disabled', 'disabled');
              $('#process').css('display', 'block');
              
              $('#div_contact_details').html('');
                $('#btn_send_email').hide();
              
             },
            'success': function(data) {
              var percentage = 0;
              
              var success_msg = data.success;
              var error_msg = data.error;
    
                  var timer = setInterval(function(){
                   percentage = percentage + 20;
                   progress_bar_process(percentage, timer,success_msg,error_msg,'load');
                  }, 100);
              
            }
        });
    }
}", CClientScript::POS_HEAD); 

$cs->registerScript("SendMailToCustomer", "function SendMailToCustomer(){
    var shipper_id      =   $('#JobOrderAgentDetails_shipper_id').val();
    var job_order_ids   =   '';
    var agent_ids       =   '';
    var contact_ids     =   '';
    var cnt_check       =   0;
    $('#tbl_customer_contact').find('input[type=\"checkbox\"]:checked').each(function () {
        
        var obj_id = this.id;
        var arr_job_order_id = obj_id.split('_');
        
        var row_id = arr_job_order_id[1];
        //alert($('#hidjoborderagentid_'+row_id).val());
        
        
        if(this.value!='on'){
        
            if(job_order_ids==''){     
                job_order_ids=this.value;
            }
            else{
                job_order_ids+=','+this.value;
            }
            
            if(agent_ids==''){
                agent_ids=$('#hidjoborderagentid_'+row_id).val();
            }
            else{
                agent_ids+=','+$('#hidjoborderagentid_'+row_id).val();;
            }
            
            if(contact_ids==''){
                contact_ids=$('#hidcustomercontactid_'+row_id).val();
            }
            else{
                contact_ids+=','+$('#hidcustomercontactid_'+row_id).val();;
            }
            
            cnt_check++;
        
        }
    });
    
    
    if(cnt_check > 10){
        t8.error('Maximum selected email(s) should be 10');
        return false;
    }
    else if(job_order_ids!=''){
        jQuery.ajax({
            'data' :{'job_order_ids':job_order_ids,'agent_ids':agent_ids,'shipper_id':shipper_id,'contact_ids':contact_ids},
            'type':'post',
            'dataType' : 'json',
            'url': '" . Yii::app()->createUrl('logistics/joborder/sendmailtocustomersubmit') . "',
            'beforeSend':function()
             {
              $('.send-mail-customer-save-btn').attr('disabled', 'disabled');
              $('#process').css('display', 'block');
             },
            'success': function(data) {
              var percentage = 0;
              var success_msg = data.success;
              var error_msg = data.error;
    
              var timer = setInterval(function(){
               percentage = percentage + 20;
               progress_bar_process(percentage, timer,success_msg,error_msg,'save');
              }, 1000);
              
            }
        });
    }
    
    else{
        t8.error('Please choose an Email');
        return false;
    }
    
    
    
}", CClientScript::POS_HEAD); 


$cs->registerScript("checkAllContacts", "function checkAllContacts()
{
    if($('#chk_all_contacts').prop('checked')==true){
        $('.check_contact_ids').prop('checked', true);
    }
    else{
        $('.check_contact_ids').prop('checked', false);
    }
    
      
}", CClientScript::POS_HEAD);



     ?>
     
     <script type="text/javascript">
    
         
         
         function progress_bar_process(percentage, timer,success_msg,error_msg,frm)
          {
           $('.progress-bar').css('width', percentage + '%');
           if(percentage > 100)
           {
            clearInterval(timer);
            //$('#send-mail-customer-form')[0].reset();
            $('#process').css('display', 'none');
            $('.progress-bar').css('width', '0%');
            if(frm=='load'){
                $('.load-mail-customer-refresh-btn').attr('disabled', false);
                $('#div_contact_details').html("<div class='alert alert-success'>"+success_msg+"</div>");
                $('#btn_send_email').show();
            }
            else{
                $('.send-mail-customer-save-btn').attr('disabled', false);
                $('#success_message').html("<div class='alert alert-success'>"+success_msg+"</div>");
            }
            
            if(error_msg!=''){
                $('#error_message').html("<div class='alert alert-danger'>"+error_msg+"</div>");
            }
            setTimeout(function(){
             $('#success_message').html('');
             $('#error_message').html('');
            }, 10000);
           }
          }

     </script>