<?php $cs = Yii::app()->getClientScript();?>
  
<script type="text/javascript">
$(document).ready(function() {

    var table_id ="#tble_invoice";
    var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
                        data.invoice_type = $("#invoice_type").val();
                        return data;
                    }).DataTable({
        scrollY         : "600px",
        pageLength      : 100,
		processing: true,
		columns: [
	                {className: "sl col-max-1"},
	                {className: "sl col-max-1"},
					{className: "sl col-max-1"},
	                {className: "sl col-max-1"},               
	                {className: "sl col-max-1" },
	                {className: "sl col-max-3" },
	                {className: "sl col-max-1" },
	                {className: "sl col-max-1" },
	                {className: "sl col-max-1 text-right"},
	                {className: "sl col-max-1 text-right"},
	                {className: "sl col-max-1"},
	                {className: "sl col-max-1"},
	            ],
	            "columnDefs": [
	                {
	                   //"targets": [5],
	                   //"visible": false,
	                },
	            ],
            
        ajax: {
            url: "<?php echo Yii::app()->createUrl('invoice/getinvoicelist');?>",
            type: "POST",
            cache : false,
        },
        serverSide:     true,
        fixedColumns:   true,
		processing: true,
        fixedHeader: {
            headerOffset: $("header.main").outerHeight()
        },
        "fnCreatedRow"  : function( nRow, aData, iDataIndex ){
     		$(nRow).addClass("context-menu");
 		},
 		"fnRowCallback" : function( nRow, aData, iDisplayIndex, iDisplayIndexFull){
	     	$("#tble_invoice tbody").mousedown(function (e) {   
	         $(this).contextMenu({
	             selector: ".context-menu",
	            callback: function(key, options) {
	         		var action_id 	= key;
					var data 		= table.row( this ).data();
					var file_id 	= data[0];
					var id			= data[12];
					var customer_id	= data[13];
					var crm_user_id	= data[14];
					if(action_id == "print"){
						window.open($('#liveSite').val()+"/index.php?r=invoice/PrintInvoiceReportPDF&id="+id+"&c_id="+crm_user_id+'&frm=tax',"_blank")
					}
					else if(action_id == "activity"){
						loadPopupModal("activity/create&file_id="+file_id+"&customer_id="+customer_id,"Edit Activity" ,"xl");
					}
	
					
	     		},
	             items: {
	                 <?php if((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["invoice_print"]))){ ?>
		              		"print": {name: "Print", icon: "fa-print"},
		             <?php } ?> 
		             
		             <?php  if((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["customer_activity"]))){ ?>
              				"activity": {name: "Activity", icon: "fa-certificate"},
	                 <?php } ?>
	             }
	         }
	         );
	     });     
	 }
    } );
} );

</script>

<section class="panel">
    <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-user"></i> Invoice
            <div class="pull-right">
                <div class="col-md-12">
                    <div class="col-md-8" width="100%">
                        <?php echo CHtml::dropdownlist('invoice_type', '',  MasSalesGroup::getSalesGroup(), array('class' => 'form-control', 'onchange' => 'reloadTable("#tble_invoice");', 'prompt' => 'All')); ?>
                    </div>
                     <?php
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["invoice_add"])){
                        ?>
                    <div class="col-md-3">
                        <button class="btn btn-sm btn-theme" id="add_popup" onclick="loadPopupModal('invoice/createMultiInvoice','Add New Invoice','xl')"><i class="fa fa-plus"></i> ADD</button>
                    </div>
                    <?php }    ?>
                </div>
            </div>
    </header>   
    <div class="panel-body">
          <div class="custom-data-table">
                  <table class="table table-hover table-bordered personal-task" id="tble_invoice">
                      <thead>
                        <tr>
                            <th>File</th>
							<th>Type</th>
                            <th>Inv No</th>
                            <th>Order No</th>
                            <th>Inv Date</th>
                            <th>Customer</th>
                            <th>Lead Owner</th>
                            <th>Curr</th>
                            <th>VAT</th>
                            <th>Value</th>
                            <th>Status</th>
                            <th>CN</th>
                        </tr>
                    </thead>
                   
                </table>
            </div>
        </div>
   </section>











    



