<div class="tab-content">
    <div class="tab-pane active" id="inventory">
        <section class="panel">
            <header class="panel-heading clearfix panel-theame">
                <i class="fa fa-users"></i> Inventory
                <div class="pull-right" style="display:inline-flex">
                &NonBreakingSpace;
                
                <?php 
                echo CHtml::dropdownlist('outlet','', MasOutlets::getAllOutlets(),array('class'=>'form-control','data-label'=>'Outlet')); 
                ?>
                &NonBreakingSpace;
                <?php 
                $outlet=(int) Yii::app()->user->outlet_id;
                echo CHtml::dropdownlist('created_user','',MasUsers::get_outlet_salesandadmin($outlet), array('class'=>'form-control','data-label'=>'User')); ?>
                &NonBreakingSpace;
                <?php echo CHtml::dropdownlist('type','',array('I'=>'Inventory','S'=>'Service'), array('class'=>'form-control','data-label'=>'Type','prompt' => 'All Types')); ?>
                &NonBreakingSpace;
                <?php echo CHtml::dropdownlist('brand','',MasBrand::getAllBrands(), array('class'=>'form-control','data-label'=>'Brand','prompt' => 'All Brands')); ?>
                &NonBreakingSpace;
                <?php echo CHtml::dropdownlist('stock','',array(1=>'Available',2=>'Empty'), array('class'=>'form-control','data-label'=>'Stock','prompt' => 'Stock(All)')); ?>
                &NonBreakingSpace;
                <button class="btn btn-theme btn-md" onclick="reloadTable('#tbl_inventory');"><i class="fa fa-retweet"></i></button>
                </div>
            </header>   
            <div class="panel-body">
                <div class="custom-data-table">
                    <table class="table table-hover table-bordered personal-task" id="tbl_inventory">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Part No</th>
                                <th>Description</th>
                                <th>Type</th>
                                <th>Brand</th>
                                <th>Qty</th>
                                <th>Unit</th>
                                <th>Price</th>
                                <th>Tax(%)</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </section>
    </div>
</div>
<script>
    $(document).ready(function () {
        //document ready

        var table_details_id = "#tbl_inventory";
        table_details = $(table_details_id).on("preXhr.dt", function (e, settings, data) {

        data.outlet = $("#outlet").val();
        data.type = $("#type").val();
        data.brand = $("#brand").val();
        data.stock = $("#stock").val();
        data.created_user = $("#created_user").val();
        return data;

}).DataTable({
            scrollY: "550px",
            "bAutoWidth": true,
            pageLength: 50,
            columns: [
                {className: ""},
                {className: ""},
                {className: ""}, 
                {className: ""},
                {className: ""},               
                {className: "text-right" },
                {className: "text-center"}, 
                {className: "text-right" },
                {className: "text-center" },
                {className: ""},
            ],
            ajax: {
                url: "index.php?r=logistics/inventory/GetListSalesman",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            order: [[1, "asc"]],
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {

                if (aData[3] == "Service") {
                    $("td", nRow).addClass("bg-success");
                }
                if (aData[10] == "N") {
                    $("td", nRow).addClass("bg-danger");
                }
            }
        });
        $(".dataTables_scrollFoot").hide();

    });
    function block(id, status){
        var r = confirm((status == "1") ? 'Are you sure to Block this Item?' : 'Are you sure to Unblock this Item?');
        if (r == true)
        {
            jQuery.ajax({
                'type'  : 'post',
                'datatype' :'json',
                'data'  : 'id=' + id + "&status=" + status,
                'url'  : $('#liveSite').val() + 'index.php?r=logistics/Inventory/EnableDisable',
                'cache': false,
                'success':function(data){
                    if (data.status == 'fail'){
                        t8.error('Please Try Later');
                    } else {
                        t8.info('Item Status Updated');
                        reloadTable("#tbl_inventory");
                    }
                }
            });
        }
    }
</script>