<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'inventory-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
    ));
?>
        <ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
            <li class="active"><a href="#inventory_tab1" data-toggle="tab">General</a></li>
            <li><a href="#inventory_tab2" data-toggle="tab">Additional</a></li>
        </ul>
<div class="tab-content">
    <div  id="inventory_tab1" class="tab-pane active">
        <ul class="clearfix form-ul material">
            
            <li class="col-sm-6">
                <?php echo $form->hiddenField($model, 'id'); ?> 
                <?php echo $form->textField($model, 'part_number', array('data-label' => 'Part Number <span style="color:red;">*</span>')); ?>
            </li>
            <li class="col-sm-6">
                <?php echo $form->textField($model, 'description', array('data-label' => 'Description <span style="color:red;">*</span>')); ?>
            </li>
             <li class="col-sm-6">
                <?php 
                $customer_name="";
                if ($model->customer_id > 0) {
                    
                    $customer_name=Customer::model()->findByPk($model->customer_id)->customer_name;
                    //$customer_name = $model->customer->customer_name;
                }  
                ?>
                <?php
                
                    echo $form->textField($model, 'customer_name', array('class' => 'text-bold', 'data-label' => "Customer <span style='color:red'>*</span>", 'title' => 'Please select customer', 'onKeyup' => 'js:autoCompleteCustomer(this.id,"Inventory");', 'value' => $customer_name));
                ?>
                    <?php echo $form->hiddenField($model, 'customer_id'); ?>
            </li>
             <li class="col-sm-2">
             <?php 
            $stype_readonly =false;
            if($model->id>0){
                $mod_stockledger = StockLedger::model()->findAll(array('condition'=>'product_id='.$model->id.' AND type!="OB"'));
                if(!empty($mod_stockledger)){
                    $stype_readonly=true;
                }
            }
            if($stype_readonly){
                echo $form->dropdownlist($model,'type',array('I'=>'Inventory','S'=>'Service'), array('class' => 'tooltipster', 'data-label' => 'Type<span style="color:red;"> *</span>','disabled'=>true));
                echo $form->hiddenField($model,'type');
            }else{
                echo $form->dropdownlist($model,'type',array('I'=>'Inventory','S'=>'Service'), array('class' => 'tooltipster', 'data-label' => 'Type<span style="color:red;"> *</span>'));
            }?>
            </li>
            <li class="col-sm-2">
            <?php echo $form->dropdownlist($model,'brand',MasBrand::getAllBrands(), array('class' => 'tooltipster', 'data-label' => 'Brand'));?>
            </li>
            <li class="col-sm-2">
            <?php echo $form->dropdownlist($model,'generic_id',MasGeneric::getAllGeneric(), array('class' => 'tooltipster', 'data-label' => 'Generic'));?>
            </li>
            <li class="col-sm-2">
            <?php if($stype_readonly){
                echo $form->dropdownlist($model,'unit',MasUnit::getAllBaseUnits(), array('class' => 'tooltipster', 'data-label' => 'Unit<span style="color:red;"> *</span>','disabled'=>true));
                echo $form->hiddenField($model,'unit');
            }else{
                echo $form->dropdownlist($model,'unit',MasUnit::getAllBaseUnits(), array('class' => 'tooltipster', 'data-label' => 'Unit'));
            }?>
            </li>
            <li class="col-sm-2">
                <?php echo $form->textField($model, 'rate', array('data-label' => 'Sales Price','onkeypress'=>'return isNumberKey(event)')); ?>
            </li>
            <li class="col-sm-2">
             <?php echo $form->dropdownlist($model,'tax_code',MasInvTax::getTax(), array('class' => 'tooltipster', 'data-label' => 'Tax<span style="color:red;"> *</span>'));?>
            </li>
            <li class="col-sm-4"> 
                <?php echo $form->textField($model, 'barcode', array('data-label' => 'Bar Code')); ?>
            </li>
            <li class="col-sm-2" style="display:none;">
                <?php echo $form->textField($model, 'cost', array('data-label' => 'Cost','onkeypress'=>'return isNumberKey(event)','value'=>0,'readonly'=>true)); ?>
            </li>
            <li class="col-sm-2" style="display:none;">
                <?php echo $form->textField($model, 'available_qty', array('data-label' => 'Total Qty','onkeypress'=>'return isNumberKey(event)','value'=>0)); ?>
            </li>
            <li class="col-sm-2" style="display:none;">
                <?php echo $form->textField($model, 'value', array('data-label' => 'Value','onkeypress'=>'return isNumberKey(event)','value'=>0,'readonly'=>true)); ?>
            </li>
        </ul>
    </div>
        <div  id="inventory_tab2" class="tab-pane">
        <ul class="clearfix form-ul material">
            <li class="col-sm-2">
            <?php echo $form->textField($model, 'length', array('data-label' => 'Length (CM)', 'onkeypress'=>'return isNumberKey(event)','onkeyup'=>'calculateStoreCBM()')); ?>
            </li>
            <li class="col-sm-2">
            <?php echo $form->textField($model, 'width', array('data-label' => 'Width (CM)', 'onkeypress'=>'return isNumberKey(event)','onkeyup'=>'calculateStoreCBM()')); ?>
            </li>
            <li class="col-sm-2">
            <?php echo $form->textField($model, 'height', array('data-label' => 'Height (CM)', 'onkeypress'=>'return isNumberKey(event)','onkeyup'=>'calculateStoreCBM()')); ?>
            </li>
            <li class="col-sm-3">
            <?php echo $form->textField($model, 'weight', array('data-label' => 'Weight', 'onkeypress'=>'return isNumberKey(event)')); ?>
            </li>
            <li class="col-sm-3">
            <?php echo $form->textField($model, 'volume', array('data-label' => 'CBM (M3)', 'onkeypress'=>'return isNumberKey(event)','readonly'=>true)); ?>
            </li>
            <li class="col-sm-2">
            <?php echo $form->textField($model, 'thickness', array('data-label' => 'Thickness', 'onkeypress'=>'return isNumberKey(event)')); ?>
            </li>
            <li class="col-sm-2">
            <?php echo $form->textField($model, 'material', array('data-label' => 'Material')); ?>
            </li>
            <li class="col-sm-2">
            <?php echo $form->textField($model, 'finished', array('data-label' => 'Finish')); ?>
            </li>
            <li class="col-sm-3">
             <?php echo $form->dropdownlist($model, 'have_expiry_date', array('N'=>'No','Y'=>'Yes'), array('class' => 'tooltipster', 'data-label' => 'Have Expiry Date<span style="color:red;"> *</span>')); ?>
            </li>
            <li class="col-sm-3">
             <?php echo $form->dropdownlist($model, 'have_serial_no', array('N'=>'No','Y'=>'Yes'), array('class' => 'tooltipster', 'data-label' => 'Have Serial No<span style="color:red;"> *</span>')); ?>
            </li>
            <li class="col-sm-2">
            <?php echo $form->textField($model, 'reorder_level', array('data-label' => 'Re-order Level')); ?>
            </li>
            <li class="col-sm-2">
            <?php echo $form->textField($model, 'hs_code', array('data-label' => 'HS Code')); ?>
            </li>
            <li class="col-sm-8">
            <?php echo $form->textField($model, 'notes', array('data-label' => 'Notes')); ?>
            </li>
        </ul>
        </div>
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-default" id="inv_close" data-dismiss="modal">Close</button>
    <?php 
                $url = Yii::app()->createUrl('logistics/inventory/Save');
                echo CHtml::ajaxSubmitButton('Save', $url, array(
                            'dataType' => 'json',
                            'type' => 'post',
                            'success' => 'function(data) {
                                if(data.status=="success"){  
                                    $("#inv_close").click();                                        
                                    t8.success("Inventory Details Saved Successfully!");
                                    reloadTable("#tbl_inventory");
                                } else { 
                                    $("#inventory-form .customer-save-btn").prop("disabled", false);
                                    $("#inventory-form .customer-save-btn").addClass("btn-theme").removeClass("btn_loading");
                                    $.each(data, function(key, val) {
                                        $("#inventory-form #"+key+"_em_").text(val).show(); 
                                        t8.error(""+val+""); 
                                    }); 
                                } 
                            }',
                            'beforeSend' => 'function(){
                                $(".toast8-error").hide(); 
                                $("#loader").show();
                                $("#inventory-form .customer-save-btn").prop("disabled", true);                                
                                $("#inventory-form .customer-save-btn").addClass("btn_loading").removeClass("btn-theme");
                                
                            }',
                            'complete' => 'function(){
                                $("#loader").hide();
                                $("#inventory-form .customer-save-btn").prop("disabled", false);                                
                                $("#inventory-form .customer-save-btn").addClass("btn-theme").removeClass("btn_loading");
                            }'
                                
                    ), array('id' => 'mybtn' . rand(), 'class' => 'customer-save-btn btn btn-theme'));
           
    ?>
</div>
<?php $this->endWidget(); ?>
<?php 
$cs = Yii::app()->getClientScript();

$cs->registerScript("autoCompleteCustomer", "
    function autoCompleteCustomer(field_id,frm){ 
        var url = '" . Yii::app()->createUrl('logistics/customer/GetcustomerDetails') . "'+'&frm='+frm; 
        $('#'+field_id).autocomplete({ 
            minLength : 1, 
            source : function (request, response) { 
                autoCompleteSource(request, response,url) 
            }, 
            focus : function( event, ui ) { $(this).val((ui.item.label)); return false; }, 
            select : function( event, ui ) {
                event.preventDefault(); trigger_target_id = $(event.target).attr('id'); 
                var customer_id=ui.item.value;
                $('#Inventory_customer_name').val(ui.item.customername); 
                $('#Inventory_customer_id').val(ui.item.value); 
            } 
        }) 
    }
    function calculateStoreCBM(){
        var length=$('#Inventory_length').val();
        var breadth=$('#Inventory_width').val();
        var height=$('#Inventory_height').val();
        var cbm = length*breadth*height/1000000;
        $('#Inventory_volume').val(cbm);
    }
    ", CClientScript::POS_HEAD);
