<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
?>
<script type="text/javascript">
    $(document).ready(function () {

        var table_id = "#tbl_goods_receipts_details";
        var table = $(table_id).DataTable({
        scrollY         : "645px",
                pageLength      : 50,
                processing: true,
                ajax: {
                url: "<?php echo Yii::app()->createUrl('logistics/Goodsreceipts/GetList'); ?>",
                        type: "POST",
                        cache : false,
                },
                serverSide:     true,
                fixedColumns:   true,
                processing: true,
                fixedHeader: {
                headerOffset: $("header.main").outerHeight()
                },
                "fnCreatedRow"  : function (nRow, aData, iDataIndex) {
                    $(nRow).addClass("context-menu");
                },
                "fnRowCallback" : function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {

                    $("#tbl_goods_receipts_details tbody").mousedown(function (e) {
                        $(this).contextMenu({
                        selector: ".context-menu",
                                callback: function (key, options) {
                                    var action_id = key;
                                    var data = table.row(this).data();
                                    var id = data[0];
                                    var part_number = data[1];
                                    // if(action_id == "view"){
                                    // 	loadPopupModal("receipts/create&id="+id,"Receipt - "+id ,"lg");
                                    // }
                                    //else
                                    if (action_id == "print") {
                                        window.open($('#liveSite').val() + "/index.php?r=logistics/goodsreceipts/PrintReceiptPDF&id=" + id, "_blank")
                                    }
                                    if (action_id == "printpack") {
                                        window.open($('#liveSite').val() + "/index.php?r=logistics/goodsreceipts/PrintReceiptPackagingPDF&id=" + id, "_blank")
                                    }

                                },
                                items: {
<?php if (isset(Yii::app()->user->havePermissionOn['mov_receipt_view']) || Yii::app()->user->authorised_user == 1) { ?>
                                    // "view": {name: "View", icon: "fa-eye"},
<?php } ?>
<?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mov_receipt_view"])) { ?>
                                    "print" : {name: "Print", icon: "fa-print"},
                                    "printpack" : {name: "Print Package", icon: "fa-print"},
<?php } ?>
                                }
                        }
                        );
                    });
                    }
        });
                $(".dataTables_scrollFoot").hide();

        loadCheckinList();
                loadPackagingList();
    });
    function Checkin()
    {
        reloadTable("#tble_tble_check_in");
    }
    function Packaging()
    {
        reloadTable("#tble_tble_packaging");
    }
    function Goodsreceipt()
    {
        reloadTable("#tbl_goods_receipts_details");
    }
</script>

<ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
    <li id="li_receipt_index_1" class="active"><a href="#inventory_goods_receipt_1" data-toggle="tab" onclick="Goodsreceipt();"><i class="fa fa-money"></i> Receipts</a></li>
    <li id="li_receipt_index_2"><a href="#inventory_goods_receipt_2" data-toggle="tab" onclick="Checkin();"> <i class="fa fa fa-area-chart"></i> Checkin</a></li>
    <li id="li_receipt_index_3"><a href="#inventory_goods_receipt_3" data-toggle="tab" onclick="Packaging();"> <i class="fa fa fa-area-chart"></i> Packaging</a></li>
</ul>
<div class="tab-content">
    <div class="tab-pane active" id="inventory_goods_receipt_1">
        <section class="panel" style="background-color:#F6F3EE;">
            <header class="panel-heading clearfix panel-theame">
                <i class="material-icons">casino</i> Receipts
                <div class="pull-right">
                    <?php
//                if (isset(Yii::app()->user->havePermissionOn['mov_receipt_add']) ||  Yii::app()->user->authorised_user == 1) {
                    ?>
                    <button class="btn btn-xs btn-theme" onclick="loadPopupModal('logistics/Goodsreceipts/create', 'Receipt', 'xl')"> <i class="fa fa-plus"></i> ADD</button>
                    <button class="btn btn-xs btn-theme" onclick="loadPopupModal('logistics/Goodsreceipts/UploadReceipt', 'Upload Receipt', 'xl')"> <i class="fa fa-upload"></i> UPLOAD</button>
                    <button class="btn btn-xs btn-theme" onclick="loadPopupModal('logistics/Goodsreceipts/UpdateGoodsreceiptUpload', 'Receipt Update Status Form', 'xl')"> <i class="fa fa-refresh"></i> UPDATE</button>
                    
                    <?php
//                }
                    ?>
                </div>
            </header>
            <div class="panel-body">
                <div class="custom-data-table">
                    <table class="table table-hover table-bordered personal-task" id="tbl_goods_receipts_details" style="font-size:13px;">
                        <thead>
                            <tr>
                            <tr>
                                <th>Receipt No</th>
                                <th>Receipt Date</th>
                                <th>Customer</th>
                                <th>Reference</th>
                            </tr>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </section>
    </div>
    <div class="tab-pane" id="inventory_goods_receipt_2">
<?php $this->renderPartial("../checkin/goods_receipt_index", array('frm' => 'GR')); ?>
    </div>
    <div class="tab-pane" id="inventory_goods_receipt_3">
<?php $this->renderPartial("../packaging/goods_receipt_index", array('frm' => 'GR')); ?>
    </div>
</div>
