<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
?>
<script type="text/javascript">
    $(document).ready(function () {
        var table_id = "#tbl_goods_issue_details";
        var table = $(table_id).DataTable({
        scrollY         : "645px",
                pageLength      : 50,
                processing: true,
                ajax: {
                url: "<?php echo Yii::app()->createUrl('logistics/Goodsissue/GetList'); ?>",
                        type: "POST",
                        cache : false,
                },
                serverSide:     true,
                fixedColumns:   true,
                processing: true,
                fixedHeader: {
                headerOffset: $("header.main").outerHeight()
                },
                "fnCreatedRow"  : function (nRow, aData, iDataIndex) {
                    $(nRow).addClass("context-menu");
                },
                "fnRowCallback" : function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {

                    $("#tbl_goods_issue_details tbody").mousedown(function (e) {
                        $(this).contextMenu({
                        selector: ".context-menu",
                                callback: function (key, options) {
                                    var action_id = key;
                                    var data = table.row(this).data();
                                    var id = data[0];
                                    var part_number = data[1];
                                    // if(action_id == "view"){
                                    // 	loadPopupModal("issues/create&id="+id,"Receipt - "+id ,"lg");
                                    // }
                                    //else
                                    if (action_id == "print") {
                                        window.open($('#liveSite').val() + "/index.php?r=logistics/goodsissue/PrintIssuePDF&id=" + id, "_blank")
                                    }
                                    if(action_id == "printpack"){
                                        window.open($('#liveSite').val() + "/index.php?r=logistics/goodsissue/PrintIssuePackagingPDF&id=" + id, "_blank")
                                    }
                                    if(action_id == "printdelivery"){
                                        window.open($('#liveSite').val() + "/index.php?r=logistics/goodsissue/PrintDeliveryNotePDF&id=" + id, "_blank")
                                    }
                                },
                                items: {
                                    <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mov_issue_view"])) { ?>
                                    "print"  : {name: "Print", icon: "fa-print"},
                                    "printpack"  : {name: "Print Package Details", icon: "fa-print"},
                                    "printdelivery"  : {name: "Print Delivery Note", icon: "fa-print"},
                                    <?php } ?>
                                }
                        }
                        );
                    });
                    }
        });
                $(".dataTables_scrollFoot").hide();

        loadCheckinList();
        loadPackagingList();
    });
    function Checkin()
    {
        reloadTable("#tble_tble_check_in");
    }
    function Packaging()
    {
        reloadTable("#tble_tble_packaging");
    }
    function Goodsissue()
    {
        reloadTable("#tbl_goods_issue_details");
    }
</script>

<ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
    <li id="li_issue_index_1" class="active"><a href="#inventory_goods_issue_1" data-toggle="tab" onclick="Goodsissue();"><i class="fa fa-money"></i> Issue</a></li>
    <li id="li_issue_index_2"><a href="#inventory_goods_issue_2" data-toggle="tab" onclick="Checkin();"> <i class="fa fa fa-area-chart"></i> Checkin</a></li>
    <li id="li_issue_index_3"><a href="#inventory_goods_issue_3" data-toggle="tab" onclick="Packaging();"> <i class="fa fa fa-area-chart"></i> Packaging</a></li>
</ul>
<div class="tab-content">
    <div class="tab-pane active" id="inventory_goods_issue_1">
        <section class="panel" style="background-color:#F6F3EE;">
            <header class="panel-heading clearfix panel-theame">
                <i class="material-icons">casino</i> Issue
                <div class="pull-right">
                    <?php
//                if (isset(Yii::app()->user->havePermissionOn['mov_issue_add']) ||  Yii::app()->user->authorised_user == 1) {
                    ?>
                    <button class="btn btn-xs btn-theme" onclick="loadPopupModal('logistics/Goodsissue/create', 'Issue', 'xl')"> <i class="fa fa-plus"></i> ADD</button>
                    <button class="btn btn-xs btn-theme" onclick="loadPopupModal('logistics/Goodsissue/UploadIssue', 'Upload Issue', 'xl')"> <i class="fa fa-upload"></i> UPLOAD</button>
                    <button class="btn btn-xs btn-theme" onclick="loadPopupModal('logistics/Goodsissue/UpdateGoodsissueUpload', 'Issue Update Status Form', 'xl')"> <i class="fa fa-refresh"></i> UPDATE</button>
                    <!--<a href="<?php //echo $baseUrl . '/uploads/documents/sample_issue_upload.csv' ?>" class="btn btn-xs btn-theme"><i class="fa fa-download"></i> FORMAT</a>-->
                    <?php
//                }
                    ?>
                </div>
            </header>
            <div class="panel-body">
                <div class="custom-data-table">
                    <table class="table table-hover table-bordered personal-task" id="tbl_goods_issue_details" style="font-size:13px;">
                        <thead>
                            <tr>
                                <th>Issue No</th>
                                <th>Issue Date</th>
                                <th>Customer</th>
                                <th>Reference</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </section>
    </div>
    <div class="tab-pane" id="inventory_goods_issue_2">
        <?php $this->renderPartial("../checkin/goods_issue_index", array('frm' => 'GI')); ?>
    </div>
    <div class="tab-pane" id="inventory_goods_issue_3">
        <?php $this->renderPartial("../packaging/goods_issue_index", array('frm' => 'GI')); ?>
    </div>
</div>
