<?php    
 $form = $this->beginWidget('CActiveForm', array( 
     'id' => 'dispute-form', 
     'enableAjaxValidation' => false,
     'enableClientValidation' => false, 
     ));
     
     
?>    
    <ul class="clearfix form-ul material"> 

         <?php 
         echo $form->hiddenField($model, 'id'); 
        ?>
         <li class="col-sm-3">
            <?php echo $form->dropDownList($model, 'customer_id',Customer::getCustomers(), array('data-label'=>'Customer <span style="color:red">*</span>','data-search'=>true,'empty'=>'--select--')); ?>
                <?php echo $form->error($model, 'customer_id'); ?> 
        </li> 
        
         <li class="col-sm-2">   
                <?php 
                if((int) $model->id==0){
                    $model->dispute_date=date('d/m/Y');
                }
                else{
                    $model->dispute_date=date('d/m/Y',strtotime($model->dispute_date));
                }
                echo $form->textField($model, 'dispute_date', array('class' => 'datepicker', 'title' => 'Date','data-label'=>'Date <span style="color:red">*</span>')); ?>      
                <?php echo $form->error($model, 'dispute_date'); ?>     
                
        </li>  
        
         <li class="col-sm-3">
            <?php echo $form->dropDownList($model, 'job_order_id',JobOrder::getJobOrders(), array('data-label'=>'Job Order <span style="color:red">*</span>','data-search'=>true,'empty'=>'--select--','onchange'=>'getJobOrderDetails();')); ?>
                <?php echo $form->error($model, 'job_order_id'); ?> 
        </li> 
         
        <li class="col-sm-2">
            <?php echo $form->dropDownList($model, 'type',MasDisputeType::getAllDisputeType(), array('data-label'=>'Type <span style="color:red">*</span>','empty'=>'--select--')); ?>
                <?php echo $form->error($model, 'type'); ?> 
        </li> 
       
        <li class="col-sm-2">
            <?php echo $form->dropDownList($model, 'status',MasDisputeStatus::getAllDisputeStatus(), array('data-label'=>'Status <span style="color:red">*</span>','empty'=>'--select--')); ?>
                <?php echo $form->error($model, 'status'); ?> 
        </li> 
        
        <?php
        $li_job_order_details="";
        if((int) $model->id == 0){
            $li_job_order_details="display:none;";
        }
        ?>
        
        <li class="col-sm-12" style="<?php echo $li_job_order_details;?>" id="li_job_order_details">
        <span id="success_message">
            
            <?php
            if((int) $model->id > 0 && (int) $model->job_order_id > 0){
                $job_order_id           = (int) $model->job_order_id;
                $modelJobOrder          = JobOrder::model()->findByPk($job_order_id);
            
            ?>
            <div class="alert alert-success">
            <table class="table table-hover table-bordered personal-task" id="tbl_customer_contact">
               
                <tbody>
                    <tr>
                        <th colspan="5"><span style="background-color: orange;color:white;width:250px;text-align:center;border-radius:5px;"><b>Job Order Details</b></span></th>
                    </tr>
                    <tr>
                        <td>Customer</td>
                        <th><?php echo $modelJobOrder->customer->customer_name;?></th>
                        <td>Job Date</td>
                        <th><?php echo date('d/m/Y',strtotime($modelJobOrder->job_date));?></th>
                        <td>Shipper</td>
                        <th><?php echo $modelJobOrder->shipper_id;?></th>
                    </tr>
                    
                    <tr>
                        <td>Consignee</td>
                        <th><?php echo $modelJobOrder->consignee_id;?></th>
                        <td>Origin</td>
                        <th><?php echo $modelJobOrder->org->country_name;?></th>
                        <td>Destination</td>
                        <th><?php echo $modelJobOrder->dest->country_name;?></th>
                    </tr>
                    
                    <tr>
                        <td>Assign Job</td>
                        <th><?php echo $modelJobOrder->leadowner->fullName;?></th>
                        <td>Weignt(KG)</td>
                        <th><?php echo $modelJobOrder->weight;?></th>
                        <td>Volume(CBM)</td>
                        <th><?php echo $modelJobOrder->volume;?></th>
                    </tr>
                    <tr>
                        <td>Customer Reference</td>
                        <th><?php echo $modelJobOrder->customer_reference_no;?></th>
                        <td>Selling Price</td>
                        <th style="text-align:right"><?php echo $modelJobOrder->selling_price;?></th>
                        <td>Payment Terms</td>
                        <th><?php echo $modelJobOrder->paymentmethod->payment_terms;?></th>
                    </tr>
                </tbody>
                </table>
                </div>
            <?php } ?>
            
        </span>
       </li>
      
         <li class="col-sm-12">   
                <?php echo $form->textArea($model, 'notes', array('class' => 'tooltipster', 'title' => 'Please enter note','data-label'=>'Notes','data-validation'=>'required' )); ?>      
                <?php echo $form->error($model, 'notes'); ?>     
                
        </li>  
       
    </ul>
    
    
<div class="modal-footer">
    <button type="button" class="btn btn-danger" data-dismiss="modal" id="dispute_close">Close</button>
    <?php
     $url = Yii::app()->createUrl('logistics/dispute/save');
                echo CHtml::ajaxSubmitButton('Save', $url, array(
                            'dataType' => 'json',
                            'type' => 'post',
                            'success' => 'function(data) {
                             if(data.status=="success"){
                                $("#dispute_close").click();
                                reloadTable("#tbl_dispute_list");
                             } 
                             else 
                             { 
                                   $("#dispute-form .dispute-btn").prop("disabled", false);
                                    $.each(data, function(key, val) {    
                                        $("#dispute-form #"+key+"_em_").text(val).show();
                                        t8.error(""+val+"");     
                                    });    
                                } 
                            }',
                            'beforeSend' => 'function(){
                            $("#loader").show(); 
                                $("#dispute-form .dispute-btn").prop("disabled", true);  
                                $("#dispute-form .dispute-btn").addClass("btn_loading").removeClass("btn-theme"); 
                                $(".toast8-error").hide();                                 
                                
                            }',
                            'complete' => 'function(){
                                $("#loader").hide();                                
                            }'
                                
                    ), array('id' => 'mybtn' . rand(), 'class' => 'customer1-save-btn btn btn-theme'));?>
 
</div> 
<?php $this->endWidget(); ?>

<?php 
 $cs = Yii::app()->getClientScript();
$cs->registerScript("getJobOrderDetails", "function getJobOrderDetails(){
 
        var job_order_id = $('#Dispute_job_order_id').val();
        jQuery.ajax({
            'data' :{'job_order_id':job_order_id},
            'type':'post',
            'dataType' : 'json',
            'url': '" . Yii::app()->createUrl('logistics/joborder/GetJobOrderDetails') . "',
            'success': function(data) {
              
              var success_msg = data.success;
              
              $('#success_message').html('<div class=\"alert alert-success\">'+success_msg+'</div>');
              $('#li_job_order_details').show();
            }
                  
              
        });
    
}", CClientScript::POS_HEAD); 

