<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadTransfers", '
        $(document).ready(function() {
            $("#tbl_directtransfer_details").DataTable({
                scrollY         : "645px",
                pageLength      : 50,
                processing: true,
                ajax: {
                    url: "' . Yii::app()->createUrl('logistics/iwarehouse/Getlist') . '",
                    type: "POST",
                    cache : false,
                },
                serverSide:     true,
                aaSorting : [[ 0, "desc" ]],
                fixedColumns:   true,
                processing: true,

            });
    });', CClientScript::POS_HEAD);
?>
<ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
    <li id="pk_li" onclick="reloadTable('#tbl_packing_list');"  class="active"><a href="#tab1" data-toggle="tab"><i class="fa fa-truck"></i> Packaging</a></li>
    <!--li id="ck_li" onclick="reloadTable('#tble_tble_check_in');"><a href="#tab2" data-toggle="tab"> <i class="fa fa fa-area-chart"></i> Checkin</a></li-->
    <li id="tr_li" onclick="reloadTable('#tbl_directtransfer_details');"><a href="#tab2" data-toggle="tab"><i class="fa fa-globe"></i> Transfer</a></li>
</ul>
<div class="tab-content">

    <div class="tab-pane active" id="tab1">
    <section class="panel">
         <header class="panel-heading clearfix panel-theame">
                <div class="pull-right">
                    <?php if (isset(Yii::app()->user->havePermissionOn['direct_transfer_add']) || Yii::app()->user->authorised_user == 1) {?>
                    <button class="btn btn-xs btn-theme" onclick="loadPopupModal('logistics/iwarehouse/directcreate','New Transfer W/h -> W/h','xl')"><i class="fa fa-plus"></i> ADD</button>
                    <?php }?>
                </div>
            </header>
            <div class="panel-body">
                <div class="custom-data-table">
                    <table class="table table-hover table-bordered personal-task" id="tbl_packing_list">
                        <thead>
                            <tr>
                                <th>No</th>
                                <th>File#</th>
                                <th>Date</th>
                                <th>Customer</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </section>
    </div>
    <!--div class="tab-pane" id="tab2">
    <section class="panel">
                <div class="panel-body">
                    <div class="custom-data-table">
                        <table class="table table-hover table-bordered personal-task" id="tble_tble_check_in">
                            <thead style="width: 100%;">
                                <tr>
                                <th>No</th>
                                <th>File#</th>
                                <th>Date</th>
                                <th>Customer</th>
                                <th>Status</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </section>
        </div-->
        <div class="tab-pane" id="tab2">
        <section class="panel">
           
            <div class="panel-body">
                <div class="custom-data-table">
                    <table class="table table-hover table-bordered personal-task" id="tbl_directtransfer_details">
                        <thead>
                            <tr>
                                <th>Transfer No</th>
                                <th>From Warehouse</th>
                                <th>To Warehouse</th>
                                <th>Description</th>
                                <th>Reference</th>
                                <th>Transfer Date</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </section>
    </div>
    
</div>
<script>
    var table_id ="#tbl_packing_list";
    var table = $(table_id).DataTable({
        scrollY         : "645px",
        pageLength      : 100,
		processing: true,
	            "columnDefs": [
	                {
	                   "targets": [5],
	                   "visible": false,
	                },
	            ],
            
        ajax: {
            url: "<?php echo Yii::app()->createUrl('logistics/packaging/GetList&frm=DTOUT');?>",
            type: "POST",
            cache : false,
        },
        serverSide:     true,
        fixedColumns:   true,
		processing: true,
        fixedHeader: {
            headerOffset: $("header.main").outerHeight()
        },
        "fnCreatedRow"  : function( nRow, aData, iDataIndex ){
     		$(nRow).addClass("context-menu");
 		},
 		"fnRowCallback" : function( nRow, aData, iDisplayIndex, iDisplayIndexFull){
     
	     	$("#tbl_packing_list tbody").mousedown(function (e) {   
	         $(this).contextMenu({
	             selector: ".context-menu",
	            callback: function(key, options) {
	         	var action_id = key;
					var data = table.row( this ).data();
					var id=data[0];
					var part_number = data[1];
					var status = data[5];
					if(action_id == "convert"){
						loadPopupModal("logistics/packaging/create&id="+id+"&status="+status,"Convert - "+id ,"lg");
					}
					else if(action_id == "edit"){
						loadPopupModal("logistics/iwarehouse/directcreate&id="+id+"&status="+status,"Edit - "+id ,"xl");
					} 
	
					
	     		},
	             items: {
	            	 <?php //if(isset(Yii::app()->user->havePermissionOn['mov_issue_view']) ||  Yii::app()->user->authorised_user == 1){ ?>
	                 		"convert": {name: "Convert", icon: "fa-retweet"},
	                 <?php //} ?>
	                 <?php //if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mov_issue_view"])){ ?>
	                 		"edit": {name: "Edit", icon: "fa-edit"},
	                 <?php //} ?>
	             }
	         }
	         );
	     });     
	 }
    } );

    var table_2 = $('#tble_tble_check_in').DataTable({
        scrollY         : "645px",
        pageLength      : 50,
        processing: true,
        columns:[
                 {className:"nw sl col-max-1"},
                 {className:"nw sl col-max-4"},
                 {className:"nw sl col-max-5"},
                 {className:"nw sl col-max-3"},
                 {className:"nw sl col-max-3"},
             ],
        ajax: {
            url: "<?php  echo Yii::app()->createUrl('logistics/checkin/GetList&frm=DTCK') ?>",
            type: "POST",
            cache : false,
        },
        serverSide:     true,
        fixedColumns:   true,
        processing: true,
	 	"fnCreatedRow"  : function( nRow, aData, iDataIndex ){
    		$(nRow).addClass("context-menu");
		},
		"fnRowCallback" : function( nRow, aData, iDisplayIndex, iDisplayIndexFull){
    
    	$("#tble_tble_check_in tbody").mousedown(function (e) {   
        $(this).contextMenu({
            selector: ".context-menu",
           callback: function(key, options) {
        	var action_id = key;
				var data = table_2.row( this ).data();
				var id=data[0];
				var part_number = data[1];
                                var status = data[5];
				if(action_id == "convert"){
					loadPopupModal("logistics/checkin/create&id="+id+"&status="+status,"Items - "+id ,"xl");
				}
    },
            items: {
           	 <?php //if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["rawmaterial_edit"])){ ?>
           			"convert": {name: "Convert", icon: "fa-retweet"},
                <?php //} ?>
            }
        }
        );
    });     
}
});
</script>