<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-arrows-h"></i> Change Rack and Bin
    </header>
    <div class="panel-body">
        <div class="tab-content">
            <div class="tab-pane active">
                    <ul class="clearfix form-ul material">
                        <li class="col-sm-2 m-select">            
                            <?php echo CHtml::dropDownList('warehouse_id', '', MasInventoryWarehouse::getWarehouse(), array('class' => 'tooltipster', 'data-label' => 'Warehouse <span style="color : red;">*</span>', 'data-search' => 'true')); ?>            
                        </li>
                        <li class="col-sm-4">
                            <?php echo CHtml::textField('product_name', '', array('class' => 'tooltipster', 'placeholder' => 'Please choose a product', 'data-label' => 'Part No <span style="color : red;">*</span>', 'onKeyup' => 'js:autoCompleteChangeRackBinProduct(this.id,"changerack");')); ?>
                            <?php echo CHtml::hiddenField('product_id'); ?>
                            <?php echo CHtml::hiddenField('total_qty'); ?>
                            <?php echo CHtml::hiddenField('have_serial_no'); ?>
                        </li>
                        <li class="col-sm-2 m-select">            
                            <?php echo CHtml::dropDownList('rack_id', '', MasInvRack::getRacks(), array('class' => 'tooltipster', 'data-label' => 'Rack <span style="color : red;"></span>', 'data-search' => 'true', 'empty' => 'Select')); ?>            
                        </li>
                        <li class="col-sm-2 m-select">            
                            <?php echo CHtml::dropDownList('bin_id', '', MasInvBin::getBins(), array('class' => 'tooltipster', 'data-label' => 'Bin <span style="color : red;"></span>', 'data-search' => 'true', 'empty' => 'Select')); ?>            
                        </li>
                        <li class="col-sm-2">      
                            <input type="button" value="Search" onclick="loadProductDetails();return false;" class='btn btn-theme' id="rack_bin_btn"/>
                        </li>
                    </ul>
                    <div id="stock-details-div"></div>
            </div>
        </div>
    </div>
</section>                
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadProductDetails", "function loadProductDetails(){
        var warehouse_id = $('#warehouse_id').val();
        var product_id = $('#product_id').val();        
        var rack_id    = $('#rack_id').val(); 
        var bin_id     = $('#bin_id').val();
        var serialno  = $('#have_serial_no').val();  
        $('#stock-details-div').html('');
        if(warehouse_id!='' & product_id!=''){
            var pars = 'warehouse_id='+warehouse_id+'&product_id='+product_id+'&rack_id='+rack_id+'&bin_id='+bin_id+'&serialno='+serialno;            
            jQuery.ajax({
                'type': 'post',
                'data': pars,
                'url': '" . Yii::app()->createUrl('iwarehouse/fetchMaterialDetails') . "',
                'cache': false,
                'success': function(data){
                    $('#loader').hide();
                    $('#stock-details-div').html(data);
                    $('#total_qty').val(data.total_qty);                 
                },
                'beforeSend': function(data){               
                    $('#loader').show();
                },
                'complete': function(data){              
                    $('#loader').hide();
                },
            });
        }
        else{
            t8.error('Please fill all mandatory fields');
            $('#stock-details-div').html('');
            $('#total_qty').val('0'); 
        }
}", CClientScript::POS_HEAD);
$cs->registerScript("autoCompleteChangeRackBinProduct", "function autoCompleteChangeRackBinProduct(field_id,frm){        
	var url = '" . Yii::app()->createUrl('iwarehouse/GetRackBinProduct') . "'+'&frm='+frm;
        $('#'+field_id).autocomplete({
            minLength   : 1,
            source      : function (request, response) { autoCompleteSource(request, response,url) },
            focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},
            select          : function( event, ui ) {
                event.preventDefault();
                trigger_target_id  	=   $(event.target).attr('id');
                var part_num=ui.item.product_id;
                $('#product_id').val(part_num);
                $('#have_serial_no').val(ui.item.serialno);
            }
        });
}", CClientScript::POS_HEAD);
?>    