<?php
$end_year = (int) date('Y');
$condition = "transaction_date > '2010-01-01' ";
$stock = StockLedger::model()->find(
        array(
            'condition' => $condition,
            'order' => 'transaction_date'
        )
);

$start_year = date('Y', strtotime($stock->transaction_date));
?>
<script type="text/javascript">

    function LoadMaterialYear() {

        var table_id = "#tble_material_year";

        var material_table = $(table_id).DataTable({
            "autoWidth": true,
            retrieve: true,
            scrollY: "450px",
            pageLength: 10,
            processing: true,
            "ordering": false,
            "searching": false,

            "columnDefs": [
                {
                    //"targets": [5],
                    //"visible": false,
                },
            ],
            ajax: {
                url: "index.php?r=logistics/customerinfo/GetmaterialYearWise",
                type: "POST",
                data: {
                    id: '<?= $id ?>',
                    'start_year':<?= $start_year ?>,
                    'end_year':<?= $end_year ?>,
                },
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,

            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $("td:gt(1)", nRow).addClass("text-right");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                //console.log(aData);
                AddClickToRow(nRow, aData);


            },
        });
        /// table 2
        var table_2_id = "#tble_material_year_month";
        var item_id = $("#item_id").val();
        var material_table_year_month = $(table_2_id).DataTable({
            "autoWidth": true,
            retrieve: true,
            scrollY: "450px",
            pageLength: 25,
            processing: true,
            "ordering": false,
            "searching": false,
            "columnDefs": [
                {
                    //"targets": [5],
                    //"visible": false,
                },
            ],
            ajax: {
                url: "index.php?r=logistics/customerinfo/GetmaterialYearMonthWise",
                type: "POST",
                data: function (d) {
                    d.id = '<?= $id ?>';
                    d.start_year =<?= $start_year ?>;
                    d.end_year =<?= $end_year ?>;
                    d.item_id = $("#item_id").val();
                    d.it = 0;
                },
                cache: false,
            },
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $("td:gt(0)", nRow).addClass("text-right");
                $("td:last-child", nRow).addClass("font-weight-bold");
                //
                if (aData[0] == "Total") {
                    $("td", nRow).addClass("font-weight-bold");
                }
            },
            serverSide: true,
            fixedColumns: true,

            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },

        });

    }</script> 
<div class="custom-data-table" id="material_year">

    <table class="table table-hover table-bordered personal-task" id="tble_material_year">
        <thead>
            <tr>
                <th>Part Number</th>
                <th>Description</th>
                <?php for ($index = $start_year; $index <= $end_year; $index++) {
                    ?>
                    <th  class="text-right"><?= $index ?></th>
                    <?php
                }
                ?>
            </tr>
        </thead>

    </table>
</div>
<div class="custom-data-table" id="material_year_month" style="display: none">
    <div class="panel-body" style="padding: 0px;margin: 0px;height: 10px;">
        <div class="pull-left ">
            <label id="item_name" style="font-size: 14px;" class="label label-warning"> </label>
            <input type="hidden" id="item_id" value="0" />
        </div>
        <div class="pull-right">
            <input type="button" value="back" class="btn btn-primary" onclick="backToYear();" />
        </div>
    </div>
    <br>
    <table class="table table-hover table-bordered personal-task" id="tble_material_year_month">
        <thead>
            <tr>
                <th>Month</th>                
                <?php for ($index = $start_year; $index <= $end_year; $index++) {
                    ?>
                    <th class="text-right"><?= $index ?></th>
                    <?php
                }
                ?>
                    <th  class="text-right" >Total</th> 
            </tr>
        </thead>

    </table>
</div>
<script type="text/javascript">
    function AddClickToRow(nRow, aData) {
        $(nRow).click(function () {
            LoadMaterialYearMonth(aData[5], aData[0], aData[1]);
        })
    }

    function LoadMaterialYearMonth(id, part_num, desc) {
        // alert(id);
        $("#item_id").val(id);
        $("#item_name").html(part_num + " : " + desc);
        $("#material_year").hide();
        $("#material_year_month").show();
        reloadTable('#tble_material_year_month');

    }
    function backToYear() {
        $("#material_year").show();
        $("#material_year_month").hide();
        return false;
    }

</script> 
<style>
    .font-weight-bold{
        font-weight: 650;
        font-size: 16px;
    }
</style>