<?php
$cs = Yii::app()->getClientScript();
?>
<script>
    $(document).ready(function () {
        loadCreditNoteList();
        loadCheckinList();
    });


    function loadCreditNoteList() {
        var table_id = "#tbl_credit_note_list";
        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            data.display_type = $("#display_type").val();
            return data;
        }).DataTable({
        scrollY         : "645px",
                pageLength      : 50,
                processing: true,
                columns:[
                {className:"nw sl col-max-1"},
                {className:"nw sl col-max-2"},
                {className:"nw sl col-max-2"},
                {className:"nw sl col-max-2"},
                {className:"nw sl col-max-1"},
                {className:"nw sl col-max-1"},
                {className:"nw sl col-max-3 text-right"},
                {className:"nw sl col-max-3 text-right"},
                {className:"nw sl col-max-1 text-right"},
                {className: "sl col-max-1"},
                ],
                "columnDefs": [
                {
                "targets": [],
                        "visible": false,
                },
                ],
                 "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
               
                        if ( aData[13] == "N" ){
                                $("td", nRow).css("background-color", "#e4a3a3");
                        }
                 },
                ajax: {
                url: "<?php echo Yii::app()->createUrl('logistics/creditnote/GetCreditNoteList') ?>",
                        data: {"frm":<?php echo $frm; ?>},
                        type: "POST",
                        cache : false,
                },
                serverSide:     true,
                fixedColumns:   true,
                processing: true,
                "fnCreatedRow"  : function (nRow, aData, iDataIndex) {
                    $(nRow).addClass("context-menu");
                }
        });
            $('#tbl_credit_note_list tbody').on('mouseover', 'tr', function () {
                $.contextMenu('destroy');
            });
              $('#tbl_credit_note_list tbody').on('click', 'tr', function () {
                var data = table.row(this).data();
                var posted = data[11];
                var invoice_posted = data[12];
                var id = data[1];
                    $.contextMenu({
                    selector: '.context-menu',
                    callback: function(key, options) {
                        var action_id = key;
                        var id = data[1];
                        var file_id = data[0];
                        var customer_name = data[3];
                        var check_hire = data[10];
                        var invoice_posted = data[12];
                        if (action_id == "print") {
                                window.open($('#liveSite').val() + "/index.php?r=logistics/creditnote/printfile&file=" + file_id + "&id=" + id, "_blank")
                        }
                        else if (action_id == "cancel") {
                            var r = confirm('Are you sure to cancel this creditnote?');
                            if(r==true)
                            {
                                jQuery.ajax({
                                  'type'  : 'post',
                                  'data'  : 'id=' + id,
                                  'url'  : $('#liveSite').val()+'index.php?r=logistics/creditnote/cancelcreditnote',
                                  'cache': false,
                                  'success':function(data){
                                    if(data=='fail'){
                                        t8.error('Error');
                                    }else {
                                        t8.success('Creditnote cancelled');
                                        reloadTable('#tbl_credit_note_list');
                                    }
                                   }
                                });
                           }
                        }
                        else if(action_id == "post"){
                           jQuery.ajax({
                            'type': 'post',
                            'url': $('#liveSite').val() +"/index.php?r=finance/core/savemodulevouchers",
                            'data' : {'voucher_selection' : '10','type':'direct','status' : 'NEW','ids[]': id},
                            'success': function(data) { 
                            t8.success("Posted!");
                            reloadTable("#tbl_credit_note_list");
                            }
                        });
                    }
                    else if(action_id == "unpost"){
                           jQuery.ajax({
                            'type': 'post',
                            'url': $('#liveSite').val() +"/index.php?r=finance/core/savemodulevouchers",
                            'data' : {'voucher_selection' : '10','type':'direct','status' : 'EXISTING','ids[]': id},
                            'success': function(data) { 
                            t8.success("Unposted!");
                            reloadTable("#tbl_credit_note_list");
                            }
                        });
                    }
                    },
                    items: {
                       
                        <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["credit_note_print"])) { ?>
                                                            "print": {name: "Print", icon: "fa-print"},
                        <?php } ?>
                               <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["finance_voucher_import"])) { ?>
                                    "post": {name: "Post", icon: "fa-send", disabled: function(key, opt) {     
                                    if (invoice_posted == 'Y'){
                                        return !this.data('postDisabled');
                                    }
                                }},
                        <?php } ?>
                        
                          <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["finance_voucher_import"])) { ?>
                        "unpost": {name: "Unpost", icon: "fa-retweet", disabled: function(key, opt) {
                                    if (invoice_posted == 'N' ){
                                        return !this.data('unpostDisabled');
                                    }
                                }},
        <?php } ?>
                        
                        
            
                        <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["finance_voucher_import"])) { ?>
                                "cancel": {name: "Cancel", icon: "fa-warning", disabled: function(key, opt) {
                                    if (invoice_posted == 'Y' ){
                                        return !this.data('cancelDisabled');
                                    }
                                }}
        <?php } ?>
            
                    }
                });
            });
    }

</script>
<section class="panel"  style="background-color:#F6F3EE;">
    <input type="hidden" name="frm" id="frm" value="<?php echo $frm; ?>">
    
            <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-money"></i> Credit Note
            <div class="pull-right">
                <div class="col-md-12">
                  <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["credit_note_add"])) { ?> 
                                             
                            <button class="btn btn-sm btn-theme" id="add_popup" onclick="loadPopupModal('logistics/creditnote/create', 'Add New Credit Note', 'xl')"><i class="fa fa-plus"></i> ADD</button>

                    <?php } ?>
                </div>
            </div>
        </header>   
        <div class="panel-body">
                <div class="custom-data-table">
                    <table class="table table-hover table-bordered personal-task" id="tbl_credit_note_list"  style="font-size:13px;">
                        <thead>
                            <tr>
                                <th>File#</th>
                                <th>Credit Note #</th>
                                <th>Invoice No</th>
                                <th>Customer</th>
                                <th>Credit Date</th>
                                <th>Currency</th>
                                <th>Invoice Amount</th>
                                <th>VAT</th>
                                <th>Credit Amount</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                    </table>

                </div>
                
                
                 <div class="color-indicator">
                <span style="display: inline-block;width:30px;height:30px;background:#e4a3a3; box-shadow: 0px 2px 10px 2px #e4a3a3"></span><span class="verti"> <b>Cancelled</b></span>
            </div>
                
                
            </div>
</section>
