<?php

/**
 * This is the model class for table "{{quotation_items}}".
 *
 * The followings are the available columns in table '{{quotation_items}}':
 * @property integer $id
 * @property integer $quotation_id
 * @property integer $activity_type
 * @property string $planned_weight
 * @property string $planned_volume
 * @property string $planned_cost
 * @property string $planned_selling_price
 * @property integer $status
 * @property string $notes
 * @property string $last_updated_status
 * @property string $last_status_api_content
 */
class QuotationItems extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
    
         public $chargeable_weight;
	public function tableName()
	{
		return '{{quotation_items}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('forwarder_id,planned_selling_price', 'required'),
			array('quotation_id,forwarder_id,activity_type,mode_id', 'numerical', 'integerOnly'=>true),
			array('planned_weight, planned_volume', 'length', 'max'=>10),
			array('priority_agent', 'length', 'max'=>1),
			array('planned_cost, planned_selling_price,profit_val', 'length', 'max'=>15),
			array('	mode_transit_time', 'length', 'max'=>150),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, quotation_id, activity_type, planned_weight, planned_volume, planned_cost, planned_selling_price, notes', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'vendordetails' => array(self::BELONGS_TO, 'Vendor', 'forwarder_id'),
            'quotation' => array(self::BELONGS_TO, 'Quotation', 'quotation_id'),
            'activitytype' => array(self::BELONGS_TO, 'MasJobOrderActivityType', 'activity_type'),
            'vendormode' => array(self::BELONGS_TO, 'MasVendorMode', 'mode_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'quotation_id' => 'Quotation',
			'activity_type' => 'Activity Type',
			'planned_weight' => 'Planned Weight',
			'planned_volume' => 'Planned Volume',
			'planned_cost' => 'Planned Cost',
			'planned_selling_price' => 'Planned Selling Price',
			'notes' => 'Notes',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('quotation_id',$this->quotation_id);
		$criteria->compare('activity_type',$this->activity_type);
		$criteria->compare('planned_weight',$this->planned_weight,true);
		$criteria->compare('planned_volume',$this->planned_volume,true);
		$criteria->compare('planned_cost',$this->planned_cost,true);
		$criteria->compare('planned_selling_price',$this->planned_selling_price,true);
		$criteria->compare('notes',$this->notes,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return QuotationItems the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
