<?php

/**
 * This is the model class for table "{{quotation}}".
 *
 * The followings are the available columns in table '{{quotation}}':
 * @property integer $id
 * @property integer $file_id
 * @property integer $customer_id
 * @property string $contact_ids
 * @property string $quotation_date
 * @property integer $origin_id
 * @property integer $destination_id
 * @property string $shipper_id
 * @property string $consignee_id
 * @property string $weight
 * @property string $volume
 * @property integer $currency_id
 * @property string $exchange_rate
 * @property string $booking_reference
 * @property string $customer_reference_no
 * @property string $selling_price
 * @property string $remarks
 * @property string $terms_and_conditions
 * @property integer $lead_owner_id
 * @property integer $transport_type
 * @property integer $payment_terms_id
 * @property string $quotation_status
 * @property string $total_planned_weight
 * @property string $total_planned_volume
 * @property string $total_planned_cost
 * @property string $isActive
 * @property string $quotation_priority
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class Quotation extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public $terms_id;
	public $client_type;
	public $client_category;
	public function tableName()
	{
		return '{{quotation}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
		    array('quotation_date, origin_id, destination_id,lead_owner_id,customer_id,payment_terms_id,contact_ids', 'required'),
			array('file_id, customer_id, transit_time, origin_id, destination_id, currency_id, lead_owner_id, transport_type, payment_terms_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('contact_ids, shipper_id, consignee_id, weight, volume, chargeable_weight, booking_reference, customer_reference_no,qtn_close_reason', 'length', 'max'=>255),
			array('exchange_rate', 'length', 'max'=>7),
			array('selling_price, total_planned_cost,no_of_pieces', 'length', 'max'=>15),
			array('quotation_status, quotation_priority', 'length', 'max'=>2),
			array('total_planned_weight, total_planned_volume', 'length', 'max'=>10),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, file_id, customer_id, contact_ids, quotation_date, origin_id, destination_id, shipper_id, consignee_id, weight, volume, currency_id, exchange_rate, booking_reference, customer_reference_no, selling_price, remarks, terms_and_conditions, lead_owner_id, transport_type, payment_terms_id, quotation_status, total_planned_weight, total_planned_volume, total_planned_cost, isActive, quotation_priority, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
            'leadowner' => array(self::BELONGS_TO, 'User', 'lead_owner_id'),
            'file' => array(self::BELONGS_TO, 'MasterFile', 'file_id'),
            'customer' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
            'currency' => array(self::BELONGS_TO, 'MasCurrency', 'currency_id'),
            'transporttype' => array(self::BELONGS_TO, 'MasTransportType', 'transport_type'),
            'shipper' => array(self::BELONGS_TO, 'Customer', 'shipper_id'),
            'consignee' => array(self::BELONGS_TO, 'Customer', 'consignee_id'),
            'invoice' => array(self::HAS_ONE, 'Invoice', 'order_id'),
            'dest' => array(self::BELONGS_TO, 'MasCountry', 'destination_id'),
            'org' => array(self::BELONGS_TO, 'MasCountry', 'origin_id'),
            'paymentmethod' => array(self::BELONGS_TO, 'MasPaymentTerm','payment_terms_id'),
            'transittime' => array(self::BELONGS_TO, 'MasTransitTime', 'transit_time'),
            'createdby' => array(self::BELONGS_TO, 'User', 'created_by'),
           'contacts' => array(self::BELONGS_TO, 'CustomerContact', 'contact_ids'),
          	'totalSellingPrice' => array(self::STAT, 'QuotationItems', 'quotation_id','select'=>'SUM(planned_selling_price)'),
          	'totalCostPrice' => array(self::STAT, 'QuotationItems', 'quotation_id','select'=>'SUM(planned_cost)'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'file_id' => 'File',
			'customer_id' => 'Customer',
			'contact_ids' => 'Contact Ids',
			'quotation_date' => 'Quotation Date',
			'origin_id' => 'Origin',
			'destination_id' => 'Destination',
			'shipper_id' => 'Shipper',
			'consignee_id' => 'Consignee',
			'weight' => 'Weight',
			'volume' => 'Volume',
			'currency_id' => 'Currency',
			'exchange_rate' => 'Exchange Rate',
			'booking_reference' => 'Booking Reference',
			'customer_reference_no' => 'Customer Reference No',
			'selling_price' => 'Selling Price',
			'remarks' => 'Remarks',
			'terms_and_conditions' => 'Terms And Conditions',
			'lead_owner_id' => 'Lead Owner',
			'transport_type' => 'Transport Type',
			'payment_terms_id' => 'Payment Terms',
			'quotation_status' => 'O-Open,C-Completed,PD-Partially Delivered,D-Delivered,I-Invoiced,CN-cancelled',
			'total_planned_weight' => 'Total Planned Weight',
			'total_planned_volume' => 'Total Planned Volume',
			'total_planned_cost' => 'Total Planned Cost',
			'isActive' => 'Is Active',
			'quotation_priority' => 'Quotation Priority',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('file_id',$this->file_id);
		$criteria->compare('customer_id',$this->customer_id);
		$criteria->compare('contact_ids',$this->contact_ids,true);
		$criteria->compare('quotation_date',$this->quotation_date,true);
		$criteria->compare('origin_id',$this->origin_id);
		$criteria->compare('destination_id',$this->destination_id);
		$criteria->compare('shipper_id',$this->shipper_id,true);
		$criteria->compare('consignee_id',$this->consignee_id,true);
		$criteria->compare('weight',$this->weight,true);
		$criteria->compare('volume',$this->volume,true);
		$criteria->compare('currency_id',$this->currency_id);
		$criteria->compare('exchange_rate',$this->exchange_rate,true);
		$criteria->compare('booking_reference',$this->booking_reference,true);
		$criteria->compare('customer_reference_no',$this->customer_reference_no,true);
		$criteria->compare('selling_price',$this->selling_price,true);
		$criteria->compare('remarks',$this->remarks,true);
		$criteria->compare('terms_and_conditions',$this->terms_and_conditions,true);
		$criteria->compare('lead_owner_id',$this->lead_owner_id);
		$criteria->compare('transport_type',$this->transport_type);
		$criteria->compare('payment_terms_id',$this->payment_terms_id);
		$criteria->compare('quotation_status',$this->quotation_status,true);
		$criteria->compare('total_planned_weight',$this->total_planned_weight,true);
		$criteria->compare('total_planned_volume',$this->total_planned_volume,true);
		$criteria->compare('total_planned_cost',$this->total_planned_cost,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('quotation_priority',$this->quotation_priority,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Quotation the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
