<?php

/**
 * This is the model class for table "{{purchasing_order_shipment_document}}".
 *
 * The followings are the available columns in table '{{purchasing_order_shipment_document}}':
 * @property integer $id
 * @property integer $purchasing_order_id
 * @property integer $shipment_id
 * @property string $document_name
 * @property string $document_actual_file_name
 * @property string $isActive
 * @property integer $created_by
 * @property string $created_datetime
 */
class PurchasingOrderShipmentDocument extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{purchasing_order_shipment_document}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('purchasing_order_id, shipment_id, document_name, document_actual_file_name', 'required'),
			array('purchasing_order_id, shipment_id, created_by', 'numerical', 'integerOnly'=>true),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, purchasing_order_id, shipment_id, document_name, document_actual_file_name, isActive, created_by, created_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'purchasing_order_id' => 'Purchase Order',
			'shipment_id' => 'Shipment',
			'document_name' => 'Document Name',
			'document_actual_file_name' => 'Document Actual File Name',
			'isActive' => 'Is Active',
			'created_by' => 'Created By',
			'created_datetime' => 'Created Datetime',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('purchasing_order_id',$this->purchasing_order_id);
		$criteria->compare('shipment_id',$this->shipment_id);
		$criteria->compare('document_name',$this->document_name,true);
		$criteria->compare('document_actual_file_name',$this->document_actual_file_name,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_datetime',$this->created_datetime,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return PurchasingOrderShipmentDocument the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
