<?php

/**
 * This is the model class for table "{{purchase_order_addition}}".
 *
 * The followings are the available columns in table '{{purchase_order_addition}}':
 * @property integer $id
 * @property integer $order_id
 * @property string $particular
 * @property string $particular_value
 * @property double $calculated_value
 */
class PurchasingOrderNonstockAdditions extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{purchasing_order_nonstock_addition}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			//array('purchasing_order_id, particular, particular_value, calculated_value', 'required'),
			array('purchasing_order_id', 'numerical', 'integerOnly'=>true),
			array('calculated_value', 'numerical'),
			array('particular', 'length', 'max'=>255),
			array('particular_value', 'length', 'max'=>50),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, purchasing_order_id, particular, particular_value, calculated_value', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'account' => array(self::BELONGS_TO, 'FinAccounts', 'particular'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'order_id' => 'Order',
			'particular' => 'Particular',
			'particular_value' => 'Particular Value',
			'calculated_value' => 'Calculated Value',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('order_id',$this->order_id);
		$criteria->compare('particular',$this->particular,true);
		$criteria->compare('particular_value',$this->particular_value,true);
		$criteria->compare('calculated_value',$this->calculated_value);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return PurchaseOrderAddition the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
