<?php

/**
 * This is the model class for table "{{purchasing_order_non_stock_item}}".
 *
 * The followings are the available columns in table '{{purchasing_order_non_stock_item}}':
 * @property integer $id
 * @property integer $purchasing_order_id
 * @property string $non_stock_item_name
 * @property string $non_stock_item_description
 * @property string $non_stock_item_unit
 * @property string $non_stock_item_quantity
 */
class PurchasingOrderNonStockItem extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{purchasing_order_non_stock_item}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('purchasing_order_id, non_stock_item_name, non_stock_item_description, non_stock_item_unit, non_stock_item_quantity', 'required'),
			array('purchasing_order_id','numerical', 'integerOnly'=>true),
			array('non_stock_item_name, non_stock_item_description, non_stock_item_unit', 'length', 'max'=>255),
                        array('non_stock_item_quantity','numerical', 'integerOnly'=>true),
			array('non_stock_item_quantity', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, purchasing_order_id, non_stock_item_name, non_stock_item_description, non_stock_item_unit, non_stock_item_quantity', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'purchasing_order_id' => 'Purchasing Order',
			'non_stock_item_name' => 'Non Stock Item Name',
			'non_stock_item_description' => 'Non Stock Item Description',
			'non_stock_item_unit' => 'Non Stock Item Unit',
			'non_stock_item_quantity' => 'Non Stock Item Quantity',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('purchasing_order_id',$this->purchasing_order_id);
		$criteria->compare('non_stock_item_name',$this->non_stock_item_name,true);
		$criteria->compare('non_stock_item_description',$this->non_stock_item_description,true);
		$criteria->compare('non_stock_item_unit',$this->non_stock_item_unit,true);
		$criteria->compare('non_stock_item_quantity',$this->non_stock_item_quantity,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return PurchasingRequisitionNonStockItem the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
