<?php

/**
 * This is the model class for table "{{purchasinginvoice_item}}".
 *
 * The followings are the available columns in table '{{purchasinginvoice_item}}':
 * @property integer $id
 * @property integer $product_id
 * @property integer $invoice_id
 * @property string $description
 * @property double $quantity
 * @property integer $unit
 * @property double $rate
 * @property double $amount
 * @property double $addition_percentage
 * @property double $addition_amount
 * @property double $deduction_percentage
 * @property double $deduction_amount
 * @property double $net_amount
 */
class PurchasingInvoiceItem extends CActiveRecord { 

    /**
     * @return string the associated database table name
     */
    public $product_name;
    public $mr_id;
    public $mr_item_id;


    public function tableName() {
        return '{{purchasinginvoice_item}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('product_id, quantity,rate, amount,job_order_id', 'required'),
            array('id, product_id,order_item_id,job_order_activity_type,job_order_agent_id', 'numerical', 'integerOnly' => true),
            array('quantity, rate, amount, addition_amount, deduction_amount, net_amount,tax_percentage,tax_amount', 'numerical'),
            array('description,unit,deduction_percentage,addition_percentage', 'length', 'max' => 255),
            array('awb_no', 'length', 'max' => 255),
            array('weight,volume,awb_no', 'length', 'max' => 40),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, product_id, purchasing_invoice_id, description, quantity, unit, rate, amount, addition_percentage, addition_amount, deduction_percentage, deduction_amount, net_amount', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'purchasinginvoice' => array(self::BELONGS_TO, 'PurchasingInvoice', 'purchasing_invoice_id'),
            'product' => array(self::BELONGS_TO, 'Inventory', 'product_id'),
            'order_item' =>array(self::BELONGS_TO, 'PurchasingOrderStockItem', 'order_item_id'),
            'unitdetails' => array(self::BELONGS_TO, 'UnitOfMeasurement', 'unit'),
            'activitytype' => array(self::BELONGS_TO, 'MasJobOrderActivityType', 'job_order_activity_type'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'product_id' => 'Product',
            'purchasing_invoice_id' => 'Invoice',
            'description' => 'Description',
            'quantity' => 'Quantity',
            'unit' => 'Unit',
            'rate' => 'Rate',
            'amount' => 'Amount',
            'addition_percentage' => 'Addition Percentage',
            'addition_amount' => 'Addition Amount',
            'deduction_percentage' => 'Deduction Percentage',
            'deduction_amount' => 'Deduction Amount',
            'net_amount' => 'Net Amount',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('product_id', $this->product_id);
        $criteria->compare('purchasing_invoice_id', $this->purchasing_invoice_id);
        $criteria->compare('description', $this->description, true);
        $criteria->compare('quantity', $this->quantity);
        $criteria->compare('unit', $this->unit);
        $criteria->compare('rate', $this->rate);
        $criteria->compare('amount', $this->amount);
        $criteria->compare('addition_percentage', $this->addition_percentage);
        $criteria->compare('addition_amount', $this->addition_amount);
        $criteria->compare('deduction_percentage', $this->deduction_percentage);
        $criteria->compare('deduction_amount', $this->deduction_amount);
        $criteria->compare('net_amount', $this->net_amount);

        if (isset($_POST['product_id']))// if isadmin
            $criteria->condition = "product_id=" . (int) $_POST['product_id'];

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC',
            ),
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 5) : false,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return PurchasinginvoiceItem the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function fill_up_previous()
    {
        if ($this->product_id > 0) {
            $item = Inventory::model()->findBypk($this->product_id);
            $this->previous_quantity = (float) $item->totalQuantity;
            $this->previous_cost_rate = $item->rate;
            $this->update();
        }
    }
    
    public static function getVendor($product_id) {
            $model = self::model()->with('purchasinginvoice')->findAll(array('condition' =>'product_id="'.$product_id.'"','group'=>'purchasinginvoice.vendor_id'));
            return CHtml::listData($model, 'purchasinginvoice.vendor_id', 'purchasinginvoice.vendor_details.vendor_name');
        }

}
