<?php
class PackagingItems extends CActiveRecord {
public $product_name;
    public function tableName() {
        return '{{packaging_items}}';
    }
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('product_id, description, unit, quantity', 'required'),
            array('transaction_id,product_id,unit', 'numerical', 'integerOnly' => true),
            array('quantity,rate', 'numerical'),
            array('description', 'length', 'max' => 100),
            array('id, product_id, description,quantity,unit', 'safe', 'on' => 'search'),
        );
    }
    
    public function relations() {
        return array(
            'package_det' => array(self::BELONGS_TO, 'Packaging', 'package_id'),
            'product' => array(self::BELONGS_TO, 'Inventory', 'product_id'),
            'unitdetails' => array(self::BELONGS_TO, 'MasUnit', 'unit'),
            'goodsreceipt' => array(self::BELONGS_TO, 'GoodsReceipt', 'transaction_id'),
            'mas_warehouse' => array(self::BELONGS_TO, 'MasInventoryWarehouse', 'warehouse_id'),
            'mas_rack' => array(self::BELONGS_TO, 'MasInvRack', 'rack_id'),
            'mas_bin' => array(self::BELONGS_TO, 'MasInvBin', 'bin_id'),
        );
    }
    
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'transaction_id' => 'Transaction ID',
            'product_id' => 'Product',
            'description' => 'Description',
            'unit' => 'Unit',
            'rate' => 'Rate',
            'quantity' => 'Quantity'
        );
    }

    public function search() {
        $criteria = new CDbCriteria;
        $criteria->compare('id', $this->id);
        $criteria->compare('transaction_id', $this->transaction_id);
        $criteria->compare('product_id', $this->product_id);
        $criteria->compare('description', $this->description, true);
        $criteria->compare('unit', $this->unit, true);
        $criteria->compare('quantity', $this->quantity);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
}
